/*
 * Decompiled with CFR 0.152.
 */
package relcontext.relationfix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.tools.I18n;
import relcontext.actions.SortAndFixAction;

public abstract class RelationFixer {
    private List<String> applicableTypes = new ArrayList<String>();
    private SortAndFixAction sortAndFixAction;

    public RelationFixer(String ... types) {
        this.applicableTypes.addAll(Arrays.asList(types));
    }

    public boolean isFixerApplicable(Relation rel) {
        if (rel == null) {
            return false;
        }
        if (!rel.hasKey("type")) {
            return false;
        }
        String type = rel.get("type");
        for (String oktype : this.applicableTypes) {
            if (!oktype.equals(type)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean isRelationGood(Relation var1);

    public abstract Command fixRelation(Relation var1);

    public void setFixAction(SortAndFixAction sortAndFixAction) {
        this.sortAndFixAction = sortAndFixAction;
    }

    protected void setWarningMessage(String text) {
        if (text == null) {
            this.clearWarningMessage();
        } else {
            this.sortAndFixAction.putValue("ShortDescription", text);
        }
    }

    protected void clearWarningMessage() {
        this.sortAndFixAction.putValue("ShortDescription", I18n.tr((String)"Fix roles of the chosen relation members", (Object[])new Object[0]));
    }
}

