/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.util.io;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Tokenizer {
    protected PushbackReader reader_;
    protected StringBuffer buffer_;
    protected String delimiters_ = ",";
    protected int escapeChar_ = 92;
    protected int quoteChar_ = 34;
    protected boolean escapeMode_ = false;
    protected boolean eolIsSignificant_ = true;
    protected boolean respectEscapedChars_ = false;
    protected boolean respectQuotedWords_ = true;
    protected int lineCount_ = 1;
    protected boolean eofReached_ = false;
    protected int lastToken_ = 5;
    public static final int EOF = -1;
    public static final int EOL = 0;
    public static final int WORD = 1;
    public static final int QUOTED_WORD = 2;
    public static final int DELIMITER = 3;
    public static final int ERROR = 4;
    public static final int NOT_STARTED = 5;

    public Tokenizer(String string) {
        this(new StringReader(string));
    }

    public Tokenizer(String string, String delimiters) {
        this(new StringReader(string));
        this.setDelimiters(delimiters);
    }

    public Tokenizer(Reader reader) {
        this.reader_ = new PushbackReader(reader, 2);
        this.buffer_ = new StringBuffer();
    }

    public void setDelimiter(int delimiterChar) {
        this.delimiters_ = new String(new char[]{(char)delimiterChar});
    }

    public int getDelimiter() {
        return this.delimiters_.charAt(0);
    }

    public void setDelimiters(String delimiters) {
        this.delimiters_ = delimiters;
    }

    public String getDelimiters() {
        return this.delimiters_;
    }

    public void setEscapeChar(int escapeChar) {
        this.escapeChar_ = escapeChar;
    }

    public int getEscapeChar() {
        return this.escapeChar_;
    }

    public void respectEscapedCharacters(boolean respectEscaped) {
        this.respectEscapedChars_ = respectEscaped;
    }

    public boolean respectEscapedCharacters() {
        return this.respectEscapedChars_;
    }

    public int getQuoteChar() {
        return this.quoteChar_;
    }

    public void setQuoteChar(int quoteChar) {
        this.quoteChar_ = quoteChar;
    }

    public void respectQuotedWords(boolean respectQuotes) {
        this.respectQuotedWords_ = respectQuotes;
    }

    public boolean respectQuotedWords() {
        return this.respectQuotedWords_;
    }

    public void eolIsSignificant(boolean significant) {
        this.eolIsSignificant_ = significant;
    }

    public boolean isEolSignificant() {
        return this.eolIsSignificant_;
    }

    public int getLineNumber() {
        return this.lineCount_;
    }

    public String getWord() {
        return this.buffer_.toString();
    }

    public int getLastToken() {
        return this.lastToken_;
    }

    protected boolean isDelimiter(int character) {
        if (this.escapeMode_) {
            return false;
        }
        return this.delimiters_.indexOf(character) >= 0;
    }

    protected boolean isQuoteChar(int character) {
        if (!this.respectQuotedWords_) {
            return false;
        }
        if (this.escapeMode_) {
            return false;
        }
        return character == this.quoteChar_;
    }

    protected boolean isEscapeChar(int character) {
        if (!this.respectEscapedChars_) {
            return false;
        }
        if (this.escapeMode_) {
            return false;
        }
        return character == this.escapeChar_;
    }

    protected boolean isEndOfLine(int character) {
        if (this.escapeMode_) {
            if (character == 10) {
                ++this.lineCount_;
            }
            return false;
        }
        if (character == -1) {
            this.eofReached_ = true;
        }
        return character == 10 || character == 13 || character == -1;
    }

    public void close() throws IOException {
        this.reader_.close();
    }

    protected int readNextChar() throws IOException {
        int next_char = this.reader_.read();
        if (this.escapeMode_) {
            this.escapeMode_ = false;
        } else if (this.isEscapeChar(next_char)) {
            next_char = this.reader_.read();
            if (this.isEndOfLine(next_char)) {
                ++this.lineCount_;
                next_char = this.reader_.read();
                if (next_char == 13) {
                    next_char = this.readNextChar();
                }
            }
            this.escapeMode_ = true;
        }
        if (next_char == 13) {
            next_char = this.readNextChar();
        }
        return next_char;
    }

    public int nextToken() throws IOException {
        this.buffer_.setLength(0);
        int next_char = this.readNextChar();
        if (this.eofReached_) {
            this.lastToken_ = -1;
            return -1;
        }
        if (this.isEndOfLine(next_char)) {
            ++this.lineCount_;
            if (this.eolIsSignificant_) {
                this.lastToken_ = 0;
                return 0;
            }
            this.lastToken_ = 3;
            return 3;
        }
        if (this.isDelimiter(next_char)) {
            this.lastToken_ = 3;
            return 3;
        }
        if (this.isQuoteChar(next_char)) {
            while (true) {
                if (this.isEndOfLine(next_char = this.readNextChar())) {
                    this.lastToken_ = 4;
                    return 4;
                }
                if (this.isQuoteChar(next_char)) {
                    this.lastToken_ = 2;
                    return 2;
                }
                this.buffer_.append((char)next_char);
            }
        }
        do {
            this.buffer_.append((char)next_char);
        } while (!this.isDelimiter(next_char = this.readNextChar()) && !this.isEndOfLine(next_char));
        this.reader_.unread(next_char);
        this.lastToken_ = 1;
        return 1;
    }

    public boolean hasNextLine() throws IOException {
        if (this.lastToken_ == -1) {
            return false;
        }
        if (this.lastToken_ == 0 || this.lastToken_ == 5) {
            int next_char = this.readNextChar();
            if (next_char == -1) {
                return false;
            }
            this.reader_.unread(next_char);
        }
        return true;
    }

    public List<String> nextLine() throws IOException {
        int token = this.nextToken();
        ArrayList<String> list = new ArrayList<String>();
        String word = "";
        while (true) {
            switch (token) {
                case 1: {
                    word = this.getWord();
                    break;
                }
                case 2: {
                    word = this.getWord();
                    break;
                }
                case 3: {
                    list.add(word);
                    word = "";
                    break;
                }
                case -1: 
                case 0: {
                    list.add(word);
                    return list;
                }
                default: {
                    System.err.println("Unknown Token: " + token);
                }
            }
            token = this.nextToken();
        }
    }

    public static List<String> removeZeroLengthElements(List<String> list) {
        return Tokenizer.removeZeroLengthElements(list, false);
    }

    public static List<String> removeZeroLengthElements(List<String> list, boolean trim) {
        Iterator<String> iterator = list.iterator();
        ArrayList<String> new_list = new ArrayList<String>();
        while (iterator.hasNext()) {
            String value = iterator.next();
            if (trim) {
                value = value.trim();
            }
            if (value.length() == 0) continue;
            new_list.add(value);
        }
        return new_list;
    }
}

