/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.util;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellRange;
import org.apache.poi.util.Internal;

@Internal
public final class SSCellRange<K extends Cell>
implements CellRange<K> {
    private final K[] _flattenedArray;

    private SSCellRange(int n, int n2, int n3, int n4, K[] KArray) {
        this._flattenedArray = KArray;
    }

    public static <B extends Cell> SSCellRange<B> create(int n, int n2, int n3, int n4, List<B> list, Class<B> clazz) {
        int n5 = list.size();
        if (n3 * n4 != n5) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        Cell[] cellArray = (Cell[])Array.newInstance(clazz, n5);
        list.toArray(cellArray);
        return new SSCellRange(n, n2, n3, n4, cellArray);
    }

    @Override
    public Iterator<K> iterator() {
        return new ArrayIterator<K>(this._flattenedArray);
    }

    private static final class ArrayIterator<D>
    implements Iterator<D> {
        private final D[] _array;
        private int _index;

        public ArrayIterator(D[] DArray) {
            this._array = DArray;
            this._index = 0;
        }

        @Override
        public boolean hasNext() {
            return this._index < this._array.length;
        }

        @Override
        public D next() {
            if (this._index >= this._array.length) {
                throw new NoSuchElementException(String.valueOf(this._index));
            }
            return this._array[this._index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove cells from this CellRange.");
        }
    }
}

