/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.hot.sds;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import org.openstreetmap.hot.sds.SdsApi;
import org.openstreetmap.hot.sds.SdsWriter;
import org.openstreetmap.hot.sds.SeparateDataStorePlugin;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmServerWritePostprocessor;

public class WritePostprocessor
implements OsmServerWritePostprocessor {
    SeparateDataStorePlugin plugin;

    public WritePostprocessor(SeparateDataStorePlugin plugin) {
        this.plugin = plugin;
    }

    public void postprocessUploadedPrimitives(Collection<OsmPrimitive> primitives, ProgressMonitor progress) {
        StringWriter swriter = new StringWriter();
        try (SdsWriter sdsWriter = new SdsWriter(new PrintWriter(swriter));){
            sdsWriter.header();
            boolean somethingWritten = false;
            for (OsmPrimitive p : primitives) {
                for (SeparateDataStorePlugin.QueueItem q : this.plugin.uploadQueue) {
                    if (!q.primitive.equals(p) || q.sdsOnly) continue;
                    sdsWriter.write(q.primitive, q.tags);
                    somethingWritten = true;
                    q.processed = true;
                }
            }
            for (SeparateDataStorePlugin.QueueItem q : this.plugin.uploadQueue) {
                if (!q.sdsOnly) continue;
                sdsWriter.write(q.primitive, q.tags);
                somethingWritten = true;
                q.processed = true;
            }
            if (somethingWritten) {
                sdsWriter.footer();
                SdsApi api = SdsApi.getSdsApi();
                System.out.println("sending message:\n" + swriter.toString());
                api.updateSds(swriter.toString(), progress);
            }
        }
        for (OsmPrimitive p : primitives) {
            this.plugin.learn((IPrimitive)p);
        }
        for (SeparateDataStorePlugin.QueueItem q : this.plugin.uploadQueue) {
            if (!q.sdsOnly) continue;
            q.primitive.setModified(false);
            this.plugin.learn(q.primitive);
        }
        this.plugin.clearQueue();
    }
}

