/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.util.retry;

import java.util.logging.Level;
import org.openstreetmap.josm.plugins.mapdust.util.retry.RetryMode;
import org.openstreetmap.josm.plugins.mapdust.util.retry.RetrySetup;
import org.openstreetmap.josm.tools.Logging;

public abstract class RetryAgent<T> {
    private RetrySetup setup;

    public RetryAgent() {
        this(RetrySetup.DEFAULT);
    }

    public RetryAgent(RetrySetup setup) {
        this.setup = setup;
    }

    protected abstract T target() throws Exception;

    protected abstract void cleanup() throws Exception;

    public T run() throws Exception {
        T result;
        if (this.setup.getMode() == RetryMode.COUNTED) {
            result = this.runCounted();
        } else if (this.setup.getMode() == RetryMode.TIMED) {
            result = this.runTimed();
        } else {
            throw new RuntimeException("Unsupported retry mode: '" + (Object)((Object)this.setup.getMode()) + "'");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private T runCounted() throws Exception {
        T result = null;
        boolean success = false;
        int attempts = this.setup.getStopCondition();
        int delay = this.setup.getBaseDelay();
        do {
            --attempts;
            result = this.target();
            success = true;
            try {
                this.cleanup();
            }
            catch (Exception e) {
                Logging.error((String)"Could not clean up", (Object[])new Object[]{e});
            }
            continue;
            catch (Exception e) {
                try {
                    if (attempts <= 0) {
                        throw e;
                    }
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e1) {
                        Logging.error((Throwable)e1);
                    }
                    delay = delay * 3 / 2;
                }
                catch (Throwable throwable) {
                    try {
                        this.cleanup();
                    }
                    catch (Exception e2) {
                        Logging.error((String)"Could not clean up", (Object[])new Object[]{e2});
                    }
                    throw throwable;
                }
                try {
                    this.cleanup();
                }
                catch (Exception e3) {
                    Logging.error((String)"Could not clean up", (Object[])new Object[]{e3});
                }
            }
        } while (!success && attempts > 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T runTimed() throws Exception {
        long time;
        T result = null;
        boolean success = false;
        long delay = this.setup.getBaseDelay();
        long maxTime = this.setup.getStopCondition();
        do {
            time = System.currentTimeMillis();
            try {
                result = this.target();
                success = true;
            }
            catch (Exception e) {
                if (maxTime - delay <= 0L) {
                    throw e;
                }
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e1) {
                    Logging.error((Throwable)e1);
                    throw e;
                }
                delay = delay * 3L / 2L;
            }
            finally {
                try {
                    this.cleanup();
                }
                catch (Exception e) {
                    Logging.log((Level)Logging.LEVEL_ERROR, (String)"Could not clean up", (Throwable)e);
                }
            }
            time = System.currentTimeMillis() - time;
        } while (!success && (maxTime -= time) > 0L);
        return result;
    }
}

