/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.photo_geotagging;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.plugins.photo_geotagging.ExifGPSTagger;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

class GeotaggingAction
extends AbstractAction
implements Layer.LayerAction {
    static final boolean debug = false;
    static final String KEEP_BACKUP = "plugins.photo_geotagging.keep_backup";
    static final String CHANGE_MTIME = "plugins.photo_geotagging.change-mtime";
    static final String MTIME_MODE = "plugins.photo_geotagging.mtime-mode";
    static final int MTIME_MODE_GPS = 1;
    static final int MTIME_MODE_PREVIOUS_VALUE = 2;

    public GeotaggingAction() {
        super(I18n.tr((String)"Write coordinates to image header", (Object[])new Object[0]), ImageProvider.get((String)"geotagging"));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        GeoImageLayer layer = this.getLayer();
        ArrayList<ImageEntry> images = new ArrayList<ImageEntry>();
        for (ImageEntry e2 : layer.getImages()) {
            if (e2.getPos() == null || !e2.hasNewGpsData()) continue;
            images.add(e2);
        }
        JPanel cont = new JPanel(new GridBagLayout());
        cont.add((Component)new JLabel(I18n.tr((String)"Write position information into the exif header of the following files:", (Object[])new Object[0])), GBC.eol());
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        DecimalFormat dFormatter = new DecimalFormat("###0.000000");
        for (ImageEntry e3 : images) {
            listModel.addElement(e3.getFile().getAbsolutePath() + " (" + dFormatter.format(e3.getPos().lat()) + "," + dFormatter.format(e3.getPos().lon()) + ")");
        }
        JList entryList = new JList(listModel);
        JScrollPane scroll = new JScrollPane(entryList);
        scroll.setPreferredSize(new Dimension(900, 250));
        cont.add((Component)scroll, GBC.eol().fill(1));
        JPanel settingsPanel = new JPanel(new GridBagLayout());
        settingsPanel.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"settings", (Object[])new Object[0])));
        cont.add((Component)settingsPanel, GBC.eol().insets(3, 10, 3, 0));
        JCheckBox backups = new JCheckBox(I18n.tr((String)"keep backup files", (Object[])new Object[0]), Config.getPref().getBoolean(KEEP_BACKUP, true));
        settingsPanel.add((Component)backups, GBC.eol().insets(3, 3, 0, 0));
        JCheckBox setMTime = new JCheckBox(I18n.tr((String)"change file modification time:", (Object[])new Object[0]), Config.getPref().getBoolean(CHANGE_MTIME, false));
        settingsPanel.add((Component)setMTime, GBC.std().insets(3, 3, 5, 3));
        String[] mTimeModeArray = new String[]{"----", I18n.tr((String)"to gps time", (Object[])new Object[0]), I18n.tr((String)"to previous value (unchanged mtime)", (Object[])new Object[0])};
        JComboBox<String> mTimeMode = new JComboBox<String>(mTimeModeArray);
        String mTimeModePref = Config.getPref().get(MTIME_MODE, null);
        int mTimeIdx = 0;
        if ("gps".equals(mTimeModePref)) {
            mTimeIdx = 1;
        } else if ("previous".equals(mTimeModePref)) {
            mTimeIdx = 2;
        }
        mTimeMode.setSelectedIndex(setMTime.isSelected() ? mTimeIdx : 0);
        settingsPanel.add(mTimeMode, GBC.eol().insets(3, 3, 3, 3));
        setMTime.addActionListener(e -> {
            if (setMTime.isSelected()) {
                mTimeMode.setEnabled(true);
            } else {
                mTimeMode.setSelectedIndex(0);
                mTimeMode.setEnabled(false);
            }
        });
        setMTime.setSelected(!setMTime.isSelected());
        setMTime.doClick();
        int result = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Photo Geotagging Plugin", (Object[])new Object[0]), new String[]{I18n.tr((String)"OK", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])}).setButtonIcons(new String[]{"ok", "cancel"}).setContent((Component)cont).setCancelButton(new Integer[]{2}).setDefaultButton(1).showDialog().getValue();
        if (result != 1) {
            return;
        }
        boolean keep_backup = backups.isSelected();
        boolean change_mtime = setMTime.isSelected();
        Config.getPref().putBoolean(KEEP_BACKUP, keep_backup);
        Config.getPref().putBoolean(CHANGE_MTIME, change_mtime);
        if (change_mtime) {
            String mTimeModePref2;
            switch (mTimeMode.getSelectedIndex()) {
                case 1: {
                    mTimeModePref2 = "gps";
                    break;
                }
                case 2: {
                    mTimeModePref2 = "previous";
                    break;
                }
                default: {
                    mTimeModePref2 = null;
                }
            }
            Config.getPref().put(MTIME_MODE, mTimeModePref2);
        }
        MainApplication.worker.execute((Runnable)((Object)new GeoTaggingRunnable(images, keep_backup, mTimeMode.getSelectedIndex())));
    }

    private GeoImageLayer getLayer() {
        return (GeoImageLayer)LayerListDialog.getInstance().getModel().getSelectedLayers().get(0);
    }

    private boolean enabled(GeoImageLayer layer) {
        for (ImageEntry e : layer.getImages()) {
            if (e.getPos() == null || !e.hasNewGpsData()) continue;
            return true;
        }
        return false;
    }

    public Component createMenuComponent() {
        JMenuItem geotaggingItem = new JMenuItem(this);
        geotaggingItem.setEnabled(this.enabled(this.getLayer()));
        return geotaggingItem;
    }

    public boolean supportLayers(List<Layer> layers) {
        return layers.size() == 1 && layers.get(0) instanceof GeoImageLayer;
    }

    static class GeoTaggingRunnable
    extends PleaseWaitRunnable {
        private final List<ImageEntry> images;
        private final boolean keep_backup;
        private final int mTimeMode;
        private boolean canceled = false;
        private Boolean override_backup = null;
        private File fileFrom;
        private File fileTo;
        private File fileDelete;
        private int currentIndex;
        boolean testMTimeReadAndWriteDone = false;

        public GeoTaggingRunnable(List<ImageEntry> images, boolean keep_backup, int mTimeMode) {
            super(I18n.tr((String)"Photo Geotagging Plugin", (Object[])new Object[0]));
            this.images = images;
            this.keep_backup = keep_backup;
            this.mTimeMode = mTimeMode;
        }

        private void processEntry(ImageEntry e) throws IOException {
            Date time;
            this.fileFrom = null;
            this.fileTo = null;
            this.fileDelete = null;
            if (this.mTimeMode != 0) {
                this.testMTimeReadAndWrite(e.getFile());
            }
            Long mTime = null;
            if (this.mTimeMode == 1 && (time = e.hasGpsTime() ? e.getGpsTime() : e.getExifGpsTime()) != null) {
                mTime = time.getTime();
            }
            if ((this.mTimeMode == 2 || this.mTimeMode != 0 && mTime == null) && (mTime = Long.valueOf(e.getFile().lastModified())).equals(0L)) {
                throw new IOException(I18n.tr((String)"Could not read mtime.", (Object[])new Object[0]));
            }
            this.chooseFiles(e.getFile());
            if (this.canceled) {
                return;
            }
            ExifGPSTagger.setExifGPSTag(this.fileFrom, this.fileTo, e.getPos().lat(), e.getPos().lon(), e.getGpsTime(), e.getSpeed(), e.getElevation(), e.getExifImgDir());
            if (mTime != null && !this.fileTo.setLastModified(mTime)) {
                throw new IOException(I18n.tr((String)"Could not write mtime.", (Object[])new Object[0]));
            }
            this.cleanupFiles();
            e.unflagNewGpsData();
        }

        protected void realRun() {
            this.progressMonitor.subTask(I18n.tr((String)"Writing position information to image files...", (Object[])new Object[0]));
            this.progressMonitor.setTicksCount(this.images.size());
            long startTime = System.currentTimeMillis();
            this.currentIndex = 0;
            while (this.currentIndex < this.images.size()) {
                if (this.canceled) {
                    return;
                }
                ImageEntry e = this.images.get(this.currentIndex);
                try {
                    this.processEntry(e);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    try {
                        SwingUtilities.invokeAndWait(() -> {
                            ExtendedDialog dlg = new ExtendedDialog(this.progressMonitor.getWindowParent(), I18n.tr((String)"Error", (Object[])new Object[0]), new String[]{I18n.tr((String)"Abort", (Object[])new Object[0]), I18n.tr((String)"Retry", (Object[])new Object[0]), I18n.tr((String)"Ignore", (Object[])new Object[0])});
                            dlg.setIcon(0);
                            dlg.setButtonIcons(new String[]{"cancel", "dialogs/refresh", "dialogs/next"});
                            String msg = ioe instanceof NoSuchFileException ? I18n.tr((String)"File not found.", (Object[])new Object[0]) : ioe.toString();
                            dlg.setContent(I18n.tr((String)"Unable to process file ''{0}'':", (Object[])new Object[]{e.getFile().toString()}) + "<br/>" + msg);
                            dlg.showDialog();
                            switch (dlg.getValue()) {
                                case 2: {
                                    --this.currentIndex;
                                    break;
                                }
                                case 3: {
                                    break;
                                }
                                default: {
                                    this.canceled = true;
                                }
                            }
                        });
                    }
                    catch (InterruptedException | InvocationTargetException ex) {
                        throw new JosmRuntimeException((Throwable)ex);
                    }
                }
                this.progressMonitor.worked(1);
                float millisecondsPerFile = (float)(System.currentTimeMillis() - startTime) / (float)(this.currentIndex + 1);
                int filesLeft = this.images.size() - this.currentIndex - 1;
                String timeLeft = Utils.getDurationString((long)((long)Math.ceil(millisecondsPerFile * (float)filesLeft)));
                this.progressMonitor.subTask(I18n.tr((String)"Writing position information to image files... Estimated time left: {0}", (Object[])new Object[]{timeLeft}));
                ++this.currentIndex;
            }
        }

        private void chooseFiles(File file) throws IOException {
            if (!this.keep_backup) {
                this.chooseFilesNoBackup(file);
                return;
            }
            File fileBackup = new File(file.getParentFile(), file.getName() + "_");
            if (fileBackup.exists()) {
                this.confirm_override();
                if (this.canceled) {
                    return;
                }
                if (this.override_backup.booleanValue()) {
                    if (!fileBackup.delete()) {
                        throw new IOException(I18n.tr((String)"File could not be deleted!", (Object[])new Object[0]));
                    }
                } else {
                    this.chooseFilesNoBackup(file);
                    return;
                }
            }
            if (!file.renameTo(fileBackup)) {
                throw new IOException(I18n.tr((String)"Could not rename file!", (Object[])new Object[0]));
            }
            this.fileFrom = fileBackup;
            this.fileTo = file;
            this.fileDelete = null;
        }

        private void chooseFilesNoBackup(File file) throws IOException {
            File fileTmp;
            while ((fileTmp = new File(file.getParentFile(), "img" + UUID.randomUUID() + ".jpg")).exists()) {
            }
            try {
                Files.move(file.toPath(), fileTmp.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                Logging.error((String)I18n.tr((String)"Could not rename file {0} to {1}!", (Object[])new Object[]{file, fileTmp}));
                throw e;
            }
            this.fileFrom = fileTmp;
            this.fileTo = file;
            this.fileDelete = fileTmp;
        }

        private void confirm_override() {
            if (this.override_backup != null) {
                return;
            }
            try {
                SwingUtilities.invokeAndWait(() -> {
                    JLabel l = new JLabel(I18n.tr((String)"<html><h3>There are old backup files in the image directory!</h3>", (Object[])new Object[0]));
                    l.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
                    int override = new ExtendedDialog(this.progressMonitor.getWindowParent(), I18n.tr((String)"Override old backup files?", (Object[])new Object[0]), new String[]{I18n.tr((String)"Cancel", (Object[])new Object[0]), I18n.tr((String)"Keep old backups and continue", (Object[])new Object[0]), I18n.tr((String)"Override", (Object[])new Object[0])}).setButtonIcons(new String[]{"cancel", "ok", "dialogs/delete"}).setContent((Component)l).setCancelButton(new Integer[]{1}).setDefaultButton(2).showDialog().getValue();
                    if (override == 2) {
                        this.override_backup = false;
                    } else if (override == 3) {
                        this.override_backup = true;
                    } else {
                        this.canceled = true;
                    }
                });
            }
            catch (Exception e) {
                System.err.println(e);
                this.canceled = true;
            }
        }

        private void cleanupFiles() throws IOException {
            if (this.fileDelete != null && !this.fileDelete.delete()) {
                throw new IOException(I18n.tr((String)"Could not delete temporary file!", (Object[])new Object[0]));
            }
        }

        private void testMTimeReadAndWrite(File file) throws IOException {
            if (this.testMTimeReadAndWriteDone) {
                return;
            }
            File fileTest = File.createTempFile("geo", ".txt", file.getParentFile());
            long mTimeTest = fileTest.lastModified();
            if (mTimeTest == 0L) {
                throw new IOException(I18n.tr((String)"Test failed: Could not read mtime.", (Object[])new Object[0]));
            }
            if (!fileTest.setLastModified(mTimeTest)) {
                throw new IOException(I18n.tr((String)"Test failed: Could not write mtime.", (Object[])new Object[0]));
            }
            if (!fileTest.delete()) {
                throw new IOException(I18n.tr((String)"Could not delete temporary file!", (Object[])new Object[0]));
            }
            this.testMTimeReadAndWriteDone = true;
        }

        protected void finish() {
        }

        protected void cancel() {
            this.canceled = true;
        }
    }
}

