/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery_offset_db;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.Date;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.plugins.imagery_offset_db.CalibrationObject;
import org.openstreetmap.josm.plugins.imagery_offset_db.ImageryOffset;
import org.openstreetmap.josm.plugins.imagery_offset_db.ImageryOffsetBase;
import org.openstreetmap.josm.plugins.imagery_offset_db.ImageryOffsetTools;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.date.DateUtils;

public class OffsetDialogButton
extends JButton {
    private ImageryOffsetBase offset;
    private JLabel distanceLabel;
    private DirectionIcon directionArrow;

    public OffsetDialogButton(ImageryOffsetBase offset) {
        this.offset = offset;
        this.layoutComponents();
    }

    public ImageryOffsetBase getOffset() {
        return this.offset;
    }

    public void updateLocation() {
        LatLon center = ImageryOffsetTools.getMapCenter();
        this.directionArrow.updateIcon(center);
        double distance = center.greatCircleDistance(this.offset.getPosition());
        this.distanceLabel.setText(ImageryOffsetTools.formatDistance(distance));
    }

    private void layoutComponents() {
        String authorAndDate = this.offset.isDeprecated() ? I18n.tr((String)"Deprecated by {0} on {1}", (Object[])new Object[]{this.offset.getAbandonAuthor(), DateUtils.formatDate((Date)this.offset.getAbandonDate(), (int)2)}) : I18n.tr((String)"Created by {0} on {1}", (Object[])new Object[]{this.offset.getAuthor(), DateUtils.formatDate((Date)this.offset.getDate(), (int)2)});
        JLabel authorAndDateLabel = new JLabel(authorAndDate);
        Font authorFont = new Font(authorAndDateLabel.getFont().getName(), 2, authorAndDateLabel.getFont().getSize());
        authorAndDateLabel.setFont(authorFont);
        this.directionArrow = new DirectionIcon(this.offset.getPosition());
        this.distanceLabel = new JLabel("", this.directionArrow, 4);
        this.distanceLabel.setHorizontalTextPosition(2);
        Font distanceFont = new Font(this.distanceLabel.getFont().getName(), 0, this.distanceLabel.getFont().getSize());
        this.distanceLabel.setFont(distanceFont);
        this.updateLocation();
        String description = this.offset.isDeprecated() ? this.offset.getAbandonReason() : this.offset.getDescription();
        description = description.replace("<", "&lt;").replace(">", "&gt;");
        JLabel descriptionLabel = new JLabel("<html><div style=\"width: 300px;\">" + description + "</div></html>");
        Font descriptionFont = new Font(descriptionLabel.getFont().getName(), 1, descriptionLabel.getFont().getSize());
        descriptionLabel.setFont(descriptionFont);
        OffsetIcon offsetIcon = new OffsetIcon(this.offset);
        double offsetDistance = this.offset instanceof ImageryOffset ? offsetIcon.getDistance() : 0.0;
        JLabel offsetLabel = new JLabel(offsetDistance > 0.2 ? ImageryOffsetTools.formatDistance(offsetDistance) : "", offsetIcon, 0);
        Font offsetFont = new Font(offsetLabel.getFont().getName(), 0, offsetLabel.getFont().getSize() - 2);
        offsetLabel.setFont(offsetFont);
        offsetLabel.setHorizontalTextPosition(0);
        offsetLabel.setVerticalTextPosition(3);
        Box topLine = new Box(0);
        topLine.add(authorAndDateLabel);
        topLine.add(Box.createHorizontalGlue());
        topLine.add(Box.createHorizontalStrut(10));
        topLine.add(this.distanceLabel);
        JPanel p = new JPanel(new BorderLayout(10, 5));
        p.setOpaque(false);
        p.add((Component)topLine, "North");
        p.add((Component)offsetLabel, "West");
        p.add((Component)descriptionLabel, "Center");
        this.add(p);
    }

    private double[] getLengthAndDirection(ImageryOffset offset) {
        double[] dArray;
        AbstractTileSourceLayer<?> layer = ImageryOffsetTools.getTopImageryLayer();
        if (layer == null) {
            double[] dArray2 = new double[2];
            dArray2[0] = 0.0;
            dArray = dArray2;
            dArray2[1] = 0.0;
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = layer.getDisplaySettings().getDx();
            dArray = dArray3;
            dArray3[1] = layer.getDisplaySettings().getDy();
        }
        double[] dxy = dArray;
        return OffsetDialogButton.getLengthAndDirection(offset, dxy[0], dxy[1]);
    }

    public static double[] getLengthAndDirection(ImageryOffset offset, double dx, double dy) {
        double direction;
        EastNorth pos;
        Projection proj = ProjectionRegistry.getProjection();
        LatLon correctedCenterLL = proj.eastNorth2latlon((pos = proj.latlon2eastNorth(offset.getPosition())).add(-dx, -dy));
        double length = correctedCenterLL.greatCircleDistance(offset.getImageryPos());
        double d = direction = length < 0.01 ? 0.0 : -correctedCenterLL.bearing(offset.getImageryPos());
        if (direction < 0.0) {
            direction += Math.PI * 2;
        }
        return new double[]{length, direction};
    }

    private static void drawArrow(Graphics g, int cx, int cy, double length, double direction) {
        int dx = (int)Math.round(Math.sin(direction) * length / 2.0);
        int dy = (int)Math.round(Math.cos(direction) * length / 2.0);
        g.drawLine(cx - dx, cy - dy, cx + dx, cy + dy);
        double wingLength = Math.max(length / 3.0, 4.0);
        double d1 = direction - 0.5235987755982988;
        int dx1 = (int)Math.round(Math.sin(d1) * wingLength);
        int dy1 = (int)Math.round(Math.cos(d1) * wingLength);
        g.drawLine(cx + dx, cy + dy, cx + dx - dx1, cy + dy - dy1);
        double d2 = direction + 0.5235987755982988;
        int dx2 = (int)Math.round(Math.sin(d2) * wingLength);
        int dy2 = (int)Math.round(Math.cos(d2) * wingLength);
        g.drawLine(cx + dx, cy + dy, cx + dx - dx2, cy + dy - dy2);
    }

    private static class DirectionIcon
    implements Icon {
        private static final int SIZE = 10;
        private LatLon to;
        private double distance;
        private double direction;

        DirectionIcon(LatLon to) {
            this.to = to;
        }

        public void updateIcon(LatLon from) {
            this.distance = from.greatCircleDistance(this.to);
            this.direction = -this.to.bearing(from);
        }

        @Override
        public void paintIcon(Component comp, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(Color.black);
            Point c = new Point(x + this.getIconWidth() / 2, y + this.getIconHeight() / 2);
            if (this.distance < 1.0) {
                int r = 2;
                g2.fillOval(c.x - r, c.y - r, r * 2 + 1, r * 2 + 1);
            } else {
                g2.setStroke(new BasicStroke(1.0f));
                OffsetDialogButton.drawArrow(g2, c.x, c.y, 10.0, this.direction);
            }
        }

        @Override
        public int getIconWidth() {
            return 10;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }
    }

    private class OffsetIcon
    implements Icon {
        private boolean isDeprecated;
        private boolean isCalibration;
        private double direction = -1.0;
        private double distance;
        private ImageIcon background;

        OffsetIcon(ImageryOffsetBase offset) {
            this.isDeprecated = offset.isDeprecated();
            this.isCalibration = offset instanceof CalibrationObject;
            if (offset instanceof ImageryOffset) {
                this.background = ImageProvider.get((String)"offset");
                double[] ld = OffsetDialogButton.this.getLengthAndDirection((ImageryOffset)offset);
                this.distance = ld[0];
                this.direction = ld[1];
            } else {
                this.background = ImageProvider.get((String)"calibration");
            }
        }

        public double getDistance() {
            return this.distance;
        }

        @Override
        public void paintIcon(Component comp, Graphics g, int x, int y) {
            this.background.paintIcon(comp, g, x, y);
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (!this.isCalibration) {
                g2.setColor(Color.black);
                Point c = new Point(x + this.getIconWidth() / 2, y + this.getIconHeight() / 2);
                if (this.distance < 0.01) {
                    g2.fillOval(c.x - 3, c.y - 3, 7, 7);
                } else {
                    double arrowLength = this.distance < 10.0 ? (double)(this.getIconWidth() / 2 - 1) : (double)(this.getIconWidth() - 4);
                    g2.setStroke(new BasicStroke(2.0f));
                    OffsetDialogButton.drawArrow(g2, c.x, c.y, arrowLength, this.direction);
                }
            }
            if (this.isDeprecated) {
                g2.setColor(Color.red);
                g2.setStroke(new BasicStroke(5.0f, 1, 1));
                g2.setComposite(AlphaComposite.getInstance(3, 0.3f));
                g2.drawLine(x + 2, y + 2, x + this.getIconWidth() - 2, y + this.getIconHeight() - 2);
                g2.drawLine(x + 2, y + this.getIconHeight() - 2, x + this.getIconWidth() - 2, y + 2);
            }
        }

        @Override
        public int getIconWidth() {
            return this.background.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.background.getIconHeight();
        }
    }
}

