/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.curves;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.PolarCoor;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;

public final class CircleArcMaker {
    private CircleArcMaker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Command> doCircleArc(List<Node> selectedNodes, List<Way> selectedWays) {
        ArrayList<Node> cwTest;
        LatLon ll2;
        LinkedList<Command> cmds = new LinkedList<Command>();
        Node n1 = null;
        Node n2 = null;
        Node n3 = null;
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        if (selectedWays.size() > 1) {
            return cmds;
        }
        Way w = null;
        boolean nodesHaveBeenChoosen = false;
        if (selectedNodes.size() == 3) {
            Iterator<Node> nodeIter = selectedNodes.iterator();
            n1 = nodeIter.next();
            n2 = nodeIter.next();
            n3 = nodeIter.next();
            nodesHaveBeenChoosen = true;
        }
        if (!selectedWays.isEmpty()) {
            w = selectedWays.iterator().next();
            if (!nodesHaveBeenChoosen) {
                int nodeCount = w.getNodesCount();
                if (nodeCount < 3) {
                    return cmds;
                }
                n3 = w.getNode(nodeCount - 1);
                n2 = w.getNode(nodeCount - 2);
                n1 = w.getNode(nodeCount - 3);
                nodesHaveBeenChoosen = true;
            }
        }
        List<Node> anchorNodes = Arrays.asList(n1, n2, n3);
        if (!nodesHaveBeenChoosen || w != null && !w.getNodes().containsAll(anchorNodes)) {
            return cmds;
        }
        EastNorth p1 = n1.getEastNorth();
        EastNorth p2 = n2.getEastNorth();
        EastNorth p3 = n3.getEastNorth();
        if (p1.equals((Object)p2) || p1.equals((Object)p3) || p2.equals((Object)p3)) {
            return cmds;
        }
        EastNorth center = Geometry.getCenter(anchorNodes);
        if (center == null) {
            return cmds;
        }
        double radius = center.distance(p1);
        LatLon ll1 = ProjectionRegistry.getProjection().eastNorth2latlon(p1);
        double radiusInMeters = ll1.greatCircleDistance(ll2 = ProjectionRegistry.getProjection().eastNorth2latlon(center));
        if (radiusInMeters < 0.01) {
            throw new JosmRuntimeException(I18n.tr((String)"Radius too small", (Object[])new Object[0]));
        }
        int numberOfNodesInCircle = (int)Math.ceil(6.0 * Math.pow(radiusInMeters, 0.5));
        if (numberOfNodesInCircle < 6) {
            numberOfNodesInCircle = 6;
        } else if (numberOfNodesInCircle % 2 != 0) {
            ++numberOfNodesInCircle;
        }
        double maxAngle = 360.0 / (double)numberOfNodesInCircle;
        if (w == null) {
            w = new Way();
            w.setNodes(anchorNodes);
            cmds.add((Command)new AddCommand(ds, (OsmPrimitive)w));
        }
        ArrayList<Node> nodes = new ArrayList<Node>(w.getNodes());
        if (!selectedWays.isEmpty()) {
            if (w.isClosed()) {
                nodes.clear();
                nodes.addAll(CircleArcMaker.findShortestPart(w, anchorNodes));
            }
            List<Node> consideredNodes = Arrays.asList(n1, n2, n3);
            consideredNodes.sort((o1, o2) -> nodes.indexOf(o1) - nodes.indexOf(o2));
            n1 = consideredNodes.get(0);
            n2 = consideredNodes.get(1);
            n3 = consideredNodes.get(2);
            anchorNodes = Arrays.asList(n1, n2, n3);
        }
        if ((cwTest = new ArrayList<Node>(Arrays.asList(n1, n2, n3))).get(0) != cwTest.get(cwTest.size() - 1)) {
            cwTest.add((Node)cwTest.get(0));
        }
        boolean clockwise = Geometry.isClockwise(cwTest);
        boolean needsUndo = false;
        if (!cmds.isEmpty()) {
            UndoRedoHandler.getInstance().add((Command)new SequenceCommand("add nodes", cmds));
            needsUndo = true;
        }
        int pos1 = nodes.indexOf(n1);
        int pos3 = nodes.indexOf(n3);
        HashSet<Node> fixNodes = new HashSet<Node>(anchorNodes);
        if (!selectedWays.isEmpty()) {
            for (int i = pos1 + 1; i < pos3; ++i) {
                Node n = (Node)nodes.get(i);
                if (!n.isTagged() && !n.isReferredByWays(2) && n.referrers(Relation.class).count() <= 0L) continue;
                fixNodes.add(n);
            }
        }
        List orig = nodes.subList(pos1, pos3 + 1);
        ArrayList<Node> arcNodes = new ArrayList<Node>(orig);
        HashSet<Way> targetWays = new HashSet<Way>();
        if (!selectedWays.isEmpty()) {
            for (int i = pos1 + 1; i < pos3; ++i) {
                targetWays.addAll(((Node)nodes.get(i)).getParentWays());
            }
        } else {
            targetWays.add(w);
        }
        try {
            List<Command> modCmds = CircleArcMaker.worker(arcNodes, fixNodes, center, radius, maxAngle, clockwise);
            cmds.addAll(modCmds);
            if (!arcNodes.equals(orig)) {
                CircleArcMaker.fuseArc(ds, arcNodes, targetWays, cmds);
            }
        }
        finally {
            if (needsUndo) {
                UndoRedoHandler.getInstance().undo(1);
            }
        }
        if (cmds.isEmpty()) {
            throw new JosmRuntimeException(I18n.tr((String)"Nothing to do", (Object[])new Object[0]));
        }
        return cmds;
    }

    private static List<Node> findShortestPart(Way w, List<Node> anchorNodes) {
        int bestRotate = 0;
        double shortest = Double.MAX_VALUE;
        double wayLength = w.getLength();
        for (int i = 0; i < w.getNodesCount() - 1; ++i) {
            List<Node> nodes = CircleArcMaker.rotate(w, i);
            List positions = anchorNodes.stream().map(nodes::indexOf).sorted().collect(Collectors.toList());
            double lenghth = CircleArcMaker.getLength(nodes, (Integer)positions.get(0), (Integer)positions.get(2));
            if (!(lenghth < shortest)) continue;
            bestRotate = i;
            shortest = lenghth;
        }
        if (shortest >= wayLength / 2.0) {
            throw new JosmRuntimeException(I18n.tr((String)"Could not detect which part of the closed way should be changed", (Object[])new Object[0]));
        }
        return CircleArcMaker.rotate(w, bestRotate);
    }

    private static List<Node> rotate(Way w, int distance) {
        ArrayList<Node> nodes = new ArrayList<Node>(w.getNodes());
        nodes.remove(nodes.size() - 1);
        Collections.rotate(nodes, distance);
        nodes.add((Node)nodes.get(0));
        return nodes;
    }

    private static double getLength(List<Node> nodes, int pos1, int pos3) {
        Way tmp = new Way();
        tmp.setNodes(nodes.subList(pos1, pos3 + 1));
        return tmp.getLength();
    }

    private static List<Command> worker(List<Node> origNodes, Set<Node> origFixNodes, EastNorth center, double radius, double maxAngle, boolean clockwise) {
        LinkedList<Command> cmds = new LinkedList<Command>();
        ArrayList<Node> nodes = new ArrayList<Node>(origNodes);
        HashSet<Node> fixNodes = new HashSet<Node>(origFixNodes);
        double maxStep = Math.PI * 2 / (360.0 / maxAngle);
        double sumAbsDelta = 0.0;
        int i = 0;
        while (i < nodes.size()) {
            Node test;
            int j;
            Node first = (Node)nodes.get(i);
            PolarCoor pcFirst = new PolarCoor(radius, PolarCoor.computeAngle((EastNorth)first.getEastNorth(), (EastNorth)center), center);
            for (j = i + 1; j < nodes.size() && !fixNodes.contains(test = (Node)nodes.get(j)); ++j) {
            }
            if (j < nodes.size()) {
                Node last = (Node)nodes.get(j);
                PolarCoor pcLast = new PolarCoor(last.getEastNorth(), center);
                double delta = pcLast.angle - pcFirst.angle;
                if ((!clockwise && delta < 0.0 || clockwise && delta > 0.0) && Math.signum(pcFirst.angle) == Math.signum(pcLast.angle)) {
                    if (!last.isSelected() && fixNodes.remove(last)) continue;
                    if (!first.isSelected() && fixNodes.remove(first)) {
                        return CircleArcMaker.worker(origNodes, fixNodes, center, radius, maxAngle, clockwise);
                    }
                }
                if (!clockwise && delta < 0.0) {
                    delta += Math.PI * 2;
                } else if (clockwise && delta > 0.0) {
                    delta -= Math.PI * 2;
                }
                sumAbsDelta += Math.abs(delta);
                if (sumAbsDelta > Math.PI * 2) {
                    throw new JosmRuntimeException("Would create a loop");
                }
                int numToAdd = Math.max((int)Math.ceil(Math.abs(delta / maxStep)), j - i) - (j - i);
                int added = 0;
                double step = delta / (double)(numToAdd + j - i);
                ArrayList oldNodes = new ArrayList(nodes.subList(i, j));
                PolarCoor ref = pcFirst;
                for (int k = i; k < j + numToAdd; ++k) {
                    PolarCoor pc1 = new PolarCoor(radius, pcFirst.angle + (double)(k - i) * step, center);
                    if (!oldNodes.isEmpty()) {
                        PolarCoor pc2 = new PolarCoor(((Node)oldNodes.get(0)).getEastNorth(), center);
                        if (pc2.angle < ref.angle && ref.angle < 0.0 && step > 0.0 || pc2.angle > ref.angle && ref.angle > 0.0 && step < 0.0) {
                            pc2 = ref;
                        }
                        double delta2 = ref.angle - pc2.angle;
                        if (ref.angle < 0.0 && pc2.angle > 0.0) {
                            delta2 += Math.PI * 2;
                        } else if (ref.angle > 0.0 && pc2.angle < 0.0) {
                            delta2 -= Math.PI * 2;
                        }
                        if (added >= numToAdd || Math.abs(delta2) < Math.abs(step * 1.5)) {
                            CircleArcMaker.addMoveCommandIfNeeded((Node)oldNodes.remove(0), pc1, cmds);
                            ref = pc1;
                        }
                    }
                    if (ref == pc1) continue;
                    ref = pc1;
                    Node nNew = new Node(pc1.toEastNorth());
                    nodes.add(k, nNew);
                    cmds.add((Command)new AddCommand(((Node)nodes.get(0)).getDataSet(), (OsmPrimitive)nNew));
                    ++added;
                }
                j += added;
            }
            i = j;
        }
        origNodes.clear();
        origNodes.addAll(nodes);
        return cmds;
    }

    private static void addMoveCommandIfNeeded(Node n, PolarCoor coor, Collection<Command> cmds) {
        EastNorth en = coor.toEastNorth();
        double deltaEast = en.east() - n.getEastNorth().east();
        double deltaNorth = en.north() - n.getEastNorth().north();
        if (Math.abs(deltaEast) > 1.0E-7 || Math.abs(deltaNorth) > 1.0E-7) {
            cmds.add((Command)new MoveCommand((OsmPrimitive)n, deltaEast, deltaNorth));
        }
    }

    private static void fuseArc(DataSet ds, List<Node> arcNodes, Set<Way> targetWays, Collection<Command> cmds) {
        for (Way originalTw : targetWays) {
            Way tw = new Way(originalTw);
            boolean twWasChanged = false;
            for (int i = 0; i < arcNodes.size(); ++i) {
                Node arcNode1 = arcNodes.get(i);
                if (arcNode1.getDataSet() != ds || !arcNode1.getParentWays().contains(originalTw)) continue;
                boolean changed = false;
                for (int j = i + 1; j < arcNodes.size() && !changed; ++j) {
                    Node arcNode2 = arcNodes.get(j);
                    if (arcNode2.getDataSet() != ds || !arcNode2.getParentWays().contains(originalTw)) continue;
                    changed = CircleArcMaker.tryAddArc(tw, i, j, arcNodes);
                    twWasChanged |= changed;
                }
            }
            if (twWasChanged) {
                cmds.add((Command)new ChangeNodesCommand(ds, originalTw, new ArrayList(tw.getNodes())));
            }
            tw.setNodes(null);
        }
    }

    private static boolean tryAddArc(Way tw, int i, int j, List<Node> arcNodes) {
        int pos1 = tw.getNodes().indexOf(arcNodes.get(i));
        int pos2 = tw.getNodes().indexOf(arcNodes.get(j));
        if (tw.isClosed()) {
            if (pos1 - pos2 > 1 && pos2 == 0) {
                pos2 = tw.getNodesCount() - 1;
            } else if (pos2 - pos1 > 1 && pos1 == 0) {
                pos1 = tw.getNodesCount() - 1;
            }
        }
        if (pos2 + 1 == pos1) {
            for (int k = i + 1; k < j; ++k) {
                tw.addNode(pos1, arcNodes.get(k));
            }
            return true;
        }
        if (pos2 - 1 == pos1) {
            for (int k = j - 1; k > i; --k) {
                tw.addNode(pos2, arcNodes.get(k));
            }
            return true;
        }
        return false;
    }
}

