/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.search;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.NodeWayUtils;

public class InsideMatch
extends SearchCompiler.UnaryMatch {
    private Set<OsmPrimitive> inside = null;

    public InsideMatch(SearchCompiler.Match match) {
        super(match);
    }

    private void init() {
        HashSet<OsmPrimitive> matchedAreas = new HashSet<OsmPrimitive>();
        Collection ways = MainApplication.getLayerManager().getActiveDataSet().getWays();
        for (Way way : ways) {
            if (!this.match.match((OsmPrimitive)way)) continue;
            matchedAreas.add((OsmPrimitive)way);
        }
        Collection rels = MainApplication.getLayerManager().getActiveDataSet().getRelations();
        for (Relation rel : rels) {
            if (!this.match.match((OsmPrimitive)rel)) continue;
            matchedAreas.add((OsmPrimitive)rel);
        }
        this.inside = NodeWayUtils.selectAllInside(matchedAreas, MainApplication.getLayerManager().getActiveDataSet(), false);
    }

    public boolean match(OsmPrimitive osm) {
        if (this.inside == null) {
            this.init();
        }
        return this.inside.contains(osm);
    }

    public int hashCode() {
        return 31 * super.hashCode() + (this.inside == null ? 0 : this.inside.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        InsideMatch other = (InsideMatch)((Object)obj);
        return !(this.inside == null ? other.inside != null : !this.inside.equals(other.inside));
    }
}

