/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.surveyor;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import livegps.LiveGpsPlugin;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.surveyor.ButtonDescription;
import org.openstreetmap.josm.plugins.surveyor.SurveyorActionDescription;
import org.openstreetmap.josm.plugins.surveyor.SurveyorComponent;
import org.openstreetmap.josm.plugins.surveyor.SurveyorPlugin;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.XmlObjectParser;
import org.xml.sax.SAXException;

public class SurveyorShowAction
extends JosmAction {
    private static final long serialVersionUID = 2184570223633094734L;
    private static final String DEFAULT_SOURCE = "resource://resources/surveyor.xml";
    private JFrame surveyorFrame;
    private LiveGpsPlugin gpsPlugin;

    public SurveyorShowAction(LiveGpsPlugin gpsPlugin) {
        super(I18n.tr((String)"Surveyor...", (Object[])new Object[0]), "surveyormenu.png", I18n.tr((String)"Open surveyor tool.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"surveyor:open", (String)I18n.tr((String)"GPS: {0}", (Object[])new Object[]{I18n.tr((String)"Surveyor...", (Object[])new Object[0])}), (int)82, (int)5009), true);
        this.gpsPlugin = gpsPlugin;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.surveyorFrame == null) {
            this.surveyorFrame = new JFrame();
            SurveyorComponent comp = SurveyorShowAction.createComponent();
            this.gpsPlugin.addPropertyChangeListener((PropertyChangeListener)comp);
            ActionMap actionMap = comp.getActionMap();
            InputMap inputMap = comp.getInputMap();
            actionMap.put("zoomout", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MainApplication.getMap() != null && MainApplication.getMap().mapView != null) {
                        MainApplication.getMap().mapView.zoomToFactor(2.0);
                    }
                }
            });
            inputMap.put(KeyStroke.getKeyStroke(33, 0), "zoomout");
            actionMap.put("zoomin", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MainApplication.getMap() != null && MainApplication.getMap().mapView != null) {
                        MainApplication.getMap().mapView.zoomToFactor(0.0);
                    }
                }
            });
            inputMap.put(KeyStroke.getKeyStroke(34, 0), "zoomin");
            actionMap.put("autocenter", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SurveyorShowAction.this.gpsPlugin.setAutoCenter(!SurveyorShowAction.this.gpsPlugin.isAutoCenter());
                }
            });
            inputMap.put(KeyStroke.getKeyStroke(36, 0), "autocenter");
            this.surveyorFrame.add(comp);
            this.surveyorFrame.pack();
            this.surveyorFrame.setDefaultCloseOperation(1);
            this.surveyorFrame.setTitle(I18n.tr((String)"Surveyor", (Object[])new Object[0]));
            SurveyorPlugin.setSurveyorFrame(this.surveyorFrame);
        }
        this.surveyorFrame.setAlwaysOnTop(true);
        this.surveyorFrame.setVisible(true);
    }

    /*
     * Exception decompiling
     */
    public static SurveyorComponent createComponent() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static SurveyorComponent createComponent(InputStream in) throws SAXException {
        XmlObjectParser parser = new XmlObjectParser();
        parser.mapOnStart("surveyor", SurveyorComponent.class);
        parser.map("button", ButtonDescription.class);
        parser.map("action", SurveyorActionDescription.class);
        SurveyorComponent surveyorComponent = null;
        parser.start((Reader)new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)));
        ArrayList<SurveyorActionDescription> actions = new ArrayList<SurveyorActionDescription>();
        while (parser.hasNext()) {
            Object object = parser.next();
            if (object instanceof SurveyorComponent) {
                surveyorComponent = (SurveyorComponent)object;
                continue;
            }
            if (object instanceof ButtonDescription) {
                ((ButtonDescription)object).setActions(actions);
                surveyorComponent.addButton((ButtonDescription)object);
                actions = new ArrayList();
                continue;
            }
            if (object instanceof SurveyorActionDescription) {
                actions.add((SurveyorActionDescription)object);
                continue;
            }
            Logging.error((String)("surveyor: unknown xml element: " + object));
        }
        return surveyorComponent;
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

