/*
 * Decompiled with CFR 0.152.
 */
package net.simon04.comfort0;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.simon04.comfort0.EditorLauncher;
import net.simon04.comfort0.OsmToLevel0L;
import net.simon04.comfort0.level0l.parsergen.Level0LParser;
import net.simon04.comfort0.level0l.parsergen.ParseException;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class EditLevel0LAction
extends JosmAction {
    private static final Charset CHARSET = Charset.defaultCharset();

    public EditLevel0LAction() {
        super(I18n.tr((String)"Edit as Level0L", (Object[])new Object[0]), "theta", I18n.tr((String)"Edit the selected objects in an external editor in the Level0L format", (Object[])new Object[0]), null, false);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            this.editLevel0();
        }
        catch (Exception ex) {
            Logging.error((Throwable)ex);
        }
    }

    private void editLevel0() throws IOException {
        DataSet dataSet = MainApplication.getLayerManager().getEditDataSet();
        Path path = this.writeLevel0(dataSet);
        Process editor = new EditorLauncher(path).launch();
        Logging.info((String)"Comfort0: Launching editor on file {0}", (Object[])new Object[]{path});
        new Thread(() -> this.awaitEditing(dataSet, path, editor), path.getFileName().toString()).start();
    }

    private Path writeLevel0(DataSet dataSet) throws IOException {
        byte[] level0 = new OsmToLevel0L().visit(dataSet.getSelected()).toString().getBytes(CHARSET);
        Path path = Files.createTempFile("josm_level0_", ".txt", new FileAttribute[0]);
        Files.write(path, level0, new OpenOption[0]);
        return path;
    }

    private void awaitEditing(DataSet dataSet, Path path, Process editor) {
        try {
            editor.waitFor();
            Logging.info((String)"Comfort0: Editing of file {0} done", (Object[])new Object[]{path});
            this.readLevel0(path, dataSet);
            Files.delete(path);
        }
        catch (Exception ex) {
            Logging.error((Throwable)ex);
        }
    }

    private void readLevel0(Path path, DataSet dataSet) throws IOException, ParseException {
        List<PrimitiveData> primitives;
        try (BufferedReader reader = Files.newBufferedReader(path, CHARSET);){
            primitives = new Level0LParser(reader).primitives();
        }
        Logging.info((String)"Comfort0: Reading file {0} yielded {1} primitives", (Object[])new Object[]{path, primitives.size()});
        this.buildChangeCommands(dataSet, primitives);
    }

    private void buildChangeCommands(DataSet dataSet, List<PrimitiveData> primitives) {
        ArrayList<ChangePropertyCommand> commands = new ArrayList<ChangePropertyCommand>();
        for (PrimitiveData fromLevel0L : primitives) {
            OsmPrimitive fromDataSet = dataSet.getPrimitiveById((PrimitiveId)fromLevel0L);
            if (fromLevel0L instanceof WayData) {
                ((WayData)fromLevel0L).setNodeIds(Collections.emptyList());
            } else if (fromLevel0L instanceof RelationData) {
                ((RelationData)fromLevel0L).setMembers(Collections.emptyList());
            }
            OsmPrimitive newInstance = fromLevel0L.getType().newVersionedInstance(fromDataSet.getUniqueId(), fromDataSet.getVersion());
            newInstance.load(fromLevel0L);
            boolean equalKeys = Objects.equals(newInstance.getKeys(), fromDataSet.getKeys());
            if (equalKeys) continue;
            ChangePropertyCommand command = new ChangePropertyCommand(Collections.singleton(fromDataSet), (Map)newInstance.getKeys());
            commands.add(command);
        }
        Logging.info((String)"Comfort0: Changing {0} primitives", (Object[])new Object[]{commands.size()});
        if (commands.isEmpty()) {
            return;
        }
        SequenceCommand command = new SequenceCommand("Comfort0", commands);
        GuiHelper.runInEDT(() -> UndoRedoHandler.getInstance().add((Command)command));
    }
}

