/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanestagging.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.tools.RightAndLefthandTraffic;

public final class Util {
    private Util() {
    }

    public static Object clone(Object object) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void alert(Object object) {
        JOptionPane.showMessageDialog(null, object);
    }

    public static void prints(Object object) {
        System.err.println(object);
    }

    public static boolean isInt(String str) {
        return str.lastIndexOf("-") == 0 && !str.equals("-0") ? str.replace("-", "").matches("[0-9]+") : str.matches("[0-9]+");
    }

    public static void notification(String str) {
        new Notification(str).show();
    }

    public static boolean isEmptyturnlane(String turns) {
        List<String> turnsList = Arrays.asList("reverse", "sharp_left", "left", "slight_left", "merge_to_right", "through", "reversible", "merge_to_left", "slight_right", "right", "sharp_right");
        for (String tl : turnsList) {
            if (!turns.contains(tl)) continue;
            return true;
        }
        return false;
    }

    public static String setNoneOnEmpty(String turn) {
        StringTokenizer tokenizer = new StringTokenizer(turn, "|", true);
        String previous = "";
        StringBuilder builder = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String current = tokenizer.nextToken();
            if (current.equals("|")) {
                if (previous.equals("")) {
                    builder.append("none");
                } else if (previous.equals("|")) {
                    builder.append("none");
                }
            }
            builder.append(current);
            if (current.equals("|") && !tokenizer.hasMoreTokens()) {
                builder.append("none");
            }
            previous = current;
        }
        return builder.toString();
    }

    public static boolean isRightHandTraffic() {
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        boolean flag = false;
        if (ds != null) {
            for (OsmPrimitive element : ds.getSelected()) {
                flag = RightAndLefthandTraffic.isRightHandTraffic((LatLon)element.getBBox().getCenter());
            }
        }
        return flag;
    }
}

