/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.selection;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Set;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.NodeWayUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public class SelectAllInsideAction
extends JosmAction {
    public SelectAllInsideAction() {
        super(I18n.tr((String)"All inside [testing]", (Object[])new Object[0]), "selinside", I18n.tr((String)"Select all inside selected polygons", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:selinside", (String)I18n.tr((String)"Selection: {0}", (Object[])new Object[]{I18n.tr((String)"All inside", (Object[])new Object[0])}), (int)73, (int)5007), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/SelectAllInside"));
    }

    public void actionPerformed(ActionEvent e) {
        DataSet ds = this.getLayerManager().getActiveDataSet();
        Set<OsmPrimitive> insideSelected = NodeWayUtils.selectAllInside(ds.getSelected(), ds, true);
        if (!insideSelected.isEmpty()) {
            ds.addSelected(insideSelected);
            ds.setSelected((Collection)new SubclassFilteredCollection(ds.getSelected(), OsmPrimitive::isSelectable));
        } else {
            new Notification(I18n.tr((String)"Nothing found. Please select some closed ways or multipolygons to find all primitives inside them!", (Object[])new Object[0])).setIcon(2).show();
        }
    }

    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(!selection.isEmpty());
    }
}

