/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ohe.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.plugins.ohe.ClockSystem;
import org.openstreetmap.josm.plugins.ohe.OhePlugin;
import org.openstreetmap.josm.plugins.ohe.OpeningTimeUtils;
import org.openstreetmap.josm.plugins.ohe.gui.OheEditor;
import org.openstreetmap.josm.plugins.ohe.gui.TimeRect;
import org.openstreetmap.josm.plugins.ohe.parser.OpeningTimeCompiler;
import org.openstreetmap.josm.plugins.ohe.parser.ParseException;
import org.openstreetmap.josm.plugins.ohe.parser.SyntaxException;
import org.openstreetmap.josm.plugins.ohe.parser.TokenMgrError;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class OheDialogPanel
extends JPanel {
    private final JTextField keyField;
    private final JTextField valueField;
    private final JButton twentyfourSevenButton;
    private final JLabel actualPostionLabel;
    private final OheEditor editorPanel;
    private final String oldkey;
    private ClockSystem clockSystem;

    public OheDialogPanel(OhePlugin plugin, String key, Object valuesToEdit, ClockSystem clockSystem) {
        this.clockSystem = clockSystem;
        this.oldkey = key;
        this.keyField = new JTextField(key);
        String value = "";
        if (valuesToEdit instanceof String) {
            value = (String)valuesToEdit;
        } else if (valuesToEdit instanceof Map) {
            Map valuesMap = (Map)valuesToEdit;
            if (valuesMap.size() == 1) {
                value = (String)valuesMap.keySet().iterator().next();
            } else if (valuesMap.size() > 1) {
                int mostOccurences = 0;
                for (String v : valuesMap.keySet()) {
                    if ((Integer)valuesMap.get(v) <= mostOccurences) continue;
                    value = v;
                    mostOccurences = (Integer)valuesMap.get(v);
                }
            }
        }
        this.valueField = new JTextField(value);
        this.valueField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OheDialogPanel.this.editorPanel.initTimeRects();
            }
        });
        this.twentyfourSevenButton = new JButton(I18n.tr((String)"apply {0}", (Object[])new Object[]{"24/7"}));
        this.twentyfourSevenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OheDialogPanel.this.valueField.setText("24/7");
                OheDialogPanel.this.editorPanel.initTimeRects();
            }
        });
        this.actualPostionLabel = new JLabel("-");
        JPanel toolsPanel = new JPanel(new GridBagLayout());
        toolsPanel.add((Component)this.twentyfourSevenButton, GBC.std());
        toolsPanel.add(Box.createGlue(), GBC.std().fill(2));
        toolsPanel.add((Component)this.actualPostionLabel, GBC.eop());
        this.editorPanel = new OheEditor(this);
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel(I18n.tr((String)"Key", (Object[])new Object[0])), GBC.std());
        this.add(Box.createHorizontalStrut(10), GBC.std());
        this.add((Component)this.keyField, GBC.eol().fill(2));
        this.add((Component)new JLabel(I18n.tr((String)"Value", (Object[])new Object[0])), GBC.std());
        this.add(Box.createHorizontalStrut(10), GBC.std());
        this.add((Component)this.valueField, GBC.eop().fill(2));
        this.add((Component)toolsPanel, GBC.eol().fill(2));
        this.add((Component)this.editorPanel, GBC.eol().fill());
        this.setPreferredSize(new Dimension(480, 520));
    }

    public String[] getChangedKeyValuePair() {
        return new String[]{this.oldkey, this.keyField.getText(), this.valueField.getText()};
    }

    public ArrayList<int[]> getTime() throws Exception {
        String value = this.valueField.getText();
        ArrayList<int[]> time = null;
        if (value.length() > 0) {
            OpeningTimeCompiler compiler = new OpeningTimeCompiler(value);
            try {
                time = OpeningTimeUtils.convert(compiler.startCompile());
            }
            catch (Exception | TokenMgrError t) {
                Logging.warn((Throwable)t);
                int[] tColumns = null;
                String info = t.getMessage();
                if (t instanceof ParseException) {
                    ParseException parserExc = (ParseException)t;
                    tColumns = new int[]{parserExc.currentToken.beginColumn - 1, parserExc.currentToken.endColumn + 1};
                } else if (t instanceof SyntaxException) {
                    SyntaxException syntaxError = (SyntaxException)t;
                    tColumns = new int[]{syntaxError.getStartColumn(), syntaxError.getEndColumn()};
                } else if (t instanceof TokenMgrError) {
                    try {
                        int idx = info.indexOf("column ");
                        if (idx > -1) {
                            int col = Integer.parseInt(info.substring(idx + "column ".length(), info.indexOf(46, idx)));
                            tColumns = new int[]{col - 1, col + 1};
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        Logging.warn((Throwable)e);
                    }
                    catch (NumberFormatException e) {
                        Logging.warn((Throwable)e);
                    }
                }
                if (tColumns != null || info != null) {
                    String message = "<html>";
                    if (tColumns != null) {
                        int first = Math.max(0, (int)tColumns[0]);
                        int last = Math.min(value.length(), tColumns[1]);
                        String begin = value.substring(0, first);
                        String middle = value.substring(first, last);
                        String end = value.substring(last);
                        this.valueField.setCaretPosition(first);
                        message = message + I18n.tr((String)"There is something wrong in the value near:", (Object[])new Object[0]) + "<br>" + begin + "<span style='background-color:red;'>" + middle + "</span>" + end;
                    }
                    if (info != null) {
                        if (tColumns != null) {
                            message = message + "<br>";
                        }
                        message = message + I18n.tr((String)"Info: {0}", (Object[])new Object[]{I18n.tr((String)info, (Object[])new Object[0])});
                    }
                    message = message + "<br>" + I18n.tr((String)"Correct the value manually and than press Enter.", (Object[])new Object[0]) + "</html>";
                    JOptionPane.showMessageDialog(this, message, I18n.tr((String)"Error in timeformat", (Object[])new Object[0]), 1);
                }
                throw new Exception("Error in the TimeValue", t);
            }
        }
        return time;
    }

    public void updateValueField(ArrayList<TimeRect> timeRects) {
        if (this.valueField != null && timeRects != null) {
            this.valueField.setText(OpeningTimeUtils.makeStringFromRects(timeRects));
        }
    }

    public void setMousePositionText(String positionText) {
        this.actualPostionLabel.setText(positionText);
    }

    public ClockSystem getHourMode() {
        return this.clockSystem;
    }
}

