/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.ui.FlatButtonUI;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class FlatToggleButtonUI
extends FlatButtonUI {
    protected Color selectedBackground;
    protected Color selectedForeground;
    protected Color disabledSelectedBackground;
    protected Color toolbarSelectedBackground;
    protected int tabUnderlineHeight;
    protected Color tabUnderlineColor;
    protected Color tabDisabledUnderlineColor;
    protected Color tabSelectedBackground;
    protected Color tabHoverBackground;
    protected Color tabFocusBackground;
    private boolean defaults_initialized = false;
    private static ComponentUI instance;

    public static ComponentUI createUI(JComponent c) {
        if (instance == null) {
            instance = new FlatToggleButtonUI();
        }
        return instance;
    }

    @Override
    protected String getPropertyPrefix() {
        return "ToggleButton.";
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (!this.defaults_initialized) {
            this.selectedBackground = UIManager.getColor("ToggleButton.selectedBackground");
            this.selectedForeground = UIManager.getColor("ToggleButton.selectedForeground");
            this.disabledSelectedBackground = UIManager.getColor("ToggleButton.disabledSelectedBackground");
            this.toolbarSelectedBackground = UIManager.getColor("ToggleButton.toolbar.selectedBackground");
            this.tabUnderlineHeight = UIManager.getInt("ToggleButton.tab.underlineHeight");
            this.tabUnderlineColor = UIManager.getColor("ToggleButton.tab.underlineColor");
            this.tabDisabledUnderlineColor = UIManager.getColor("ToggleButton.tab.disabledUnderlineColor");
            this.tabSelectedBackground = UIManager.getColor("ToggleButton.tab.selectedBackground");
            this.tabHoverBackground = UIManager.getColor("ToggleButton.tab.hoverBackground");
            this.tabFocusBackground = UIManager.getColor("ToggleButton.tab.focusBackground");
            this.defaults_initialized = true;
        }
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        this.defaults_initialized = false;
    }

    @Override
    protected void propertyChange(AbstractButton b, PropertyChangeEvent e) {
        super.propertyChange(b, e);
        switch (e.getPropertyName()) {
            case "JButton.buttonType": {
                if ("tab".equals(e.getOldValue()) || "tab".equals(e.getNewValue())) {
                    MigLayoutVisualPadding.uninstall(b);
                    MigLayoutVisualPadding.install(b);
                    b.revalidate();
                }
                b.repaint();
                break;
            }
            case "JToggleButton.tab.underlineHeight": 
            case "JToggleButton.tab.underlineColor": 
            case "JToggleButton.tab.selectedBackground": {
                b.repaint();
            }
        }
    }

    static boolean isTabButton(Component c) {
        return c instanceof JToggleButton && FlatClientProperties.clientPropertyEquals((JToggleButton)c, "JButton.buttonType", "tab");
    }

    @Override
    protected void paintBackground(Graphics g, JComponent c) {
        if (FlatToggleButtonUI.isTabButton(c)) {
            int height = c.getHeight();
            int width = c.getWidth();
            boolean selected = ((AbstractButton)c).isSelected();
            Color background = FlatToggleButtonUI.buttonStateColor(c, selected ? FlatClientProperties.clientPropertyColor(c, "JToggleButton.tab.selectedBackground", this.tabSelectedBackground) : null, null, this.tabFocusBackground, this.tabHoverBackground, null);
            if (background != null) {
                g.setColor(background);
                g.fillRect(0, 0, width, height);
            }
            if (selected) {
                int underlineHeight = UIScale.scale(FlatClientProperties.clientPropertyInt(c, "JToggleButton.tab.underlineHeight", this.tabUnderlineHeight));
                g.setColor(c.isEnabled() ? FlatClientProperties.clientPropertyColor(c, "JToggleButton.tab.underlineColor", this.tabUnderlineColor) : this.tabDisabledUnderlineColor);
                g.fillRect(0, height - underlineHeight, width, underlineHeight);
            }
        } else {
            super.paintBackground(g, c);
        }
    }

    @Override
    protected Color getBackground(JComponent c) {
        ButtonModel model = ((AbstractButton)c).getModel();
        if (model.isSelected()) {
            boolean toolBarButton = FlatToggleButtonUI.isToolBarButton(c);
            return FlatToggleButtonUI.buttonStateColor(c, toolBarButton ? this.toolbarSelectedBackground : this.selectedBackground, toolBarButton ? this.toolbarSelectedBackground : this.disabledSelectedBackground, null, null, toolBarButton ? this.toolbarPressedBackground : this.pressedBackground);
        }
        return super.getBackground(c);
    }

    @Override
    protected Color getForeground(JComponent c) {
        if (c.isEnabled() && ((AbstractButton)c).isSelected() && !FlatToggleButtonUI.isToolBarButton(c)) {
            return this.selectedForeground;
        }
        return super.getForeground(c);
    }
}

