/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.model.LinkTable;
import org.apache.poi.hssf.model.WorkbookRecordList;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.DateWindow1904Record;
import org.apache.poi.hssf.record.ExtSSTRecord;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.hssf.record.HyperlinkRecord;
import org.apache.poi.hssf.record.NameCommentRecord;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.WindowOneRecord;
import org.apache.poi.hssf.record.common.UnicodeString;
import org.apache.poi.ss.formula.EvaluationWorkbook;
import org.apache.poi.util.Internal;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

@Internal
public final class InternalWorkbook {
    private static final POILogger log = POILogFactory.getLogger(InternalWorkbook.class);
    private static final int DEBUG = POILogger.DEBUG;
    private final WorkbookRecordList records = new WorkbookRecordList();
    protected SSTRecord sst;
    private LinkTable linkTable;
    private final List<BoundSheetRecord> boundsheets = new ArrayList<BoundSheetRecord>();
    private final List<FormatRecord> formats = new ArrayList<FormatRecord>();
    private final List<HyperlinkRecord> hyperlinks = new ArrayList<HyperlinkRecord>();
    private int numxfs = 0;
    private int maxformatid = -1;
    private boolean uses1904datewindowing = false;
    private WindowOneRecord windowOne;
    private final Map<String, NameCommentRecord> commentRecords = new LinkedHashMap<String, NameCommentRecord>();

    private InternalWorkbook() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static InternalWorkbook createWorkbook(List<Record> list) {
        Record record;
        int n;
        if (log.check(POILogger.DEBUG)) {
            log.log(DEBUG, (Object)"Workbook (readfile) created with reclen=", list.size());
        }
        InternalWorkbook internalWorkbook = new InternalWorkbook();
        ArrayList<Record> arrayList = new ArrayList<Record>(list.size() / 3);
        internalWorkbook.records.setRecords(arrayList);
        block15: for (n = 0; n < list.size(); ++n) {
            record = list.get(n);
            if (record.getSid() == 10) {
                arrayList.add(record);
                if (!log.check(POILogger.DEBUG)) break;
                log.log(DEBUG, "found workbook eof record at " + n);
                break;
            }
            switch (record.getSid()) {
                case 133: {
                    if (log.check(POILogger.DEBUG)) {
                        log.log(DEBUG, "found boundsheet record at " + n);
                    }
                    internalWorkbook.boundsheets.add((BoundSheetRecord)record);
                    internalWorkbook.records.setBspos(n);
                    break;
                }
                case 252: {
                    if (log.check(POILogger.DEBUG)) {
                        log.log(DEBUG, "found sst record at " + n);
                    }
                    internalWorkbook.sst = (SSTRecord)record;
                    break;
                }
                case 224: {
                    if (log.check(POILogger.DEBUG)) {
                        log.log(DEBUG, "found XF record at " + n);
                    }
                    internalWorkbook.records.setXfpos(n);
                    ++internalWorkbook.numxfs;
                    break;
                }
                case 317: {
                    if (log.check(POILogger.DEBUG)) {
                        log.log(DEBUG, "found tabid record at " + n);
                    }
                    internalWorkbook.records.setTabpos(n);
                    break;
                }
                case 23: {
                    throw new RuntimeException("Extern sheet is part of LinkTable");
                }
                case 24: 
                case 430: {
                    if (log.check(POILogger.DEBUG)) {
                        log.log(DEBUG, "found SupBook record at " + n);
                    }
                    internalWorkbook.linkTable = new LinkTable(list, n, internalWorkbook.records, internalWorkbook.commentRecords);
                    n += internalWorkbook.linkTable.getRecordCount() - 1;
                    continue block15;
                }
                case 1054: {
                    if (log.check(POILogger.DEBUG)) {
                        log.log(DEBUG, "found format record at " + n);
                    }
                    internalWorkbook.formats.add((FormatRecord)record);
                    internalWorkbook.maxformatid = internalWorkbook.maxformatid >= ((FormatRecord)record).getIndexCode() ? internalWorkbook.maxformatid : ((FormatRecord)record).getIndexCode();
                    break;
                }
                case 34: {
                    if (log.check(POILogger.DEBUG)) {
                        log.log(DEBUG, "found datewindow1904 record at " + n);
                    }
                    internalWorkbook.uses1904datewindowing = ((DateWindow1904Record)record).getWindowing() == 1;
                    break;
                }
                case 61: {
                    if (log.check(POILogger.DEBUG)) {
                        log.log(DEBUG, "found WindowOneRecord at " + n);
                    }
                    internalWorkbook.windowOne = (WindowOneRecord)record;
                    break;
                }
                case 2196: {
                    NameCommentRecord nameCommentRecord = (NameCommentRecord)record;
                    if (log.check(POILogger.DEBUG)) {
                        log.log(DEBUG, "found NameComment at " + n);
                    }
                    internalWorkbook.commentRecords.put(nameCommentRecord.getNameText(), nameCommentRecord);
                }
            }
            arrayList.add(record);
        }
        while (n < list.size()) {
            record = list.get(n);
            switch (record.getSid()) {
                case 440: {
                    internalWorkbook.hyperlinks.add((HyperlinkRecord)record);
                    break;
                }
            }
            ++n;
        }
        if (internalWorkbook.windowOne == null) {
            internalWorkbook.windowOne = InternalWorkbook.createWindowOne();
        }
        if (log.check(POILogger.DEBUG)) {
            log.log(DEBUG, "exit create workbook from existing file function");
        }
        return internalWorkbook;
    }

    public int getNumRecords() {
        return this.records.size();
    }

    private BoundSheetRecord getBoundSheetRec(int n) {
        return this.boundsheets.get(n);
    }

    public String getSheetName(int n) {
        return this.getBoundSheetRec(n).getSheetname();
    }

    public ExtendedFormatRecord getExFormatAt(int n) {
        int n2 = this.records.getXfpos() - (this.numxfs - 1);
        ExtendedFormatRecord extendedFormatRecord = (ExtendedFormatRecord)this.records.get(n2 += n);
        return extendedFormatRecord;
    }

    public int addSSTString(UnicodeString unicodeString) {
        if (log.check(POILogger.DEBUG)) {
            log.log(DEBUG, (Object)"insert to sst string='", unicodeString);
        }
        if (this.sst == null) {
            this.insertSST();
        }
        return this.sst.addString(unicodeString);
    }

    public UnicodeString getSSTString(int n) {
        if (this.sst == null) {
            this.insertSST();
        }
        UnicodeString unicodeString = this.sst.getString(n);
        if (log.check(POILogger.DEBUG)) {
            log.log(DEBUG, (Object)"Returning SST for index=", (Object)n, (Object)" String= ", unicodeString);
        }
        return unicodeString;
    }

    public void insertSST() {
        if (log.check(POILogger.DEBUG)) {
            log.log(DEBUG, "creating new SST via insertSST!");
        }
        this.sst = new SSTRecord();
        this.records.add(this.records.size() - 1, InternalWorkbook.createExtendedSST());
        this.records.add(this.records.size() - 2, this.sst);
    }

    private static WindowOneRecord createWindowOne() {
        WindowOneRecord windowOneRecord = new WindowOneRecord();
        windowOneRecord.setHorizontalHold((short)360);
        windowOneRecord.setVerticalHold((short)270);
        windowOneRecord.setWidth((short)14940);
        windowOneRecord.setHeight((short)9150);
        windowOneRecord.setOptions((short)56);
        windowOneRecord.setActiveSheetIndex(0);
        windowOneRecord.setFirstVisibleTab(0);
        windowOneRecord.setNumSelectedTabs((short)1);
        windowOneRecord.setTabWidthRatio((short)600);
        return windowOneRecord;
    }

    private static ExtSSTRecord createExtendedSST() {
        ExtSSTRecord extSSTRecord = new ExtSSTRecord();
        extSSTRecord.setNumStringsPerBucket((short)8);
        return extSSTRecord;
    }

    public String findSheetNameFromExternSheet(int n) {
        int n2 = this.linkTable.getIndexToInternalSheet(n);
        if (n2 < 0) {
            return "";
        }
        if (n2 >= this.boundsheets.size()) {
            return "";
        }
        return this.getSheetName(n2);
    }

    public EvaluationWorkbook.ExternalSheet getExternalSheet(int n) {
        String[] stringArray = this.linkTable.getExternalBookAndSheetName(n);
        if (stringArray == null) {
            return null;
        }
        return new EvaluationWorkbook.ExternalSheet(stringArray[0], stringArray[1]);
    }

    public int getNumNames() {
        if (this.linkTable == null) {
            return 0;
        }
        return this.linkTable.getNumNames();
    }

    public NameRecord getNameRecord(int n) {
        return this.linkTable.getNameRecord(n);
    }

    public List<FormatRecord> getFormats() {
        return this.formats;
    }

    public boolean isUsing1904DateWindowing() {
        return this.uses1904datewindowing;
    }

    public String resolveNameXText(int n, int n2) {
        return this.linkTable.resolveNameXText(n, n2);
    }
}

