/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.javafx;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.io.audio.AudioPlayer;
import org.openstreetmap.josm.plugins.DynamicURLClassLoader;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.javafx.io.audio.JavaFxMediaPlayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.Utils;

abstract class JavaFxPlugin
extends Plugin {
    protected JavaFxPlugin(PluginInformation info, String ext, List<String> orderedNativeLibraries) {
        super(info);
        boolean isJavaFx;
        boolean bl = isJavaFx = Utils.getSystemProperty((String)"javafx.runtime.version") != null || "Oracle Corporation".equals(Utils.getSystemProperty((String)"java.vendor")) && Utils.getJavaVersion() < 11;
        if (!isJavaFx && Utils.getJavaVersion() >= 10) {
            JavaFxPlugin.extractNativeLibs(ext);
            JavaFxPlugin.loadNativeLibs(ext, orderedNativeLibraries);
        } else if (!isJavaFx) {
            Logging.error((String)"JavaFX is not available");
            StringBuilder message = new StringBuilder(I18n.tr((String)"JavaFX is not available.", (Object[])new Object[0]));
            PlatformManager.getPlatform();
            if (PlatformManager.isPlatformUnixoid()) {
                message.append(I18n.tr((String)" Please install OpenJFX through your package manager.", (Object[])new Object[0]));
            } else {
                message.append(I18n.tr((String)" Please update to Java 11+.", (Object[])new Object[0]));
            }
            if (PluginHandler.confirmDisablePlugin((Component)MainApplication.getMainFrame(), (String)message.toString(), (String)info.getName())) {
                PluginHandler.removePlugins(Collections.singletonList(info));
            }
            return;
        }
        AudioPlayer.setSoundPlayerClass(JavaFxMediaPlayer.class);
    }

    private static void extractNativeLibs(String ext) {
        CodeSource src = JavaFxPlugin.class.getProtectionDomain().getCodeSource();
        if (src != null) {
            try (ZipFile zf = new ZipFile(Paths.get(src.getLocation().toURI()).toFile(), StandardCharsets.UTF_8);){
                Path dir = JavaFxPlugin.getNativeDir();
                Enumeration<? extends ZipEntry> es = zf.entries();
                while (es.hasMoreElements()) {
                    Path targetPath;
                    File targetFile;
                    ZipEntry ze = es.nextElement();
                    String name = ze.getName();
                    if (!name.endsWith(ext) && !name.endsWith(".jar") || (targetFile = (targetPath = dir.resolve(name)).toFile()).exists() && targetFile.lastModified() >= ze.getTime()) continue;
                    InputStream is = zf.getInputStream(ze);
                    try {
                        Logging.debug((String)("Extracting " + targetPath));
                        Files.copy(is, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
            }
            catch (IOException | URISyntaxException e) {
                Logging.error((Throwable)e);
            }
        } else {
            Logging.error((String)"Unable to locate javafx jar file");
        }
    }

    private static Path getNativeDir() throws IOException {
        return Files.createDirectories(new File(Preferences.main().getPluginsDirectory(), "javafx").toPath(), new FileAttribute[0]);
    }

    private static void loadNativeLib(String absolutePath) {
        try {
            Logging.debug((String)"Loading {0}", (Object[])new Object[]{absolutePath});
            System.load(absolutePath);
        }
        catch (LinkageError e) {
            Logging.error((Throwable)e);
        }
    }

    private static void loadNativeLibs(String ext, List<String> orderedNativeLibraries) {
        try {
            Path nativeDir = JavaFxPlugin.getNativeDir();
            Files.walkFileTree(nativeDir, new LibVisitor(ext, orderedNativeLibraries));
            for (String lib : orderedNativeLibraries) {
                JavaFxPlugin.loadNativeLib(nativeDir.resolve(lib).toAbsolutePath().toString());
            }
        }
        catch (IOException e) {
            Logging.error((Throwable)e);
        }
    }

    private static class LibVisitor
    extends SimpleFileVisitor<Path> {
        private final ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        private final String ext;
        private final List<String> orderedNativeLibraries;

        public LibVisitor(String ext, List<String> orderedNativeLibraries) {
            this.ext = Objects.requireNonNull(ext);
            this.orderedNativeLibraries = Objects.requireNonNull(orderedNativeLibraries);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (this.ccl instanceof DynamicURLClassLoader) {
                String path = file.toAbsolutePath().toString();
                if (path.endsWith(this.ext) && !this.orderedNativeLibraries.contains(file.getFileName().toString())) {
                    JavaFxPlugin.loadNativeLib(path);
                } else if (path.endsWith(".jar")) {
                    Logging.debug((String)"Loading {0}", (Object[])new Object[]{path});
                    ((DynamicURLClassLoader)this.ccl).addURL(file.toUri().toURL());
                }
            } else {
                Logging.error((String)("Unexpected context class loader: " + this.ccl));
                return FileVisitResult.TERMINATE;
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

