/*
 * Decompiled with CFR 0.152.
 */
package render;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Objects;
import render.ChartContext;
import render.Rules;
import s57.S57map;
import s57.S57val;
import symbols.Areas;
import symbols.Symbols;

public final class Renderer {
    public static final double[] symbolScale = new double[]{256.0, 128.0, 64.0, 32.0, 16.0, 8.0, 4.0, 2.0, 1.0, 0.61, 0.372, 0.227, 0.138, 0.0843, 0.0514, 0.0313, 0.0191, 0.0117, 0.007};
    static ChartContext context;
    static S57map map;
    static double sScale;
    static Graphics2D g2;
    static int zoom;

    private Renderer() {
    }

    public static void reRender(Graphics2D g, Rectangle rect, int z, double factor, S57map m, ChartContext c) {
        g2 = g;
        zoom = z;
        context = c;
        map = m;
        sScale = symbolScale[zoom] * factor;
        if (map != null) {
            if (context.clip()) {
                Point2D tl = context.getPoint(new S57map.Snode(Renderer.map.bounds.maxlat, Renderer.map.bounds.minlon));
                Point2D br = context.getPoint(new S57map.Snode(Renderer.map.bounds.minlat, Renderer.map.bounds.maxlon));
                g2.clip(new Rectangle2D.Double(tl.getX(), tl.getY(), br.getX() - tl.getX(), br.getY() - tl.getY()));
            }
            g2.setBackground(context.background(map));
            g2.clearRect(rect.x, rect.y, rect.width, rect.height);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
            g2.setStroke(new BasicStroke(0.0f, 0, 0));
            while (!Rules.rules()) {
            }
        }
        Renderer.grid();
    }

    public static void symbol(Symbols.Symbol symbol) {
        Point2D point = context.getPoint(Rules.feature.geom.centre);
        Symbols.drawSymbol(g2, symbol, sScale, point.getX(), point.getY(), null, null);
    }

    public static void symbol(Symbols.Symbol symbol, Symbols.Scheme scheme) {
        Point2D point = context.getPoint(Rules.feature.geom.centre);
        Symbols.drawSymbol(g2, symbol, sScale, point.getX(), point.getY(), scheme, null);
    }

    public static void symbol(Symbols.Symbol symbol, Symbols.Delta delta) {
        Point2D point = context.getPoint(Rules.feature.geom.centre);
        Symbols.drawSymbol(g2, symbol, sScale, point.getX(), point.getY(), null, delta);
    }

    public static void symbol(Symbols.Symbol symbol, Symbols.Scheme scheme, Symbols.Delta delta) {
        Point2D point = context.getPoint(Rules.feature.geom.centre);
        Symbols.drawSymbol(g2, symbol, sScale, point.getX(), point.getY(), scheme, delta);
    }

    public static void colLetters(ArrayList<?> cols) {
        String str = "";
        for (int i = 0; i < cols.size() && i < 4; ++i) {
            str = str.concat(Rules.colourLetters.get(cols.get(i)));
        }
        Renderer.labelText(str, new Font("Arial", 0, 40), Color.black, new Symbols.Delta(Symbols.Handle.TC, AffineTransform.getTranslateInstance(0.0, 40.0)));
    }

    public static void cluster(ArrayList<Symbols.Symbol> symbols) {
        Rectangle2D.Double bbox = null;
        if (symbols.size() > 4) {
            for (Symbols.Instr instr : symbols.get(0)) {
                if (instr.type != Symbols.Form.BBOX) continue;
                bbox = (Rectangle2D.Double)instr.params;
                break;
            }
            if (bbox == null) {
                return;
            }
        }
        switch (symbols.size()) {
            case 1: {
                Renderer.symbol(symbols.get(0), new Symbols.Delta(Symbols.Handle.CC, new AffineTransform()));
                break;
            }
            case 2: {
                Renderer.symbol(symbols.get(0), new Symbols.Delta(Symbols.Handle.RC, new AffineTransform()));
                Renderer.symbol(symbols.get(1), new Symbols.Delta(Symbols.Handle.LC, new AffineTransform()));
                break;
            }
            case 3: {
                Renderer.symbol(symbols.get(0), new Symbols.Delta(Symbols.Handle.BC, new AffineTransform()));
                Renderer.symbol(symbols.get(1), new Symbols.Delta(Symbols.Handle.TR, new AffineTransform()));
                Renderer.symbol(symbols.get(2), new Symbols.Delta(Symbols.Handle.TL, new AffineTransform()));
                break;
            }
            case 4: {
                Renderer.symbol(symbols.get(0), new Symbols.Delta(Symbols.Handle.BR, new AffineTransform()));
                Renderer.symbol(symbols.get(1), new Symbols.Delta(Symbols.Handle.BL, new AffineTransform()));
                Renderer.symbol(symbols.get(2), new Symbols.Delta(Symbols.Handle.TR, new AffineTransform()));
                Renderer.symbol(symbols.get(3), new Symbols.Delta(Symbols.Handle.TL, new AffineTransform()));
                break;
            }
            case 5: {
                Renderer.symbol(symbols.get(0), new Symbols.Delta(Symbols.Handle.BR, new AffineTransform()));
                Renderer.symbol(symbols.get(1), new Symbols.Delta(Symbols.Handle.BL, new AffineTransform()));
                Renderer.symbol(symbols.get(2), new Symbols.Delta(Symbols.Handle.TR, AffineTransform.getTranslateInstance(-bbox.width / 2.0, 0.0)));
                Renderer.symbol(symbols.get(3), new Symbols.Delta(Symbols.Handle.TC, new AffineTransform()));
                Renderer.symbol(symbols.get(4), new Symbols.Delta(Symbols.Handle.TL, AffineTransform.getTranslateInstance(bbox.width / 2.0, 0.0)));
                break;
            }
            case 6: {
                Renderer.symbol(symbols.get(0), new Symbols.Delta(Symbols.Handle.BR, AffineTransform.getTranslateInstance(-bbox.width / 2.0, 0.0)));
                Renderer.symbol(symbols.get(1), new Symbols.Delta(Symbols.Handle.BC, new AffineTransform()));
                Renderer.symbol(symbols.get(2), new Symbols.Delta(Symbols.Handle.BL, AffineTransform.getTranslateInstance(bbox.width / 2.0, 0.0)));
                Renderer.symbol(symbols.get(3), new Symbols.Delta(Symbols.Handle.TR, AffineTransform.getTranslateInstance(-bbox.width / 2.0, 0.0)));
                Renderer.symbol(symbols.get(4), new Symbols.Delta(Symbols.Handle.TC, new AffineTransform()));
                Renderer.symbol(symbols.get(5), new Symbols.Delta(Symbols.Handle.TL, AffineTransform.getTranslateInstance(bbox.width / 2.0, 0.0)));
                break;
            }
            case 7: {
                Renderer.symbol(symbols.get(0), new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -bbox.height / 2.0)));
                Renderer.symbol(symbols.get(1), new Symbols.Delta(Symbols.Handle.RC, AffineTransform.getTranslateInstance(-bbox.width / 2.0, 0.0)));
                Renderer.symbol(symbols.get(2), new Symbols.Delta(Symbols.Handle.CC, new AffineTransform()));
                Renderer.symbol(symbols.get(3), new Symbols.Delta(Symbols.Handle.LC, AffineTransform.getTranslateInstance(bbox.width / 2.0, 0.0)));
                Renderer.symbol(symbols.get(4), new Symbols.Delta(Symbols.Handle.TR, AffineTransform.getTranslateInstance(-bbox.width / 2.0, bbox.height / 2.0)));
                Renderer.symbol(symbols.get(5), new Symbols.Delta(Symbols.Handle.TC, AffineTransform.getTranslateInstance(0.0, bbox.height / 2.0)));
                Renderer.symbol(symbols.get(6), new Symbols.Delta(Symbols.Handle.TL, AffineTransform.getTranslateInstance(bbox.width / 2.0, bbox.height / 2.0)));
                break;
            }
            case 8: {
                Renderer.symbol(symbols.get(0), new Symbols.Delta(Symbols.Handle.BR, AffineTransform.getTranslateInstance(0.0, -bbox.height / 2.0)));
                Renderer.symbol(symbols.get(1), new Symbols.Delta(Symbols.Handle.BL, AffineTransform.getTranslateInstance(0.0, -bbox.height / 2.0)));
                Renderer.symbol(symbols.get(2), new Symbols.Delta(Symbols.Handle.RC, AffineTransform.getTranslateInstance(-bbox.width / 2.0, 0.0)));
                Renderer.symbol(symbols.get(3), new Symbols.Delta(Symbols.Handle.CC, new AffineTransform()));
                Renderer.symbol(symbols.get(4), new Symbols.Delta(Symbols.Handle.LC, AffineTransform.getTranslateInstance(bbox.width / 2.0, 0.0)));
                Renderer.symbol(symbols.get(5), new Symbols.Delta(Symbols.Handle.TR, AffineTransform.getTranslateInstance(-bbox.width / 2.0, bbox.height / 2.0)));
                Renderer.symbol(symbols.get(6), new Symbols.Delta(Symbols.Handle.TC, AffineTransform.getTranslateInstance(0.0, bbox.height / 2.0)));
                Renderer.symbol(symbols.get(7), new Symbols.Delta(Symbols.Handle.TL, AffineTransform.getTranslateInstance(bbox.width / 2.0, bbox.height / 2.0)));
                break;
            }
            case 9: {
                Renderer.symbol(symbols.get(0), new Symbols.Delta(Symbols.Handle.BR, AffineTransform.getTranslateInstance(-bbox.width / 2.0, -bbox.height / 2.0)));
                Renderer.symbol(symbols.get(1), new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -bbox.height / 2.0)));
                Renderer.symbol(symbols.get(2), new Symbols.Delta(Symbols.Handle.BL, AffineTransform.getTranslateInstance(bbox.width / 2.0, -bbox.height / 2.0)));
                Renderer.symbol(symbols.get(3), new Symbols.Delta(Symbols.Handle.RC, AffineTransform.getTranslateInstance(-bbox.width / 2.0, 0.0)));
                Renderer.symbol(symbols.get(4), new Symbols.Delta(Symbols.Handle.CC, new AffineTransform()));
                Renderer.symbol(symbols.get(5), new Symbols.Delta(Symbols.Handle.LC, AffineTransform.getTranslateInstance(bbox.width / 2.0, 0.0)));
                Renderer.symbol(symbols.get(6), new Symbols.Delta(Symbols.Handle.TR, AffineTransform.getTranslateInstance(-bbox.width / 2.0, bbox.height / 2.0)));
                Renderer.symbol(symbols.get(7), new Symbols.Delta(Symbols.Handle.TC, AffineTransform.getTranslateInstance(0.0, bbox.height / 2.0)));
                Renderer.symbol(symbols.get(8), new Symbols.Delta(Symbols.Handle.TL, AffineTransform.getTranslateInstance(bbox.width / 2.0, bbox.height / 2.0)));
            }
        }
    }

    private static Rectangle2D.Double symbolSize(Symbols.Symbol symbol) {
        Symbols.Symbol ssymb = symbol;
        while (ssymb != null) {
            for (Symbols.Instr item : symbol) {
                if (item.type == Symbols.Form.BBOX) {
                    return (Rectangle2D.Double)item.params;
                }
                if (item.type != Symbols.Form.SYMB) continue;
                ssymb = ((Symbols.SubSymbol)item.params).instr;
                break;
            }
            if (ssymb != symbol) continue;
            break;
        }
        return null;
    }

    public static void lineSymbols(Symbols.Symbol prisymb, double space, Symbols.Symbol secsymb, Symbols.Symbol tersymb, int ratio, Color col) {
        if (Rules.feature.geom.prim == S57map.Pflag.NOSP || Rules.feature.geom.prim == S57map.Pflag.POINT) {
            return;
        }
        Rectangle2D.Double prect = Renderer.symbolSize(prisymb);
        Rectangle2D.Double srect = Renderer.symbolSize(secsymb);
        Rectangle2D.Double trect = Renderer.symbolSize(tersymb);
        if (srect == null) {
            ratio = 0;
        }
        if (prect != null) {
            double psize = Math.abs(prect.getY()) * sScale;
            double ssize = srect != null ? Math.abs(srect.getY()) * sScale : 0.0;
            double tsize = trect != null ? Math.abs(srect.getY()) * sScale : 0.0;
            Point2D.Double prev = new Point2D.Double();
            Point2D next = new Point2D.Double();
            Point2D curr = new Point2D.Double();
            Point2D succ = new Point2D.Double();
            boolean gap = true;
            boolean piv = false;
            double len = 0.0;
            double angle = 0.0;
            int stcount = ratio;
            boolean stflag = false;
            Symbols.Symbol symbol = prisymb;
            S57map s57map = map;
            Objects.requireNonNull(s57map);
            S57map.GeomIterator git = new S57map.GeomIterator(s57map, Rules.feature.geom);
            while (git.hasComp()) {
                git.nextComp();
                boolean first = true;
                while (git.hasEdge()) {
                    git.nextEdge();
                    while (git.hasNode()) {
                        S57map.Snode node = git.next();
                        if (node == null) continue;
                        prev = next;
                        next = context.getPoint(node);
                        angle = Math.atan2(next.getY() - ((Point2D)prev).getY(), next.getX() - ((Point2D)prev).getX());
                        piv = true;
                        if (first) {
                            curr = succ = next;
                            gap = space > 0.0;
                            stcount = ratio - 1;
                            symbol = prisymb;
                            len = gap ? psize * space * 0.5 : psize;
                            first = false;
                            continue;
                        }
                        while (curr.distance(next) >= len) {
                            if (piv) {
                                double rem = len;
                                double s = prev.distance(next);
                                double p = curr.distance(prev);
                                if (s > 0.0 && p > 0.0) {
                                    double n = curr.distance(next);
                                    double theta = Math.acos((s * s + p * p - n * n) / 2.0 / s / p);
                                    double phi = Math.asin(p / len * Math.sin(theta));
                                    rem = len * Math.sin(Math.PI - theta - phi) / Math.sin(theta);
                                }
                                succ = new Point2D.Double(((Point2D)prev).getX() + rem * Math.cos(angle), ((Point2D)prev).getY() + rem * Math.sin(angle));
                                piv = false;
                            } else {
                                succ = new Point2D.Double(curr.getX() + len * Math.cos(angle), curr.getY() + len * Math.sin(angle));
                            }
                            if (!gap) {
                                Symbols.drawSymbol(g2, symbol, sScale, curr.getX(), curr.getY(), new Symbols.Scheme(col), new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getRotateInstance(Math.atan2(succ.getY() - curr.getY(), succ.getX() - curr.getX()) + Math.toRadians(90.0))));
                            }
                            if (space > 0.0) {
                                gap = !gap;
                            }
                            curr = succ;
                            double d = gap ? psize * space : (--stcount == 0 ? (stflag ? tsize : ssize) : (len = psize));
                            if (stcount == 0) {
                                Symbols.Symbol symbol2 = symbol = stflag ? tersymb : secsymb;
                                if (trect != null) {
                                    stflag = !stflag;
                                }
                                stcount = ratio;
                                continue;
                            }
                            symbol = prisymb;
                        }
                    }
                }
            }
        }
    }

    public static void lineVector(Symbols.LineStyle style) {
        Path2D.Double p = new Path2D.Double();
        p.setWindingRule(0);
        S57map s57map = map;
        Objects.requireNonNull(s57map);
        S57map.GeomIterator git = new S57map.GeomIterator(s57map, Rules.feature.geom);
        while (git.hasComp()) {
            git.nextComp();
            boolean first = true;
            while (git.hasEdge()) {
                git.nextEdge();
                Point2D point = context.getPoint(git.next());
                if (first) {
                    p.moveTo(point.getX(), point.getY());
                    first = false;
                } else {
                    p.lineTo(point.getX(), point.getY());
                }
                while (git.hasNode()) {
                    S57map.Snode node = git.next();
                    if (node == null) continue;
                    point = context.getPoint(node);
                    p.lineTo(point.getX(), point.getY());
                }
            }
        }
        if (style.fill != null && Rules.feature.geom.prim == S57map.Pflag.AREA) {
            g2.setPaint(style.fill);
            g2.fill(p);
        }
        if (style.line != null) {
            if (style.dash != null) {
                float[] dash = new float[style.dash.length];
                System.arraycopy(style.dash, 0, dash, 0, style.dash.length);
                int i = 0;
                while (i < style.dash.length) {
                    int n = i++;
                    dash[n] = dash[n] * (float)sScale;
                }
                g2.setStroke(new BasicStroke((float)((double)style.width * sScale), 0, 1, 1.0f, dash, 0.0f));
            } else {
                g2.setStroke(new BasicStroke((float)((double)style.width * sScale), 1, 1));
            }
            g2.setPaint(style.line);
            g2.draw(p);
        }
    }

    public static void grid() {
        if (context.grid() > 0 && map != null) {
            Symbols.LineStyle style = new Symbols.LineStyle(Color.black, 2.0f);
            Point2D point = context.getPoint(new S57map.Snode(Renderer.map.bounds.minlat, Renderer.map.bounds.maxlon));
            double ratio = point.getX() / point.getY();
            double nspan = 60.0 * Math.toDegrees(Renderer.map.bounds.maxlon - Renderer.map.bounds.minlon) / ((double)context.grid() * (ratio > 1.0 ? ratio : 1.0));
            double mult = 1.0;
            if (nspan < 1.0) {
                do {
                    mult *= 10.0;
                } while ((nspan *= 10.0) < 1.0);
            } else if (nspan > 10.0) {
                do {
                    mult /= 10.0;
                } while ((nspan /= 10.0) > 10.0);
            }
            nspan = nspan < 2.0 ? 1.0 : (nspan < 5.0 ? 2.0 : 5.0);
            nspan = nspan / mult / 60.0;
            double left = Math.toDegrees(Renderer.map.bounds.minlon) + 180.0;
            left = Math.ceil(left / nspan);
            left = Math.toRadians(left * nspan - 180.0);
            g2.setStroke(new BasicStroke((float)((double)style.width * sScale), 0, 1));
            Path2D.Double p = new Path2D.Double();
            for (double lon = left; lon < Renderer.map.bounds.maxlon; lon += Math.toRadians(nspan)) {
                point = context.getPoint(new S57map.Snode(Renderer.map.bounds.maxlat, lon));
                p.moveTo(point.getX(), point.getY());
                point = context.getPoint(new S57map.Snode(Renderer.map.bounds.minlat, lon));
                p.lineTo(point.getX(), point.getY());
                double deg = Math.toDegrees(lon);
                String ew = deg < -0.001 ? "W" : (deg > 0.001 ? "E" : "");
                deg = Math.abs(deg);
                String dstr = String.format("%03d\u00b0", (int)Math.floor(deg));
                double min = (deg - Math.floor(deg)) * 60.0;
                String mstr = String.format("%05.2f'%s", min, ew);
                Symbols.Symbol label = new Symbols.Symbol();
                if (!(point.getX() > 600.0)) continue;
                label.add(new Symbols.Instr(Symbols.Form.TEXT, new Symbols.Caption(dstr, new Font("Arial", 0, 40), Color.black, new Symbols.Delta(Symbols.Handle.BR, AffineTransform.getTranslateInstance(-10.0, -20.0)))));
                label.add(new Symbols.Instr(Symbols.Form.TEXT, new Symbols.Caption(mstr, new Font("Arial", 0, 40), Color.black, new Symbols.Delta(Symbols.Handle.BL, AffineTransform.getTranslateInstance(20.0, 0.0)))));
                Symbols.drawSymbol(g2, label, sScale, point.getX(), point.getY(), null, null);
            }
            g2.setPaint(style.line);
            g2.draw(p);
            double tspan = 60.0 * Math.toDegrees(Renderer.map.bounds.maxlat - Renderer.map.bounds.minlat) / ((double)context.grid() / (ratio < 1.0 ? ratio : 1.0));
            mult = 1.0;
            if (tspan < 1.0) {
                do {
                    mult *= 10.0;
                } while ((tspan *= 10.0) < 1.0);
            } else if (tspan > 10.0) {
                do {
                    mult /= 10.0;
                } while ((tspan /= 10.0) > 10.0);
            }
            tspan = tspan < 2.0 ? 1.0 : (tspan < 5.0 ? 2.0 : 5.0);
            tspan = tspan / mult / 60.0;
            double bottom = Math.toDegrees(Renderer.map.bounds.minlat) + 90.0;
            bottom = Math.ceil(bottom / tspan);
            bottom = Math.toRadians(bottom * tspan - 90.0);
            g2.setStroke(new BasicStroke((float)((double)style.width * sScale), 0, 1));
            p = new Path2D.Double();
            for (double lat = bottom; lat < Renderer.map.bounds.maxlat; lat += Math.toRadians(tspan)) {
                point = context.getPoint(new S57map.Snode(lat, Renderer.map.bounds.maxlon));
                p.moveTo(point.getX(), point.getY());
                point = context.getPoint(new S57map.Snode(lat, Renderer.map.bounds.minlon));
                p.lineTo(point.getX(), point.getY());
                double deg = Math.toDegrees(lat);
                String ns = deg < -0.001 ? "S" : (deg > 0.001 ? "N" : "");
                deg = Math.abs(deg);
                String dstr = String.format("%02d\u00b0%s", (int)Math.floor(deg), ns);
                double min = (deg - Math.floor(deg)) * 60.0;
                String mstr = String.format("%05.2f'", min);
                Symbols.Symbol label = new Symbols.Symbol();
                S57map.Snode snode = new S57map.Snode(Renderer.map.bounds.minlat, Renderer.map.bounds.minlon);
                if (!(point.getY() < context.getPoint(snode).getY() - 200.0)) continue;
                label.add(new Symbols.Instr(Symbols.Form.TEXT, new Symbols.Caption(dstr, new Font("Arial", 0, 40), Color.black, new Symbols.Delta(Symbols.Handle.BL, AffineTransform.getTranslateInstance(10.0, -10.0)))));
                label.add(new Symbols.Instr(Symbols.Form.TEXT, new Symbols.Caption(mstr, new Font("Arial", 0, 40), Color.black, new Symbols.Delta(Symbols.Handle.BL, AffineTransform.getTranslateInstance(0.0, 50.0)))));
                Symbols.drawSymbol(g2, label, sScale, point.getX(), point.getY(), null, null);
            }
            g2.setPaint(style.line);
            g2.draw(p);
            Symbols.Symbol legend = new Symbols.Symbol();
            legend.add(new Symbols.Instr(Symbols.Form.BBOX, new Rectangle2D.Double(0.0, 0.0, 500.0, 100.0)));
            Path2D.Double path = new Path2D.Double();
            path.moveTo(0.0, 0.0);
            path.lineTo(500.0, 0.0);
            path.lineTo(500.0, 100.0);
            path.lineTo(0.0, 100.0);
            path.closePath();
            legend.add(new Symbols.Instr(Symbols.Form.FILL, Color.white));
            legend.add(new Symbols.Instr(Symbols.Form.PGON, path));
            legend.add(new Symbols.Instr(Symbols.Form.TEXT, new Symbols.Caption("Mercator Projection", new Font("Arial", 0, 50), Color.black, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(250.0, 60.0)))));
            point = context.getPoint(new S57map.Snode(Renderer.map.bounds.minlat, Renderer.map.bounds.minlon));
            Symbols.drawSymbol(g2, legend, sScale, point.getX(), point.getY(), null, new Symbols.Delta(Symbols.Handle.BL, AffineTransform.getTranslateInstance(0.0, 0.0)));
            legend = new Symbols.Symbol();
            legend.add(new Symbols.Instr(Symbols.Form.BBOX, new Rectangle2D.Double(0.0, 0.0, 500.0, 100.0)));
            legend.add(new Symbols.Instr(Symbols.Form.TEXT, new Symbols.Caption("\u00a9 OpenStreetMap contributors", new Font("Arial", 0, 30), Color.black, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(250.0, 100.0)))));
            point = context.getPoint(new S57map.Snode(Renderer.map.bounds.minlat, Renderer.map.bounds.minlon));
            Symbols.drawSymbol(g2, legend, sScale, point.getX(), point.getY(), null, new Symbols.Delta(Symbols.Handle.BL, AffineTransform.getTranslateInstance(0.0, 0.0)));
        }
    }

    public static void lineCircle(Symbols.LineStyle style, double radius, S57val.UniHLU units) {
        switch (units) {
            case HLU_FEET: {
                radius /= 6076.0;
                break;
            }
            case HLU_KMTR: {
                radius /= 1.852;
                break;
            }
            case HLU_HMTR: {
                radius /= 18.52;
                break;
            }
            case HLU_SMIL: {
                radius /= 1.15078;
                break;
            }
            case HLU_NMIL: {
                break;
            }
            default: {
                radius /= 1852.0;
            }
        }
        radius *= context.mile(Rules.feature);
        Symbols.Symbol circle = new Symbols.Symbol();
        if (style.fill != null) {
            circle.add(new Symbols.Instr(Symbols.Form.FILL, style.fill));
            circle.add(new Symbols.Instr(Symbols.Form.RSHP, new Ellipse2D.Double(-radius, -radius, radius * 2.0, radius * 2.0)));
        }
        circle.add(new Symbols.Instr(Symbols.Form.FILL, style.line));
        circle.add(new Symbols.Instr(Symbols.Form.STRK, new BasicStroke(style.width, 0, 0, 1.0f, style.dash, 0.0f)));
        circle.add(new Symbols.Instr(Symbols.Form.ELPS, new Ellipse2D.Double(-radius, -radius, radius * 2.0, radius * 2.0)));
        Point2D point = context.getPoint(Rules.feature.geom.centre);
        Symbols.drawSymbol(g2, circle, 1.0, point.getX(), point.getY(), null, null);
    }

    public static void fillPattern(BufferedImage image) {
        Path2D.Double p = new Path2D.Double();
        p.setWindingRule(0);
        switch (Rules.feature.geom.prim) {
            case POINT: {
                Point2D point = context.getPoint(Rules.feature.geom.centre);
                g2.drawImage(image, new AffineTransformOp(AffineTransform.getScaleInstance(sScale, sScale), 1), (int)(point.getX() - 50.0 * sScale), (int)(point.getY() - 50.0 * sScale));
                break;
            }
            case AREA: {
                S57map s57map = map;
                Objects.requireNonNull(s57map);
                S57map.GeomIterator git = new S57map.GeomIterator(s57map, Rules.feature.geom);
                while (git.hasComp()) {
                    git.nextComp();
                    boolean newComp = true;
                    while (git.hasEdge()) {
                        git.nextEdge();
                        Point2D point = context.getPoint(git.next());
                        if (newComp) {
                            p.moveTo(point.getX(), point.getY());
                            newComp = false;
                        } else {
                            p.lineTo(point.getX(), point.getY());
                        }
                        while (git.hasNode()) {
                            S57map.Snode node = git.next();
                            if (node == null) continue;
                            point = context.getPoint(node);
                            p.lineTo(point.getX(), point.getY());
                        }
                    }
                }
                g2.setPaint(new TexturePaint(image, new Rectangle(0, 0, 1 + (int)(300.0 * sScale), 1 + (int)(300.0 * sScale))));
                g2.fill(p);
                break;
            }
        }
    }

    public static void labelText(String str, Font font, Color tc) {
        Renderer.labelText(str, font, tc, LabelStyle.NONE, null, null, null);
    }

    public static void labelText(String str, Font font, Color tc, Symbols.Delta delta) {
        Renderer.labelText(str, font, tc, LabelStyle.NONE, null, null, delta);
    }

    public static void labelText(String str, Font font, Color tc, LabelStyle style, Color fg) {
        Renderer.labelText(str, font, tc, style, fg, null, null);
    }

    public static void labelText(String str, Font font, Color tc, LabelStyle style, Color fg, Color bg) {
        Renderer.labelText(str, font, tc, style, fg, bg, null);
    }

    public static void labelText(String str, Font font, Color tc, LabelStyle style, Color fg, Symbols.Delta delta) {
        Renderer.labelText(str, font, tc, style, fg, null, delta);
    }

    public static void labelText(String str, Font font, Color tc, LabelStyle style, Color fg, Color bg, Symbols.Delta delta) {
        double ty;
        double tx;
        if (delta == null) {
            delta = new Symbols.Delta(Symbols.Handle.CC);
        }
        if (bg == null) {
            bg = new Color(0, true);
        }
        if (str == null || str.isEmpty()) {
            str = " ";
        }
        FontRenderContext frc = g2.getFontRenderContext();
        GlyphVector gv = font.deriveFont((float)font.getSize()).createGlyphVector(frc, str.equals(" ") ? "M" : str);
        Rectangle2D bounds = gv.getVisualBounds();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        Symbols.Symbol label = new Symbols.Symbol();
        switch (style) {
            case RRCT: {
                width += height * 1.0;
                height *= 1.5;
                if (width < height) {
                    width = height;
                }
                double lx = -width / 2.0;
                double ly = -height / 2.0;
                tx = lx + height * 0.34;
                ty = ly + height * 0.17;
                label.add(new Symbols.Instr(Symbols.Form.BBOX, new Rectangle2D.Double(lx, ly, width, height)));
                label.add(new Symbols.Instr(Symbols.Form.FILL, bg));
                label.add(new Symbols.Instr(Symbols.Form.RSHP, new RoundRectangle2D.Double(lx, ly, width, height, height, height)));
                label.add(new Symbols.Instr(Symbols.Form.FILL, fg));
                label.add(new Symbols.Instr(Symbols.Form.STRK, new BasicStroke(1 + (int)(height / 10.0), 0, 0)));
                label.add(new Symbols.Instr(Symbols.Form.RRCT, new RoundRectangle2D.Double(lx, ly, width, height, height, height)));
                break;
            }
            case VCLR: {
                width += height * 1.0;
                height *= 2.0;
                if (width < height) {
                    width = height;
                }
                double lx = -width / 2.0;
                double ly = -height / 2.0;
                tx = lx + height * 0.27;
                ty = ly + height * 0.25;
                label.add(new Symbols.Instr(Symbols.Form.BBOX, new Rectangle2D.Double(lx, ly, width, height)));
                label.add(new Symbols.Instr(Symbols.Form.FILL, bg));
                label.add(new Symbols.Instr(Symbols.Form.RSHP, new RoundRectangle2D.Double(lx, ly, width, height, height, height)));
                label.add(new Symbols.Instr(Symbols.Form.FILL, fg));
                int sw = 1 + (int)(height / 10.0);
                double po = sw / 2;
                label.add(new Symbols.Instr(Symbols.Form.STRK, new BasicStroke(sw, 0, 0)));
                Path2D.Double p = new Path2D.Double();
                p.moveTo(-height * 0.2, -ly - po);
                p.lineTo(height * 0.2, -ly - po);
                p.moveTo(0.0, -ly - po);
                p.lineTo(0.0, -ly - po - height * 0.15);
                p.moveTo(-height * 0.2, ly + po);
                p.lineTo(height * 0.2, ly + po);
                p.moveTo(0.0, ly + po);
                p.lineTo(0.0, ly + po + height * 0.15);
                label.add(new Symbols.Instr(Symbols.Form.PLIN, p));
                break;
            }
            case PCLR: {
                width += height * 1.0;
                height *= 2.0;
                if (width < height) {
                    width = height;
                }
                double lx = -width / 2.0;
                double ly = -height / 2.0;
                tx = lx + height * 0.27;
                ty = ly + height * 0.25;
                label.add(new Symbols.Instr(Symbols.Form.BBOX, new Rectangle2D.Double(lx, ly, width, height)));
                label.add(new Symbols.Instr(Symbols.Form.FILL, bg));
                label.add(new Symbols.Instr(Symbols.Form.RSHP, new RoundRectangle2D.Double(lx, ly, width, height, height, height)));
                label.add(new Symbols.Instr(Symbols.Form.FILL, fg));
                int sw = 1 + (int)(height / 10.0);
                double po = sw / 2;
                label.add(new Symbols.Instr(Symbols.Form.STRK, new BasicStroke(sw, 0, 0)));
                Path2D.Double p = new Path2D.Double();
                p.moveTo(-height * 0.2, -ly - po);
                p.lineTo(height * 0.2, -ly - po);
                p.moveTo(0.0, -ly - po);
                p.lineTo(0.0, -ly - po - height * 0.15);
                p.moveTo(-height * 0.2, ly + po);
                p.lineTo(height * 0.2, ly + po);
                p.moveTo(0.0, ly + po);
                p.lineTo(0.0, ly + po + height * 0.15);
                label.add(new Symbols.Instr(Symbols.Form.PLIN, p));
                label.add(new Symbols.Instr(Symbols.Form.SYMB, new Symbols.SubSymbol(Areas.CableFlash, 1.0, 0.0, 0.0, null, new Symbols.Delta(Symbols.Handle.CC, new AffineTransform(0.0, -1.0, 1.0, 0.0, -width / 2.0, 0.0)))));
                label.add(new Symbols.Instr(Symbols.Form.SYMB, new Symbols.SubSymbol(Areas.CableFlash, 1.0, 0.0, 0.0, null, new Symbols.Delta(Symbols.Handle.CC, new AffineTransform(0.0, -1.0, 1.0, 0.0, width / 2.0, 0.0)))));
                break;
            }
            case HCLR: {
                width += height * 1.5;
                height *= 1.5;
                if (width < height) {
                    width = height;
                }
                double lx = -width / 2.0;
                double ly = -height / 2.0;
                tx = lx + height * 0.5;
                ty = ly + height * 0.17;
                label.add(new Symbols.Instr(Symbols.Form.BBOX, new Rectangle2D.Double(lx, ly, width, height)));
                label.add(new Symbols.Instr(Symbols.Form.FILL, bg));
                label.add(new Symbols.Instr(Symbols.Form.RSHP, new RoundRectangle2D.Double(lx, ly, width, height, height, height)));
                label.add(new Symbols.Instr(Symbols.Form.FILL, fg));
                int sw = 1 + (int)(height / 10.0);
                double vo = height / 4.0;
                label.add(new Symbols.Instr(Symbols.Form.STRK, new BasicStroke(sw, 0, 0)));
                Path2D.Double p = new Path2D.Double();
                p.moveTo(-width * 0.4 - (double)sw, -ly - vo);
                p.lineTo(-width * 0.4 - (double)sw, ly + vo);
                p.moveTo(-width * 0.4 - (double)sw, 0.0);
                p.lineTo(-width * 0.4 + (double)sw, 0.0);
                p.moveTo(width * 0.4 + (double)sw, -ly - vo);
                p.lineTo(width * 0.4 + (double)sw, ly + vo);
                p.moveTo(width * 0.4 - (double)sw, 0.0);
                p.lineTo(width * 0.4 + (double)sw, 0.0);
                label.add(new Symbols.Instr(Symbols.Form.PLIN, p));
                break;
            }
            default: {
                double lx = -width / 2.0;
                double ly = -height / 2.0;
                tx = lx;
                ty = ly;
                label.add(new Symbols.Instr(Symbols.Form.BBOX, new Rectangle2D.Double(lx, ly, width, height)));
            }
        }
        label.add(new Symbols.Instr(Symbols.Form.TEXT, new Symbols.Caption(str, font, tc, new Symbols.Delta(Symbols.Handle.TL, AffineTransform.getTranslateInstance(tx, ty)))));
        Point2D point = context.getPoint(Rules.feature.geom.centre);
        Symbols.drawSymbol(g2, label, sScale, point.getX(), point.getY(), null, delta);
    }

    public static void lineText(String str, Font font, Color colour, double dy) {
        if (!str.isEmpty()) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setPaint(colour);
            FontRenderContext frc = g2.getFontRenderContext();
            GlyphVector gv = font.deriveFont(font.getSize2D() * (float)sScale).createGlyphVector(frc, str);
            double width = gv.getVisualBounds().getWidth();
            double height = gv.getVisualBounds().getHeight();
            double offset = (Rules.feature.geom.length * context.mile(Rules.feature) - width) / 2.0;
            if (offset > 0.0) {
                Point2D before = null;
                Point2D after = null;
                ArrayList<Point2D> between = new ArrayList<Point2D>();
                Point2D prev = null;
                Point2D next = null;
                double length = 0.0;
                double lb = 0.0;
                double la = 0.0;
                S57map s57map = map;
                Objects.requireNonNull(s57map);
                S57map.GeomIterator git = new S57map.GeomIterator(s57map, Rules.feature.geom);
                if (git.hasComp()) {
                    git.nextComp();
                    while (git.hasEdge()) {
                        git.nextEdge();
                        while (git.hasNode()) {
                            S57map.Snode node = git.next();
                            if (node == null) continue;
                            prev = next;
                            next = context.getPoint(node);
                            if (prev != null) {
                                length += Math.sqrt(Math.pow(next.getX() - prev.getX(), 2.0) + Math.pow(next.getY() - prev.getY(), 2.0));
                            }
                            if (length < offset) {
                                before = next;
                                lb = la = length;
                                continue;
                            }
                            if (after != null) continue;
                            if (length > offset + width) {
                                after = next;
                                la = length;
                                break;
                            }
                            between.add(next);
                        }
                        if (after == null) continue;
                    }
                }
                if (after != null) {
                    double angle = Math.atan2(after.getY() - before.getY(), after.getX() - before.getX());
                    double rotate = Math.abs(angle) < 1.5707963267948966 ? angle : angle + Math.PI;
                    Point2D.Double mid = new Point2D.Double((before.getX() + after.getX()) / 2.0, (before.getY() + after.getY()) / 2.0);
                    Point2D centre = context.getPoint(Rules.feature.geom.centre);
                    AffineTransform pos = AffineTransform.getTranslateInstance(-dy * Math.sin(rotate), dy * Math.cos(rotate));
                    pos.rotate(rotate);
                    pos.translate(((Point2D)mid).getX() - centre.getX(), ((Point2D)mid).getY() - centre.getY());
                    Symbols.Symbol label = new Symbols.Symbol();
                    label.add(new Symbols.Instr(Symbols.Form.BBOX, new Rectangle2D.Double(-width / 2.0, -height, width, height)));
                    label.add(new Symbols.Instr(Symbols.Form.TEXT, new Symbols.Caption(str, font, colour, new Symbols.Delta(Symbols.Handle.BC))));
                    Symbols.drawSymbol(g2, label, sScale, centre.getX(), centre.getY(), null, new Symbols.Delta(Symbols.Handle.BC, pos));
                }
            }
        }
    }

    public static void lightSector(Color col1, Color col2, double radius, double s1, double s2, Double dir, String str) {
        double mid = ((s1 + s2) / 2.0 + (double)(s1 > s2 ? 180 : 0)) % 360.0;
        g2.setStroke(new BasicStroke((float)(3.0 * sScale), 0, 1, 1.0f, new float[]{20.0f * (float)sScale, 20.0f * (float)sScale}, 0.0f));
        g2.setPaint(Color.black);
        Point2D.Double centre = (Point2D.Double)context.getPoint(Rules.feature.geom.centre);
        double radial = radius * context.mile(Rules.feature);
        if (dir != null) {
            g2.draw(new Line2D.Double(centre.x, centre.y, centre.x - radial * Math.sin(Math.toRadians(dir)), centre.y + radial * Math.cos(Math.toRadians(dir))));
        } else if (s1 != 0.0 || s2 != 360.0) {
            g2.draw(new Line2D.Double(centre.x, centre.y, centre.x - radial * Math.sin(Math.toRadians(s1)), centre.y + radial * Math.cos(Math.toRadians(s1))));
            g2.draw(new Line2D.Double(centre.x, centre.y, centre.x - radial * Math.sin(Math.toRadians(s2)), centre.y + radial * Math.cos(Math.toRadians(s2))));
        }
        double arcWidth = 10.0 * sScale;
        g2.setStroke(new BasicStroke((float)arcWidth, 0, 0, 1.0f));
        g2.setPaint(col1);
        g2.draw(new Arc2D.Double(centre.x - radial, centre.y - radial, 2.0 * radial, 2.0 * radial, -(s1 + 90.0), s1 < s2 ? s1 - s2 : s1 - s2 - 360.0, 0));
        if (col2 != null) {
            g2.setPaint(col2);
            g2.draw(new Arc2D.Double(centre.x - radial + arcWidth, centre.y - radial + arcWidth, 2.0 * (radial - arcWidth), 2.0 * (radial - arcWidth), -(s1 + 90.0), s1 < s2 ? s1 - s2 : s1 - s2 - 360.0, 0));
        }
        if (str != null && !str.isEmpty()) {
            Font font = new Font("Arial", 0, 40);
            double arc = s2 > s1 ? s2 - s1 : s2 - s1 + 360.0;
            double awidth = Math.toRadians(arc) * radial;
            boolean hand = mid > 270.0 || mid < 90.0;
            double phi = Math.toRadians(mid);
            AffineTransform at = AffineTransform.getTranslateInstance(-(radial += 30.0 * sScale) * Math.sin(phi) / sScale, radial * Math.cos(phi) / sScale);
            if ((double)font.getSize() * sScale * (double)str.length() < awidth) {
                at.rotate(Math.toRadians(mid + (double)(hand ? 0 : 180)));
                Renderer.labelText(str, font, Color.black, new Symbols.Delta(Symbols.Handle.CC, at));
            } else if ((double)font.getSize() * sScale < awidth) {
                hand = mid < 180.0;
                at.rotate(Math.toRadians(mid + (double)(hand ? -90 : 90)));
                Renderer.labelText(str, font, Color.black, hand ? new Symbols.Delta(Symbols.Handle.RC, at) : new Symbols.Delta(Symbols.Handle.LC, at));
            }
            if (dir != null) {
                font = new Font("Arial", 0, 30);
                str = dir + "\u00b0";
                hand = dir > 180.0;
                phi = Math.toRadians(dir + (hand ? -0.5 : 0.5));
                at = AffineTransform.getTranslateInstance(-(radial -= 70.0 * sScale) * Math.sin(phi) / sScale, radial * Math.cos(phi) / sScale);
                at.rotate(Math.toRadians(dir + (double)(hand ? 90 : -90)));
                Renderer.labelText(str, font, Color.black, hand ? new Symbols.Delta(Symbols.Handle.BR, at) : new Symbols.Delta(Symbols.Handle.BL, at));
            }
        }
    }

    public static void rasterPixel(double size, Color col) {
        double s = Rules.feature.geom.centre.lat - size / 2.0;
        double w = Rules.feature.geom.centre.lon - size / 2.0;
        double n = Rules.feature.geom.centre.lat + size / 2.0;
        double e = Rules.feature.geom.centre.lon + size / 2.0;
        Point2D sw = context.getPoint(new S57map.Snode(s, w));
        Point2D nw = context.getPoint(new S57map.Snode(n, w));
        Point2D ne = context.getPoint(new S57map.Snode(n, e));
        Point2D se = context.getPoint(new S57map.Snode(s, e));
        Symbols.Symbol pixel = new Symbols.Symbol();
        Path2D.Double path = new Path2D.Double();
        path.moveTo(sw.getX(), sw.getY());
        path.lineTo(nw.getX(), nw.getY());
        path.lineTo(ne.getX(), ne.getY());
        path.lineTo(se.getX(), se.getY());
        path.closePath();
        pixel.add(new Symbols.Instr(Symbols.Form.FILL, col));
        pixel.add(new Symbols.Instr(Symbols.Form.PGON, path));
        Symbols.drawSymbol(g2, pixel, 1.0, 0.0, 0.0, null, null);
    }

    public static enum LabelStyle {
        NONE,
        RRCT,
        RECT,
        ELPS,
        CIRC,
        VCLR,
        PCLR,
        HCLR;

    }
}

