/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.selection;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class UndoSelectionAction
extends JosmAction {
    private transient Collection<OsmPrimitive> lastSel;
    private int index;

    public UndoSelectionAction() {
        super(I18n.tr((String)"Undo selection", (Object[])new Object[0]), "undoselection", I18n.tr((String)"Reselect last added object or selection form history", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:undoselection", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{"Undo selection"}), (int)90, (int)5009), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/UndoSelection"));
    }

    public void actionPerformed(ActionEvent e) {
        DataSet ds = this.getLayerManager().getActiveDataSet();
        if (ds != null) {
            LinkedList history = ds.getSelectionHistory();
            if (history == null || history.isEmpty()) {
                return;
            }
            if (this.lastSel != null) {
                Collection selection = ds.getSelected();
                if (this.lastSel.size() != selection.size() || !selection.containsAll(this.lastSel)) {
                    this.index = -1;
                }
            }
            int num = history.size();
            HashSet<OsmPrimitive> newSel = new HashSet<OsmPrimitive>();
            for (int k = 0; k < num; ++k) {
                Collection oldSel;
                this.index = this.index + 1 < history.size() ? ++this.index : 0;
                Collection histsel = (Collection)history.get(this.index);
                newSel.clear();
                newSel.addAll(histsel);
                newSel.removeIf(p -> p == null || p.isDeleted() || p.isDisabled());
                if (newSel.isEmpty() || (oldSel = ds.getSelected()).size() == newSel.size() && newSel.containsAll(oldSel)) continue;
            }
            ds.setSelected(newSel);
            this.lastSel = ds.getSelected();
        }
    }

    protected void updateEnabledState() {
        this.lastSel = null;
        this.index = -1;
        this.setEnabled(this.getLayerManager().getActiveDataSet() != null);
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(this.getLayerManager().getActiveDataSet() != null);
    }
}

