/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SplitWayCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class SplitObjectAction
extends JosmAction {
    public SplitObjectAction() {
        super(I18n.tr((String)"Split Object", (Object[])new Object[0]), "splitobject", I18n.tr((String)"Split an object at the selected nodes.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:splitobject", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Split Object", (Object[])new Object[0])}), (int)88, (int)5004), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/SplitObject"));
    }

    public void actionPerformed(ActionEvent e) {
        DataSet ds = this.getLayerManager().getEditDataSet();
        if (!this.checkSelection(ds.getSelected())) {
            this.showWarningNotification(I18n.tr((String)"The current selection cannot be used for splitting.", (Object[])new Object[0]));
            return;
        }
        ArrayList<Node> selectedNodes = new ArrayList<Node>(ds.getSelectedNodes());
        ArrayList selectedWays = new ArrayList(ds.getSelectedWays());
        Way selectedWay = null;
        Object splitWay = null;
        if (selectedNodes.size() != 2) {
            selectedNodes.clear();
            for (Object selWay : selectedWays) {
                if (selWay != null && selWay.isUsable() && selWay.getNodesCount() > 0 && !selWay.isClosed() && selWay.getKeys().isEmpty()) {
                    selectedNodes.add(selWay.firstNode());
                    selectedNodes.add(selWay.lastNode());
                    splitWay = selWay;
                    continue;
                }
                selectedWay = selWay;
            }
        } else if (selectedWays.size() == 1) {
            selectedWay = (Way)selectedWays.get(0);
        }
        if (selectedWay == null && !selectedNodes.isEmpty()) {
            HashMap<Way, Integer> wayOccurenceCounter = new HashMap<Way, Integer>();
            for (Node node : selectedNodes) {
                block2: for (Way w : node.getParentWays()) {
                    if (!w.isUsable() || w.getNodesCount() < 5 || !w.isClosed()) continue;
                    for (Object wn : w.getNodes()) {
                        if (!node.equals(wn)) continue;
                        Integer old = (Integer)wayOccurenceCounter.get(w);
                        wayOccurenceCounter.put(w, old == null ? 1 : old + 1);
                        continue block2;
                    }
                }
            }
            if (wayOccurenceCounter.isEmpty()) {
                this.showWarningNotification(I18n.trn((String)"The selected node is not in the middle of any way.", (String)"The selected nodes are not in the middle of any way.", (long)selectedNodes.size(), (Object[])new Object[0]));
                return;
            }
            for (Map.Entry entry : wayOccurenceCounter.entrySet()) {
                if (!((Integer)entry.getValue()).equals(selectedNodes.size())) continue;
                if (selectedWay != null) {
                    this.showWarningNotification(I18n.trn((String)"There is more than one way using the node you selected. Please select the way also.", (String)"There is more than one way using the nodes you selected. Please select the way also.", (long)selectedNodes.size(), (Object[])new Object[0]));
                    return;
                }
                selectedWay = (Way)entry.getKey();
            }
            if (selectedWay == null) {
                this.showWarningNotification(I18n.tr((String)"The selected nodes do not share the same way.", (Object[])new Object[0]));
                return;
            }
        } else if (selectedWay != null && !selectedNodes.isEmpty()) {
            if (!selectedWay.isClosed()) {
                this.showWarningNotification(I18n.tr((String)"The selected way is not closed.", (Object[])new Object[0]));
                return;
            }
            HashSet nds = new HashSet(selectedNodes);
            nds.removeAll(selectedWay.getNodes());
            if (!nds.isEmpty()) {
                this.showWarningNotification(I18n.trn((String)"The selected way does not contain the selected node.", (String)"The selected way does not contain all the selected nodes.", (long)selectedNodes.size(), (Object[])new Object[0]));
                return;
            }
        } else if (selectedWay != null && selectedNodes.isEmpty()) {
            this.showWarningNotification(I18n.tr((String)"The selected way is not a split way, please select split points or split way too.", (Object[])new Object[0]));
            return;
        }
        Node node1 = (Node)selectedNodes.get(0);
        int nodeIndex1 = -1;
        Node node = (Node)selectedNodes.get(1);
        int nodeIndex2 = -1;
        int i = 0;
        for (Object wn : selectedWay.getNodes()) {
            if (nodeIndex1 == -1 && wn.equals((Object)node1)) {
                nodeIndex1 = i;
            } else if (nodeIndex2 == -1 && wn.equals((Object)node)) {
                nodeIndex2 = i;
            }
            ++i;
        }
        if (nodeIndex1 == nodeIndex2 + 1 || nodeIndex2 == nodeIndex1 + 1 || nodeIndex1 == 0 && nodeIndex2 == selectedWay.getNodesCount() - 2 || nodeIndex2 == 0 && nodeIndex1 == selectedWay.getNodesCount() - 2) {
            this.showWarningNotification(I18n.tr((String)"The selected nodes can not be consecutive nodes in the object.", (Object[])new Object[0]));
            return;
        }
        List wayChunks = SplitWayCommand.buildSplitChunks((Way)selectedWay, selectedNodes);
        if (wayChunks != null) {
            if (splitWay == null) {
                for (List wayChunk : wayChunks) {
                    wayChunk.add((Node)wayChunk.get(0));
                }
            } else {
                for (List wayChunk : wayChunks) {
                    List way = splitWay.getNodes();
                    if (((Node)wayChunk.get(0)).equals((Object)splitWay.firstNode())) {
                        way.remove(way.size() - 1);
                        Collections.reverse(way);
                    } else {
                        way.remove(0);
                    }
                    wayChunk.addAll(way);
                }
            }
            SplitWayCommand result = SplitWayCommand.splitWay((Way)selectedWay, (List)wayChunks, Collections.emptyList());
            UndoRedoHandler.getInstance().add((Command)result);
            if (splitWay != null) {
                UndoRedoHandler.getInstance().add((Command)new DeleteCommand((OsmPrimitive)splitWay));
            }
            this.getLayerManager().getEditDataSet().setSelected((Collection)result.getNewSelection());
        }
    }

    private boolean checkSelection(Collection<? extends OsmPrimitive> selection) {
        int node = 0;
        int ways = 0;
        for (OsmPrimitive osmPrimitive : selection) {
            if (osmPrimitive instanceof Way) {
                ++ways;
                continue;
            }
            if (osmPrimitive instanceof Node) {
                ++node;
                continue;
            }
            return false;
        }
        return node == 2 || ways == 1 || ways == 2;
    }

    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(this.checkSelection(selection));
    }

    void showWarningNotification(String msg) {
        new Notification(msg).setIcon(2).show();
    }
}

