/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.alignways;

import java.awt.event.ActionEvent;
import java.util.Collection;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.alignways.AlignWaysCmdKeepAngles;
import org.openstreetmap.josm.plugins.alignways.AlignWaysCmdKeepLength;
import org.openstreetmap.josm.plugins.alignways.AlignWaysDialog;
import org.openstreetmap.josm.plugins.alignways.AlignWaysPlugin;
import org.openstreetmap.josm.plugins.alignways.AlignWaysSegmentMgr;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class AlignWaysAction
extends JosmAction {
    private static final long serialVersionUID = -1540319652562985458L;

    public AlignWaysAction() {
        super(I18n.tr((String)"Align Way Segments", (Object[])new Object[0]), "alignways", I18n.tr((String)"Makes a pair of selected way segments parallel by rotating one of them around a chosen pivot.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:alignways", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Align Ways", (Object[])new Object[0])}), (int)32, (int)5005), true);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        AlignWaysCmdKeepLength cmdAW;
        if (!this.isEnabled()) {
            return;
        }
        DataSet ds = this.getLayerManager().getEditDataSet();
        if (ds == null) {
            return;
        }
        Collection<Node> affectableNodes = AlignWaysSegmentMgr.getInstance(MainApplication.getMap().mapView).getSelectedNodes();
        Command c = UndoRedoHandler.getInstance().getLastCommand();
        if (!(c instanceof AlignWaysCmdKeepLength && affectableNodes.equals(((AlignWaysCmdKeepLength)c).getPrevAffectedNodes()) || !(cmdAW = AlignWaysPlugin.getAwDialog().getAwOpt() == AlignWaysDialog.AligningModeOption.ALGN_OPT_KEEP_ANGLE ? new AlignWaysCmdKeepAngles(ds) : new AlignWaysCmdKeepLength(ds)).executable())) {
            UndoRedoHandler.getInstance().add((Command)cmdAW);
        }
        MainApplication.getMap().mapView.repaint();
    }
}

