/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pdfimport.pdfbox;

import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.util.PDFStreamEngine;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.pdfimport.PathOptimizer;
import org.openstreetmap.josm.plugins.pdfimport.pdfbox.GraphicsProcessor;
import org.openstreetmap.josm.plugins.pdfimport.pdfbox.PageDrawer;
import org.openstreetmap.josm.tools.I18n;

public class PdfBoxParser
extends PDFStreamEngine {
    private final PathOptimizer target;

    public PdfBoxParser(PathOptimizer target) {
        this.target = target;
    }

    public void parse(File file, int maxPaths, ProgressMonitor monitor) throws IOException {
        monitor.beginTask(I18n.tr((String)"Parsing PDF", (Object[])new Object[]{1}));
        try (PDDocument document = PDDocument.load(file);){
            if (document.isEncrypted()) {
                throw new IllegalArgumentException(I18n.tr((String)"Encrypted documents not supported.", (Object[])new Object[0]));
            }
            List allPages = document.getDocumentCatalog().getAllPages();
            if (allPages.size() != 1) {
                throw new IllegalArgumentException(I18n.tr((String)"The PDF file must have exactly one page.", (Object[])new Object[0]));
            }
            PDPage page = (PDPage)allPages.get(0);
            PDRectangle pageSize = page.findMediaBox();
            Integer rotationVal = page.getRotation();
            int rotation = 0;
            if (rotationVal != null) {
                rotation = rotationVal;
            }
            new PageDrawer().drawPage(new GraphicsProcessor(this.target, rotation, maxPaths, monitor), page);
            this.target.bounds = new Rectangle2D.Double(pageSize.getLowerLeftX(), pageSize.getLowerLeftY(), pageSize.getWidth(), pageSize.getHeight());
        }
        monitor.finishTask();
    }
}

