/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pdfimport;

import org.openstreetmap.josm.spi.preferences.Config;

public class Preferences {
    protected static int GuiCode;
    private static String prefix;

    public static String getLoadDir() {
        return Config.getPref().get(prefix + "loadDir");
    }

    public static void setLoadDir(String loadDir) {
        Config.getPref().put(prefix + "loadDir", loadDir);
    }

    public static GuiMode getGuiMode() {
        int GuiCode = Config.getPref().getInt(prefix + "guiCode", 0);
        switch (GuiCode) {
            case -1: 
            case 1: {
                return GuiMode.Expert;
            }
            case 2: {
                return GuiMode.Simple;
            }
        }
        if (Config.getPref().getBoolean("expert")) {
            return GuiMode.Expert;
        }
        return GuiMode.Simple;
    }

    public static void setGuiCode(int guiCode) {
        Config.getPref().putInt(prefix + "guiCode", guiCode);
    }

    public static int getGuiCode() {
        int GuiCode = Config.getPref().getInt(prefix + "guiCode", 0);
        return GuiCode;
    }

    public static boolean isLegacyActions() {
        return Config.getPref().getInt(prefix + "guiCode", 0) == -1;
    }

    public static void setMergeNodes(boolean v) {
        Config.getPref().putBoolean(prefix + "mergeNodes", v);
    }

    public static boolean isMergeNodes() {
        return Config.getPref().getBoolean(prefix + "mergeNodes");
    }

    public static double getMergeNodesValue() {
        return Config.getPref().getDouble(prefix + "mergeNodes.value", 0.001);
    }

    public static void setMergeNodesValue(double v) {
        Config.getPref().putDouble(prefix + "mergeNodes.value", v);
    }

    public static boolean isRemoveSmall() {
        return Config.getPref().getBoolean(prefix + "removeSmall");
    }

    public static void setRemoveSmall(boolean v) {
        Config.getPref().putBoolean(prefix + "removeSmall", v);
    }

    public static double getRemoveSmallValue() {
        return Config.getPref().getDouble(prefix + "removeSmall.value", 1.0);
    }

    public static void setRemoveSmallValue(double v) {
        Config.getPref().putDouble(prefix + "removeSmall.value", v);
    }

    public static boolean isRemoveLarge() {
        return Config.getPref().getBoolean(prefix + "removeLarge");
    }

    public static void setRemoveLarge(boolean v) {
        Config.getPref().putBoolean(prefix + "removeLarge", v);
    }

    public static double getRemoveLargeValue() {
        return Config.getPref().getDouble(prefix + "removeLarge.value", 10.0);
    }

    public static void setRemoveLargeValue(double v) {
        Config.getPref().putDouble(prefix + "removeLarge.value", v);
    }

    public static boolean isRemoveParallel() {
        return Config.getPref().getBoolean(prefix + "removeParallel");
    }

    public static void setRemoveParallel(boolean v) {
        Config.getPref().putBoolean(prefix + "removeParallel", v);
    }

    public static double getRemoveParallelValue() {
        return Config.getPref().getDouble(prefix + "removeParallel.value", 3.0);
    }

    public static void setRemoveParallelValue(double v) {
        Config.getPref().putDouble(prefix + "removeParallel.value", v);
    }

    public static boolean isLimitPath() {
        return Config.getPref().getBoolean(prefix + "limitPath");
    }

    public static void setLimitPath(boolean v) {
        Config.getPref().putBoolean(prefix + "limitPath", v);
    }

    public static int getLimitPathValue() {
        return Config.getPref().getInt(prefix + "limitPath.value", Integer.MAX_VALUE);
    }

    public static void setLimitPathValue(int v) {
        Config.getPref().putInt(prefix + "limitPath.value", v);
    }

    public static boolean isLimitColor() {
        return Config.getPref().getBoolean(prefix + "limitColor");
    }

    public static void setLimitColor(boolean v) {
        Config.getPref().putBoolean(prefix + "limitColor", v);
    }

    public static String getLimitColorValue() {
        return Config.getPref().get(prefix + "limitColor.value", "#000000");
    }

    public static void setLimitColorValue(String v) {
        Config.getPref().put(prefix + "limitColor.value", v);
    }

    public static boolean isDebugTags() {
        return Config.getPref().getBoolean(prefix + "debugTags");
    }

    public static void setDebugTags(boolean v) {
        Config.getPref().putBoolean(prefix + "debugTags", v);
    }

    public static boolean isLayerClosed() {
        return Config.getPref().getBoolean(prefix + "layerClosed");
    }

    public static void setLayerClosed(boolean v) {
        Config.getPref().putBoolean(prefix + "layerClosed", v);
    }

    public static boolean isLayerSegment() {
        boolean v = Config.getPref().getBoolean(prefix + "layerSegment");
        return Config.getPref().getBoolean(prefix + "layerSegment");
    }

    public static void setLayerSegment(boolean v) {
        Config.getPref().putBoolean(prefix + "layerSegment", v);
    }

    public static boolean isLayerAttribChange() {
        return Config.getPref().getBoolean(prefix + "layerAttribChanges");
    }

    public static void setLayerAttribChange(boolean v) {
        Config.getPref().putBoolean(prefix + "layerAttribChanges", v);
    }

    public static boolean isLayerOrtho() {
        return Config.getPref().getBoolean(prefix + "layerOrtho");
    }

    public static void setLayerOrtho(boolean v) {
        Config.getPref().putBoolean(prefix + "layerOrtho", v);
    }

    private Preferences() {
    }

    public Preferences(String p) {
        prefix = p + ".";
    }

    public static enum GuiMode {
        Auto,
        Expert,
        Simple;

    }
}

