/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.piclayer.layer.CalibrationFileFilter;
import org.openstreetmap.josm.plugins.piclayer.layer.PicLayerAbstract;
import org.openstreetmap.josm.tools.I18n;

public class SavePictureCalibrationAction
extends JosmAction {
    PicLayerAbstract m_owner = null;

    public SavePictureCalibrationAction(PicLayerAbstract owner) {
        super(I18n.tr((String)"Save Picture Calibration...", (Object[])new Object[0]), null, I18n.tr((String)"Saves calibration data to a file", (Object[])new Object[0]), null, false);
        this.m_owner = owner;
    }

    public void actionPerformed(ActionEvent arg0) {
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(true);
        fc.setFileFilter(new CalibrationFileFilter());
        fc.setSelectedFile(new File(this.m_owner.getPicLayerName() + ".cal"));
        int result = fc.showSaveDialog((Component)MainApplication.getMainFrame());
        if (result == 0) {
            File file = fc.getSelectedFile();
            String path = file.getAbsolutePath();
            if (path.length() < ".cal".length() || !path.substring(path.length() - 4).equals(".cal")) {
                file = new File(path + ".cal");
            }
            Properties props = new Properties();
            this.m_owner.saveCalibration(props);
            try {
                props.store(new FileOutputStream(file), "JOSM PicLayer plugin calibration data");
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Saving file failed: {0}", (Object[])new Object[]{e.getMessage()}), I18n.tr((String)"Problem occurred", (Object[])new Object[0]), 2);
            }
        }
    }
}

