/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.core.access;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.plugins.graphview.core.access.AccessRuleset;
import org.openstreetmap.josm.plugins.graphview.core.access.Implication;
import org.openstreetmap.josm.plugins.graphview.core.access.ImplicationXMLReader;
import org.openstreetmap.josm.plugins.graphview.core.data.Tag;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public final class AccessRulesetReader {
    private AccessRulesetReader() {
    }

    public static AccessRuleset readAccessRuleset(InputStream inputStream) throws AccessRulesetSyntaxException, IOException {
        RulesetHandler rulesetHandler = new RulesetHandler();
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            InputSource input = new InputSource(inputStream);
            reader.setContentHandler(rulesetHandler);
            reader.setErrorHandler(null);
            reader.parse(input);
        }
        catch (SAXException e) {
            throw new AccessRulesetSyntaxException(e);
        }
        return rulesetHandler.getAccessRuleset();
    }

    private static class RulesetHandler
    extends DefaultHandler {
        private final Collection<AccessClass> accessClasses = new LinkedList<AccessClass>();
        private final Collection<Tag> baseTags = new LinkedList<Tag>();
        private Section currentSection = Section.NONE;
        private AccessClass currentAccessClass = null;
        private ImplicationXMLReader implicationReader = null;
        private final List<Implication> implications = new LinkedList<Implication>();

        private RulesetHandler() {
        }

        AccessRuleset getAccessRuleset() {
            return new AccessRuleset(){

                @Override
                public List<String> getAccessHierarchyAncestors(String transportMode) {
                    for (AccessClass accessClass : accessClasses) {
                        if (!accessClass.name.equals(transportMode)) continue;
                        return accessClass.getAncestorHierarchy();
                    }
                    return new LinkedList<String>();
                }

                @Override
                public Collection<Tag> getBaseTags() {
                    return baseTags;
                }

                @Override
                public List<Implication> getImplications() {
                    return implications;
                }
            };
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (this.implicationReader != null) {
                this.implicationReader.startElement(uri, localName, name, attributes);
                return;
            }
            if ("classes".equals(name)) {
                if (this.currentSection != Section.NONE) {
                    throw new SAXException(I18n.tr((String)"Classes element below root child level", (Object[])new Object[0]));
                }
                this.currentSection = Section.CLASSES;
                return;
            } else if ("class".equals(name)) {
                String className = attributes.getValue("name");
                if (this.currentSection != Section.CLASSES) {
                    throw new SAXException(I18n.tr((String)"Class element ({0}) outside classes element", (Object[])new Object[]{className}));
                }
                if (className == null) {
                    throw new SAXException(I18n.tr((String)"Class element without name", (Object[])new Object[0]));
                }
                AccessClass newAccessClass = new AccessClass(className, this.currentAccessClass);
                this.accessClasses.add(newAccessClass);
                this.currentAccessClass = newAccessClass;
                return;
            } else if ("basetags".equals(name)) {
                if (this.currentSection != Section.NONE) {
                    throw new SAXException(I18n.tr((String)"Classes element below root child level", (Object[])new Object[0]));
                }
                this.currentSection = Section.BASETAGS;
                return;
            } else if ("tag".equals(name)) {
                if (this.currentSection != Section.BASETAGS) throw new SAXException(I18n.tr((String)"Tag element outside basetag and implication elements", (Object[])new Object[0]));
                this.baseTags.add(RulesetHandler.readTag(attributes));
                return;
            } else {
                if (!"implications".equals(name)) return;
                if (this.currentSection != Section.NONE) {
                    throw new SAXException(I18n.tr((String)"Implications element below root child level", (Object[])new Object[0]));
                }
                this.implicationReader = new ImplicationXMLReader();
                this.currentSection = Section.IMPLICATIONS;
            }
        }

        private static Tag readTag(Attributes attributes) throws SAXException {
            String key = attributes.getValue("k");
            String value = attributes.getValue("v");
            if (key == null) {
                throw new SAXException(I18n.tr((String)"Tag without key", (Object[])new Object[0]));
            }
            if (value == null) {
                throw new SAXException(I18n.tr((String)"Tag without value (key is {0})", (Object[])new Object[]{key}));
            }
            return new Tag(key, value);
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (this.implicationReader != null && !"implications".equals(name)) {
                this.implicationReader.endElement(uri, localName, name);
            }
            if ("classes".equals(name)) {
                if (this.currentSection != Section.CLASSES) {
                    throw new SAXException(I18n.tr((String)"Closed classes while it was not open", (Object[])new Object[0]));
                }
                if (this.currentAccessClass != null) {
                    throw new SAXException(I18n.tr((String)"Closed classes element before all class elements were closed", (Object[])new Object[0]));
                }
                this.currentSection = Section.NONE;
            } else if ("class".equals(name)) {
                if (this.currentAccessClass == null) {
                    throw new SAXException(I18n.tr((String)"Closed class element while none was open", (Object[])new Object[0]));
                }
                this.currentAccessClass = this.currentAccessClass.parent;
            } else if ("basetags".equals(name)) {
                if (this.currentSection != Section.BASETAGS) {
                    throw new SAXException(I18n.tr((String)"Closed basetags while it was not open", (Object[])new Object[0]));
                }
                this.currentSection = Section.NONE;
            } else if ("implications".equals(name)) {
                if (this.currentSection != Section.IMPLICATIONS) {
                    throw new SAXException(I18n.tr((String)"Closed implications while it was not open", (Object[])new Object[0]));
                }
                this.implications.addAll(this.implicationReader.getImplications());
                this.implicationReader = null;
                this.currentSection = Section.NONE;
            }
        }

        private static enum Section {
            NONE,
            CLASSES,
            BASETAGS,
            IMPLICATIONS;

        }

        private static class AccessClass {
            final String name;
            final AccessClass parent;

            AccessClass(String name, AccessClass parent) {
                this.name = name;
                this.parent = parent;
            }

            List<String> getAncestorHierarchy() {
                List<Object> names = this.parent == null ? new LinkedList() : this.parent.getAncestorHierarchy();
                names.add(0, this.name);
                return names;
            }
        }
    }

    public static class AccessRulesetSyntaxException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public AccessRulesetSyntaxException(String message) {
            super(message);
        }

        public AccessRulesetSyntaxException(Throwable t) {
            super(t.toString());
        }
    }
}

