/*
 * Decompiled with CFR 0.152.
 */
package tec.units.indriya.internal.format;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.measure.format.UnitFormat;
import javax.measure.spi.UnitFormatService;
import tec.units.indriya.format.EBNFUnitFormat;
import tec.units.indriya.format.LocalUnitFormat;
import tec.units.indriya.format.SimpleUnitFormat;
import tec.uom.lib.common.function.IntPrioritySupplier;

public class DefaultUnitFormatService
implements UnitFormatService,
IntPrioritySupplier {
    static final int PRIO = 1000;
    private static final String DEFAULT_FORMAT = SimpleUnitFormat.Flavor.Default.name();
    private final Map<String, UnitFormat> formats = new HashMap<String, UnitFormat>();

    public DefaultUnitFormatService() {
        this.formats.put(DEFAULT_FORMAT, SimpleUnitFormat.getInstance());
        this.formats.put(SimpleUnitFormat.Flavor.ASCII.name(), SimpleUnitFormat.getInstance(SimpleUnitFormat.Flavor.ASCII));
        this.formats.put("EBNF", EBNFUnitFormat.getInstance());
        this.formats.put("Local", LocalUnitFormat.getInstance());
    }

    @Override
    public UnitFormat getUnitFormat(String formatName) {
        Objects.requireNonNull(formatName, "Format name required");
        return this.formats.get(formatName);
    }

    @Override
    public UnitFormat getUnitFormat() {
        return this.getUnitFormat(DEFAULT_FORMAT);
    }

    @Override
    public Set<String> getAvailableFormatNames() {
        return this.formats.keySet();
    }

    @Override
    public int getPriority() {
        return 1000;
    }
}

