/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opengis.referencing.cs.AxisDirection;

public final class DirectionAlongMeridian
implements Comparable,
Serializable {
    private static final long serialVersionUID = 1602711631943838328L;
    static final double EPS = 1.0E-10;
    private static final Pattern EPSG = Pattern.compile("(\\p{Graph}+)\\s+along\\s+([\\-\\p{Digit}\\.]+)\\s*(deg|\u00b0)\\s*(\\p{Graph}+)?", 2);
    private static final AxisDirection[] BASE_DIRECTIONS = new AxisDirection[]{AxisDirection.NORTH, AxisDirection.SOUTH, AxisDirection.EAST, AxisDirection.WEST};
    private volatile transient AxisDirection direction;
    public final AxisDirection baseDirection;
    public final double meridian;

    private DirectionAlongMeridian(AxisDirection baseDirection, double meridian) {
        this.baseDirection = baseDirection;
        this.meridian = meridian;
    }

    public static DirectionAlongMeridian parse(AxisDirection direction) {
        DirectionAlongMeridian candidate = DirectionAlongMeridian.parse(direction.name());
        if (candidate != null) {
            candidate.direction = direction;
        }
        return candidate;
    }

    public static DirectionAlongMeridian parse(String name) {
        double meridian;
        Matcher m = EPSG.matcher(name);
        if (!m.matches()) {
            return null;
        }
        String group = m.group(1);
        AxisDirection baseDirection = DirectionAlongMeridian.findDirection(BASE_DIRECTIONS, group);
        if (baseDirection == null || !AxisDirection.NORTH.equals(baseDirection.absolute())) {
            return null;
        }
        group = m.group(2);
        try {
            meridian = Double.parseDouble(group);
        }
        catch (NumberFormatException exception) {
            return null;
        }
        if (!(meridian >= -180.0) || !(meridian <= 180.0)) {
            return null;
        }
        group = m.group(4);
        if (group != null) {
            AxisDirection sign = DirectionAlongMeridian.findDirection(BASE_DIRECTIONS, group);
            if (sign == null || !AxisDirection.EAST.equals(sign.absolute())) {
                return null;
            }
            AxisDirection abs = sign.absolute();
            if (sign != abs) {
                meridian = -meridian;
            }
        }
        return new DirectionAlongMeridian(baseDirection, meridian);
    }

    private static AxisDirection findDirection(AxisDirection[] values, String direction) {
        for (int i = 0; i < values.length; ++i) {
            AxisDirection candidate = values[i];
            String name = candidate.name();
            if (direction.equalsIgnoreCase(name)) {
                return candidate;
            }
            if (direction.length() != 1) continue;
            if (candidate == AxisDirection.NORTH && direction.equals("N")) {
                return candidate;
            }
            if (candidate == AxisDirection.SOUTH && direction.equals("S")) {
                return candidate;
            }
            if (candidate == AxisDirection.WEST && direction.equals("W")) {
                return candidate;
            }
            if (candidate != AxisDirection.EAST || !direction.equals("E")) continue;
            return candidate;
        }
        return null;
    }

    static AxisDirection findDirection(String direction) {
        AxisDirection[] values = AxisDirection.values();
        AxisDirection candidate = DirectionAlongMeridian.findDirection(values, direction);
        if (candidate == null) {
            String modified = direction.replace('-', '_');
            if (!modified.equals(direction)) {
                direction = modified;
                candidate = DirectionAlongMeridian.findDirection(values, modified);
            }
            if (candidate == null && (modified = direction.replace(' ', '_')) != direction) {
                candidate = DirectionAlongMeridian.findDirection(values, modified);
            }
        }
        return candidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AxisDirection getDirection() {
        if (this.direction != null) {
            return this.direction;
        }
        String name = this.toString();
        Class<AxisDirection> clazz = AxisDirection.class;
        synchronized (AxisDirection.class) {
            this.direction = DirectionAlongMeridian.findDirection(name);
            if (this.direction == null) {
                this.direction = AxisDirection.valueOf(name);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.direction;
        }
    }

    public double getAngle(DirectionAlongMeridian other) {
        if (!this.baseDirection.equals(other.baseDirection)) {
            return Double.NaN;
        }
        double angle = this.meridian - other.meridian;
        if (angle < -180.0) {
            angle += 360.0;
        } else if (angle > 180.0) {
            angle -= 360.0;
        }
        if (!this.baseDirection.equals(this.baseDirection.absolute())) {
            angle = -angle;
        }
        return angle;
    }

    public int compareTo(Object object) {
        DirectionAlongMeridian that = (DirectionAlongMeridian)object;
        int c = this.baseDirection.compareTo(that.baseDirection);
        if (c != 0) {
            return c;
        }
        double angle = this.getAngle(that);
        if (angle < 0.0) {
            return 1;
        }
        if (angle > 0.0) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof DirectionAlongMeridian) {
            DirectionAlongMeridian that = (DirectionAlongMeridian)object;
            return this.baseDirection.equals(that.baseDirection) && Double.doubleToLongBits(this.meridian) == Double.doubleToLongBits(that.meridian);
        }
        return false;
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.meridian);
        return 0xDB662A78 ^ (int)code ^ (int)(code >> 32) + 37 * this.baseDirection.hashCode();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.baseDirection.name());
        DirectionAlongMeridian.toLowerCase(buffer, 0);
        buffer.append(" along ");
        double md = Math.abs(this.meridian);
        int mi = (int)md;
        if (md == (double)mi) {
            buffer.append(mi);
        } else {
            buffer.append(md);
        }
        buffer.append(" deg");
        if (md != 0.0 && mi != 180) {
            buffer.append(' ');
            int base = buffer.length();
            AxisDirection sign = this.meridian < 0.0 ? AxisDirection.WEST : AxisDirection.EAST;
            buffer.append(sign.name());
            DirectionAlongMeridian.toLowerCase(buffer, base);
        }
        String name = buffer.toString();
        assert (EPSG.matcher(name).matches()) : name;
        return name;
    }

    private static void toLowerCase(StringBuilder buffer, int base) {
        int i = buffer.length();
        while (--i > base) {
            buffer.setCharAt(i, Character.toLowerCase(buffer.charAt(i)));
        }
    }
}

