/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.catalog;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.io.catalog.CoverageSlice;
import org.geotools.coverage.io.catalog.DataStoreConfiguration;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.Repository;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.postgis.PostgisDatastoreWrapper;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;

public class CoverageSlicesCatalog {
    static final Logger LOGGER = Logging.getLogger(CoverageSlicesCatalog.class);
    private DataStore slicesIndexStore;
    private Set<String> typeNames = new HashSet<String>();
    public static final String IMAGE_INDEX_ATTR = "imageindex";
    private static final String HIDDEN_FOLDER = ".mapping";
    private final SoftValueHashMap<Integer, CoverageSlice> coverageSliceDescriptorsCache = new SoftValueHashMap(0);
    private boolean repositoryStore;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock(true);

    public CoverageSlicesCatalog(String database, File parentLocation) {
        this(database, parentLocation, null);
    }

    public CoverageSlicesCatalog(String database, File parentLocation, Repository repository) {
        this(new DataStoreConfiguration(DataStoreConfiguration.getDefaultParams(database, parentLocation)), repository);
    }

    public CoverageSlicesCatalog(DataStoreConfiguration datastoreConfig) {
        this(datastoreConfig, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoverageSlicesCatalog(DataStoreConfiguration datastoreConfig, Repository repository) {
        DataStoreFactorySpi spi = datastoreConfig.getDatastoreSpi();
        String storeName = datastoreConfig.getStoreName();
        boolean useRepository = storeName != null && repository != null;
        try {
            boolean isPostgis = Utils.isPostgisStore((DataStoreFactorySpi)spi);
            boolean isH2 = Utils.isH2Store((DataStoreFactorySpi)spi);
            Map<String, Serializable> params = datastoreConfig.getParams();
            if (isPostgis && params != null) {
                Utils.fixPostgisDBCreationParams(params);
            }
            if (useRepository) {
                NameImpl name = new NameImpl(storeName);
                this.slicesIndexStore = repository.dataStore(name);
                if (this.slicesIndexStore == null && storeName.indexOf(58) > -1) {
                    int idx = storeName.lastIndexOf(58);
                    name = new NameImpl(storeName.substring(0, idx), storeName.substring(idx + 1));
                    this.slicesIndexStore = repository.dataStore(name);
                }
                if (this.slicesIndexStore == null) {
                    throw new IllegalArgumentException("Could not locate store named " + storeName);
                }
                this.repositoryStore = true;
            } else {
                if (!isH2 && !isPostgis) {
                    throw new IllegalArgumentException("Low level index for multidim granules only supports H2 and PostGIS databases");
                }
                Utilities.ensureNonNull("params", params);
                this.slicesIndexStore = spi.createDataStore((Map)params);
            }
            boolean wrapDatastore = false;
            String parentLocation = (String)((Object)params.get("ParentLocation"));
            if (params.containsKey("WrapStore")) {
                wrapDatastore = (Boolean)params.get("WrapStore");
            }
            if (isPostgis && wrapDatastore) {
                this.slicesIndexStore = new PostgisDatastoreWrapper(this.slicesIndexStore, parentLocation, HIDDEN_FOLDER);
            }
            String typeName = null;
            String[] typeNamesValues = null;
            boolean scanForTypeNames = false;
            if (params.containsKey("TypeName") && (typeName = (String)((Object)params.get("TypeName"))) != null && typeName.contains(",")) {
                typeNamesValues = typeName.split(",");
            }
            if (params.containsKey("TypeNames")) {
                scanForTypeNames = Boolean.valueOf((String)((Object)params.get("TypeNames")));
            }
            if (typeNamesValues == null && scanForTypeNames) {
                typeNamesValues = this.slicesIndexStore.getTypeNames();
            }
            if (typeNamesValues != null) {
                for (String tn : typeNamesValues) {
                    this.typeNames.add(tn);
                }
            } else if (typeName != null) {
                this.addTypeName(typeName, false);
            }
            if (this.typeNames.size() > 0) {
                this.extractBasicProperties(this.typeNames.iterator().next());
            } else {
                this.extractBasicProperties(typeName);
            }
        }
        catch (Throwable e) {
            try {
                if (this.slicesIndexStore != null) {
                    this.slicesIndexStore.dispose();
                }
            }
            catch (Throwable e1) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e1.getLocalizedMessage(), e1);
                }
            }
            finally {
                this.slicesIndexStore = null;
            }
            throw new IllegalArgumentException(e);
        }
    }

    private void checkStore() throws IllegalStateException {
        if (this.slicesIndexStore == null) {
            throw new IllegalStateException("The index store has been disposed already.");
        }
    }

    private void extractBasicProperties(String typeName) throws IOException {
        if (typeName == null) {
            String[] typeNames = this.slicesIndexStore.getTypeNames();
            if (typeNames == null || typeNames.length <= 0) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("BBOXFilterExtractor::extractBasicProperties(): Problems when opening the index, no typenames for the schema are defined");
                }
                return;
            }
            if (typeName == null) {
                typeName = typeNames[0];
                this.addTypeName(typeName, false);
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("BBOXFilterExtractor::extractBasicProperties(): passed typename is null, using: " + typeName);
                }
            }
            for (String type : typeNames) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("BBOXFilterExtractor::extractBasicProperties(): Looking for type '" + typeName + "' in DataStore:getTypeNames(). Testing: '" + type + "'.");
                }
                if (!type.equalsIgnoreCase(typeName)) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("BBOXFilterExtractor::extractBasicProperties(): SUCCESS -> type '" + typeName + "' is equalsIgnoreCase() to '" + type + "'.");
                }
                typeName = type;
                this.addTypeName(typeName, false);
                break;
            }
        }
    }

    private void addTypeName(String typeName, boolean check) {
        if (check && this.typeNames.contains(typeName)) {
            throw new IllegalArgumentException("This typeName already exists: " + typeName);
        }
        this.typeNames.add(typeName);
    }

    public String[] getTypeNames() {
        if (this.typeNames != null && !this.typeNames.isEmpty()) {
            return this.typeNames.toArray(new String[0]);
        }
        return null;
    }

    public boolean hasTypeName(String typeName) {
        return this.typeNames != null && this.typeNames.contains(typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Lock l = this.rwLock.writeLock();
        try {
            l.lock();
            try {
                if (this.slicesIndexStore != null && !this.repositoryStore) {
                    this.slicesIndexStore.dispose();
                }
                this.slicesIndexStore = null;
            }
            catch (Throwable e) {
                try {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.slicesIndexStore = null;
                }
            }
        }
        finally {
            l.unlock();
        }
    }

    public void addGranule(String typeName, SimpleFeature granule, Transaction transaction) throws IOException {
        Utilities.ensureNonNull("typeName", typeName);
        Utilities.ensureNonNull("granule", granule);
        Utilities.ensureNonNull("transaction", transaction);
        DefaultFeatureCollection collection = new DefaultFeatureCollection();
        collection.add(granule);
        this.addGranules(typeName, collection, transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGranules(String typeName, SimpleFeatureCollection granules, Transaction transaction) throws IOException {
        Utilities.ensureNonNull("granuleMetadata", granules);
        Lock lock = this.rwLock.writeLock();
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureStore store = (SimpleFeatureStore)this.slicesIndexStore.getFeatureSource(typeName);
            store.setTransaction(transaction);
            store.addFeatures(granules);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<CoverageSlice> getGranules(Query q) throws IOException {
        Utilities.ensureNonNull("query", q);
        ArrayList<CoverageSlice> returnValue = new ArrayList<CoverageSlice>();
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            String typeName = q.getTypeName();
            SimpleFeatureSource featureSource = this.slicesIndexStore.getFeatureSource(typeName);
            if (featureSource == null) {
                throw new NullPointerException("The provided SimpleFeatureSource is null, it's impossible to create an index!");
            }
            Transaction tx = null;
            FeatureIterator it = null;
            try {
                SimpleFeatureCollection features;
                String[] properties;
                String[] requestedProperties;
                if (featureSource instanceof FeatureStore) {
                    tx = new DefaultTransaction("getGranulesTransaction" + System.nanoTime());
                    ((FeatureStore)((Object)featureSource)).setTransaction(tx);
                }
                boolean postRetypeRequired = (requestedProperties = q.getPropertyNames()) != Query.ALL_NAMES;
                SimpleFeatureType target = null;
                if (postRetypeRequired) {
                    ArrayList<String> propertiesList = new ArrayList<String>(Arrays.asList(requestedProperties));
                    if (!propertiesList.contains(IMAGE_INDEX_ATTR)) {
                        properties = new String[requestedProperties.length + 1];
                        System.arraycopy(requestedProperties, 0, properties, 0, requestedProperties.length);
                        properties[requestedProperties.length] = IMAGE_INDEX_ATTR;
                        q.setPropertyNames(properties);
                    }
                    target = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)featureSource.getSchema(), requestedProperties);
                }
                if ((features = featureSource.getFeatures(q)) == null) {
                    throw new NullPointerException("The provided SimpleFeatureCollection is null, it's impossible to create an index!");
                }
                it = features.features();
                if (it == null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("The provided SimpleFeatureCollection returned a null iterator, it's impossible to create an index!");
                    }
                    properties = Collections.emptyList();
                    return properties;
                }
                if (!it.hasNext()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("The provided SimpleFeatureCollection is empty, it's impossible to create an index!");
                    }
                    properties = Collections.emptyList();
                    return properties;
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Index Loaded");
                }
                while (it.hasNext()) {
                    CoverageSlice slice;
                    SimpleFeature feature;
                    SimpleFeature sf = feature = (SimpleFeature)it.next();
                    SoftValueHashMap<Integer, CoverageSlice> softValueHashMap = this.coverageSliceDescriptorsCache;
                    synchronized (softValueHashMap) {
                        Integer granuleIndex = (Integer)sf.getAttribute(IMAGE_INDEX_ATTR);
                        if (this.coverageSliceDescriptorsCache.containsKey(granuleIndex)) {
                            slice = this.coverageSliceDescriptorsCache.get(granuleIndex);
                        } else {
                            slice = new CoverageSlice(postRetypeRequired ? SimpleFeatureBuilder.retype(sf, target) : sf);
                            this.coverageSliceDescriptorsCache.put(granuleIndex, slice);
                        }
                    }
                    returnValue.add(slice);
                }
            }
            finally {
                if (it != null) {
                    it.close();
                }
                if (tx != null) {
                    tx.close();
                }
            }
            ArrayList<CoverageSlice> arrayList = returnValue;
            return arrayList;
        }
        catch (Throwable e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferencedEnvelope getBounds(String typeName) {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            ReferencedEnvelope referencedEnvelope = this.slicesIndexStore.getFeatureSource(typeName).getBounds();
            return referencedEnvelope;
        }
        catch (IOException e) {
            LOGGER.log(Level.FINER, e.getMessage(), e);
            ReferencedEnvelope referencedEnvelope = null;
            return referencedEnvelope;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createType(SimpleFeatureType featureType) throws IOException {
        Utilities.ensureNonNull("featureType", featureType);
        Lock lock = this.rwLock.writeLock();
        String typeName = null;
        try {
            Name name;
            SimpleFeatureType existing;
            block10: {
                lock.lock();
                this.checkStore();
                existing = null;
                name = featureType.getName();
                if (this instanceof WrappedCoverageSlicesCatalog) {
                    try {
                        existing = (SimpleFeatureType)this.slicesIndexStore.getSchema(name);
                    }
                    catch (IOException ioe) {
                        if (!LOGGER.isLoggable(Level.FINER)) break block10;
                        LOGGER.finer(ioe.getLocalizedMessage());
                    }
                }
            }
            if (existing == null) {
                this.slicesIndexStore.createSchema(featureType);
            } else if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("schema " + name + " already exists");
            }
            typeName = featureType.getTypeName();
            if (typeName != null) {
                this.addTypeName(typeName, true);
            }
            this.extractBasicProperties(typeName);
        }
        finally {
            lock.unlock();
        }
    }

    public void createType(String identification, String typeSpec) throws SchemaException, IOException {
        Utilities.ensureNonNull("typeSpec", typeSpec);
        Utilities.ensureNonNull("identification", identification);
        SimpleFeatureType featureType = DataUtilities.createType(identification, typeSpec);
        this.createType(featureType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleFeatureType getSchema(String typeName) throws IOException {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            if (typeName == null) {
                SimpleFeatureType simpleFeatureType = null;
                return simpleFeatureType;
            }
            SimpleFeatureType simpleFeatureType = this.slicesIndexStore.getSchema(typeName);
            return simpleFeatureType;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeAggregateFunction(Query query, FeatureCalc function) throws IOException {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureSource fs = this.slicesIndexStore.getFeatureSource(query.getTypeName());
            if (fs instanceof ContentFeatureSource) {
                ((ContentFeatureSource)fs).accepts(query, function, null);
            } else {
                SimpleFeatureCollection collection = fs.getFeatures(query);
                collection.accepts(function, null);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryCapabilities getQueryCapabilities(String typeName) {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            QueryCapabilities queryCapabilities = this.slicesIndexStore.getFeatureSource(typeName).getQueryCapabilities();
            return queryCapabilities;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Unable to collect QueryCapabilities", e);
            }
            QueryCapabilities queryCapabilities = null;
            return queryCapabilities;
        }
        finally {
            lock.unlock();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.slicesIndexStore != null) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("This granule catalog was not properly dispose as it still points to:" + this.slicesIndexStore.getInfo().toString());
            }
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGranules(String typeName, Filter filter, Transaction transaction) throws IOException {
        Utilities.ensureNonNull("typeName", typeName);
        Utilities.ensureNonNull("filter", filter);
        Utilities.ensureNonNull("transaction", transaction);
        Lock lock = this.rwLock.writeLock();
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureStore store = (SimpleFeatureStore)this.slicesIndexStore.getFeatureSource(typeName);
            store.setTransaction(transaction);
            store.removeFeatures(filter);
        }
        finally {
            lock.unlock();
        }
    }

    public void purge(Filter filter) throws IOException {
        DefaultTransaction transaction = null;
        try {
            transaction = new DefaultTransaction("CleanupTransaction" + System.nanoTime());
            for (String typeName : this.typeNames) {
                this.removeGranules(typeName, filter, transaction);
            }
            transaction.commit();
        }
        catch (Throwable e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Rollback");
            }
            if (transaction != null) {
                transaction.rollback();
            }
            throw new IOException(e);
        }
        finally {
            try {
                if (transaction != null) {
                    transaction.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public static class WrappedCoverageSlicesCatalog
    extends CoverageSlicesCatalog {
        private static final FilterFactory FF = FeatureUtilities.DEFAULT_FILTER_FACTORY;
        private Filter queryFilter;

        public WrappedCoverageSlicesCatalog(DataStoreConfiguration config, File file, Repository repository) throws IOException {
            super(config, repository);
            this.queryFilter = FF.equal(FF.property("location"), FF.literal(file.getCanonicalPath()), true);
        }

        @Override
        public List<CoverageSlice> getGranules(Query q) throws IOException {
            return super.getGranules(this.refineQuery(q));
        }

        @Override
        public void computeAggregateFunction(Query query, FeatureCalc function) throws IOException {
            super.computeAggregateFunction(this.refineQuery(query), function);
        }

        @Override
        public void removeGranules(String typeName, Filter filter, Transaction transaction) throws IOException {
            super.removeGranules(typeName, this.refineFilter(filter), transaction);
        }

        private Query refineQuery(Query q) {
            Query query = new Query(q);
            query.setFilter(this.refineFilter(q.getFilter()));
            return query;
        }

        private Filter refineFilter(Filter filter) {
            return filter != null ? FF.and(filter, this.queryFilter) : this.queryFilter;
        }
    }
}

