/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.stream.output.spi;

import it.geosolutions.imageio.stream.output.FileImageOutputStreamExtImpl;
import it.geosolutions.imageio.utilities.Utilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageOutputStreamSpi;
import javax.imageio.stream.ImageOutputStream;

public class StringImageOutputStreamSpi
extends ImageOutputStreamSpi {
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.stream.output");
    private static final String vendorName = "GeoSolutions";
    private static final String version = "1.0";
    private static final Class outputClass = String.class;

    public StringImageOutputStreamSpi() {
        super(vendorName, version, outputClass);
    }

    @Override
    public String getDescription(Locale locale) {
        return "Service provider for writing to a String";
    }

    @Override
    public ImageOutputStream createOutputStreamInstance(Object output, boolean useCache, File cacheDir) {
        block12: {
            URL tempURL;
            if (!(output instanceof String)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Provided input is not a String.");
                }
                return null;
            }
            String outputURL = (String)output;
            try {
                tempURL = new URL(outputURL);
            }
            catch (MalformedURLException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
                return null;
            }
            if (tempURL.getProtocol().compareToIgnoreCase("eraf") == 0) {
                try {
                    File tempFile = Utilities.urlToFile(tempURL);
                    return new FileImageOutputStreamExtImpl(tempFile);
                }
                catch (UnsupportedEncodingException e) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
                catch (FileNotFoundException e) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
                catch (IOException e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block12;
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
        }
        return null;
    }
}

