/*
 * Decompiled with CFR 0.152.
 */
package com.bric.plaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class FocusArrowListener
extends KeyAdapter {
    @Override
    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        int dx = 0;
        int dy = 0;
        if (code == 37) {
            dx = -1;
        } else if (code == 38) {
            dy = -1;
        } else if (code == 39) {
            dx = 1;
        } else if (code == 40) {
            dy = 1;
        }
        if ((dx != 0 || dy != 0) && FocusArrowListener.shiftFocus(dx, dy, (Component)e.getSource())) {
            e.consume();
        }
    }

    public static boolean shiftFocus(int dx, int dy, Component src) {
        if (dx == 0 && dy == 0) {
            throw new IllegalArgumentException("dx (" + dx + ") and (" + dy + ") cannot both be zero");
        }
        Set<Component> focusableComponents = FocusArrowListener.getFocusableComponents(src);
        int x = src.getWidth() / 2;
        int y = src.getHeight() / 2;
        Window window = SwingUtilities.getWindowAncestor(src);
        if (window == null) {
            return false;
        }
        Point p = SwingUtilities.convertPoint(src, x, y, window);
        Component comp = null;
        int windowWidth = window.getWidth();
        int windowHeight = window.getHeight();
        while (p.x > 0 && p.x < windowWidth && p.y > 0 && p.y < windowHeight && (comp == null || comp == src || comp instanceof JPanel)) {
            p.x += dx;
            p.y += dy;
            comp = SwingUtilities.getDeepestComponentAt(window, p.x, p.y);
            boolean canAcceptFocus = focusableComponents.contains(comp);
            if (comp == null || canAcceptFocus) continue;
            comp = null;
        }
        if (comp != null && comp != src && comp != window && !(comp instanceof JPanel)) {
            comp.requestFocus();
            return true;
        }
        return false;
    }

    public static Set<Component> getFocusableComponents(Component currentFocusOwner) {
        HashSet<Component> set = new HashSet<Component>();
        set.add(currentFocusOwner);
        Container rootAncestor = currentFocusOwner.getFocusCycleRootAncestor();
        Component comp = currentFocusOwner;
        while (!(rootAncestor == null || rootAncestor.isShowing() && rootAncestor.isFocusable() && rootAncestor.isEnabled())) {
            comp = rootAncestor;
            rootAncestor = comp.getFocusCycleRootAncestor();
        }
        if (rootAncestor != null) {
            FocusTraversalPolicy policy = rootAncestor.getFocusTraversalPolicy();
            Component toFocus = policy.getComponentAfter(rootAncestor, comp);
            while (toFocus != null && !set.contains(toFocus)) {
                set.add(toFocus);
                toFocus = policy.getComponentAfter(rootAncestor, toFocus);
            }
            toFocus = policy.getComponentBefore(rootAncestor, comp);
            while (toFocus != null && !set.contains(toFocus)) {
                set.add(toFocus);
                toFocus = policy.getComponentBefore(rootAncestor, toFocus);
            }
        }
        return set;
    }
}

