/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common.function.type4;

import java.util.Stack;
import org.apache.pdfbox.pdmodel.common.function.type4.ExecutionContext;
import org.apache.pdfbox.pdmodel.common.function.type4.Operator;

class ArithmeticOperators {
    ArithmeticOperators() {
    }

    static class Truncate
    implements Operator {
        Truncate() {
        }

        public void execute(ExecutionContext context) {
            Number num = context.popNumber();
            if (num instanceof Integer) {
                context.getStack().push(num.intValue());
            } else {
                context.getStack().push(Float.valueOf((int)num.floatValue()));
            }
        }
    }

    static class Sub
    implements Operator {
        Sub() {
        }

        public void execute(ExecutionContext context) {
            Stack<Object> stack = context.getStack();
            Number num2 = context.popNumber();
            Number num1 = context.popNumber();
            if (num1 instanceof Integer && num2 instanceof Integer) {
                long result = num1.longValue() - num2.longValue();
                if (result < Integer.MIN_VALUE || result > Integer.MAX_VALUE) {
                    stack.push(Float.valueOf(result));
                } else {
                    stack.push((int)result);
                }
            } else {
                float result = num1.floatValue() - num2.floatValue();
                stack.push(Float.valueOf(result));
            }
        }
    }

    static class Sqrt
    implements Operator {
        Sqrt() {
        }

        public void execute(ExecutionContext context) {
            float num = context.popReal();
            if (num < 0.0f) {
                throw new IllegalArgumentException("argument must be nonnegative");
            }
            context.getStack().push(Float.valueOf((float)Math.sqrt(num)));
        }
    }

    static class Sin
    implements Operator {
        Sin() {
        }

        public void execute(ExecutionContext context) {
            float angle = context.popReal();
            float sin = (float)Math.sin(Math.toRadians(angle));
            context.getStack().push(Float.valueOf(sin));
        }
    }

    static class Round
    implements Operator {
        Round() {
        }

        public void execute(ExecutionContext context) {
            Number num = context.popNumber();
            if (num instanceof Integer) {
                context.getStack().push(num.intValue());
            } else {
                context.getStack().push(Float.valueOf(Math.round(num.doubleValue())));
            }
        }
    }

    static class Neg
    implements Operator {
        Neg() {
        }

        public void execute(ExecutionContext context) {
            Number num = context.popNumber();
            if (num instanceof Integer) {
                int v = num.intValue();
                if (v == Integer.MIN_VALUE) {
                    context.getStack().push(Float.valueOf(-num.floatValue()));
                } else {
                    context.getStack().push(-num.intValue());
                }
            } else {
                context.getStack().push(Float.valueOf(-num.floatValue()));
            }
        }
    }

    static class Mul
    implements Operator {
        Mul() {
        }

        public void execute(ExecutionContext context) {
            Number num2 = context.popNumber();
            Number num1 = context.popNumber();
            if (num1 instanceof Integer && num2 instanceof Integer) {
                long result = num1.longValue() * num2.longValue();
                if (result >= Integer.MIN_VALUE && result <= Integer.MAX_VALUE) {
                    context.getStack().push((int)result);
                } else {
                    context.getStack().push(Float.valueOf(result));
                }
            } else {
                double result = num1.doubleValue() * num2.doubleValue();
                context.getStack().push(Float.valueOf((float)result));
            }
        }
    }

    static class Mod
    implements Operator {
        Mod() {
        }

        public void execute(ExecutionContext context) {
            int int2 = context.popInt();
            int int1 = context.popInt();
            context.getStack().push(int1 % int2);
        }
    }

    static class Log
    implements Operator {
        Log() {
        }

        public void execute(ExecutionContext context) {
            Number num = context.popNumber();
            context.getStack().push(Float.valueOf((float)Math.log10(num.doubleValue())));
        }
    }

    static class Ln
    implements Operator {
        Ln() {
        }

        public void execute(ExecutionContext context) {
            Number num = context.popNumber();
            context.getStack().push(Float.valueOf((float)Math.log(num.doubleValue())));
        }
    }

    static class IDiv
    implements Operator {
        IDiv() {
        }

        public void execute(ExecutionContext context) {
            int num2 = context.popInt();
            int num1 = context.popInt();
            context.getStack().push(num1 / num2);
        }
    }

    static class Floor
    implements Operator {
        Floor() {
        }

        public void execute(ExecutionContext context) {
            Number num = context.popNumber();
            if (num instanceof Integer) {
                context.getStack().push(num);
            } else {
                context.getStack().push(Float.valueOf((float)Math.floor(num.doubleValue())));
            }
        }
    }

    static class Exp
    implements Operator {
        Exp() {
        }

        public void execute(ExecutionContext context) {
            Number exp = context.popNumber();
            Number base = context.popNumber();
            double value = Math.pow(base.doubleValue(), exp.doubleValue());
            context.getStack().push(Float.valueOf((float)value));
        }
    }

    static class Div
    implements Operator {
        Div() {
        }

        public void execute(ExecutionContext context) {
            Number num2 = context.popNumber();
            Number num1 = context.popNumber();
            context.getStack().push(Float.valueOf(num1.floatValue() / num2.floatValue()));
        }
    }

    static class Cvr
    implements Operator {
        Cvr() {
        }

        public void execute(ExecutionContext context) {
            Number num = context.popNumber();
            context.getStack().push(Float.valueOf(num.floatValue()));
        }
    }

    static class Cvi
    implements Operator {
        Cvi() {
        }

        public void execute(ExecutionContext context) {
            Number num = context.popNumber();
            context.getStack().push(num.intValue());
        }
    }

    static class Cos
    implements Operator {
        Cos() {
        }

        public void execute(ExecutionContext context) {
            float angle = context.popReal();
            float cos = (float)Math.cos(Math.toRadians(angle));
            context.getStack().push(Float.valueOf(cos));
        }
    }

    static class Ceiling
    implements Operator {
        Ceiling() {
        }

        public void execute(ExecutionContext context) {
            Number num = context.popNumber();
            if (num instanceof Integer) {
                context.getStack().push(num);
            } else {
                context.getStack().push(Float.valueOf((float)Math.ceil(num.doubleValue())));
            }
        }
    }

    static class Atan
    implements Operator {
        Atan() {
        }

        public void execute(ExecutionContext context) {
            float den = context.popReal();
            float num = context.popReal();
            float atan = (float)Math.atan2(num, den);
            if ((atan = (float)Math.toDegrees(atan) % 360.0f) < 0.0f) {
                atan += 360.0f;
            }
            context.getStack().push(Float.valueOf(atan));
        }
    }

    static class Add
    implements Operator {
        Add() {
        }

        public void execute(ExecutionContext context) {
            Number num2 = context.popNumber();
            Number num1 = context.popNumber();
            if (num1 instanceof Integer && num2 instanceof Integer) {
                long sum = num1.longValue() + num2.longValue();
                if (sum < Integer.MIN_VALUE || sum > Integer.MAX_VALUE) {
                    context.getStack().push(Float.valueOf(sum));
                } else {
                    context.getStack().push((int)sum);
                }
            } else {
                float sum = num1.floatValue() + num2.floatValue();
                context.getStack().push(Float.valueOf(sum));
            }
        }
    }

    static class Abs
    implements Operator {
        Abs() {
        }

        public void execute(ExecutionContext context) {
            Number num = context.popNumber();
            if (num instanceof Integer) {
                context.getStack().push(Math.abs(num.intValue()));
            } else {
                context.getStack().push(Float.valueOf(Math.abs(num.floatValue())));
            }
        }
    }
}

