/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.curves;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.PolarCoor;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.tools.Geometry;

public final class CircleArcMaker {
    private CircleArcMaker() {
    }

    public static Collection<Command> doCircleArc(List<Node> selectedNodes, List<Way> selectedWays) {
        LatLon ll2;
        LinkedList<Command> cmds = new LinkedList<Command>();
        Node n1 = null;
        Node n2 = null;
        Node n3 = null;
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        if (selectedWays.size() > 1) {
            return cmds;
        }
        Way w = null;
        boolean nodesHaveBeenChoosen = false;
        if (selectedNodes.size() == 3) {
            Iterator<Node> nodeIter = selectedNodes.iterator();
            n1 = nodeIter.next();
            n2 = nodeIter.next();
            n3 = nodeIter.next();
            nodesHaveBeenChoosen = true;
        }
        if (!selectedWays.isEmpty()) {
            w = selectedWays.iterator().next();
            if (!nodesHaveBeenChoosen) {
                int nodeCount = w.getNodesCount();
                if (nodeCount < 3) {
                    return cmds;
                }
                n3 = w.getNode(nodeCount - 1);
                n2 = w.getNode(nodeCount - 2);
                n1 = w.getNode(nodeCount - 3);
                nodesHaveBeenChoosen = true;
            }
        }
        List<Node> anchorNodes = Arrays.asList(n1, n2, n3);
        if (!nodesHaveBeenChoosen || w != null && !w.getNodes().containsAll(anchorNodes)) {
            return cmds;
        }
        EastNorth p1 = n1.getEastNorth();
        EastNorth p2 = n2.getEastNorth();
        EastNorth p3 = n3.getEastNorth();
        if (p1.equals((Object)p2) || p1.equals((Object)p3) || p2.equals((Object)p3)) {
            return cmds;
        }
        EastNorth center = Geometry.getCenter(anchorNodes);
        if (center == null) {
            return cmds;
        }
        double radius = center.distance(p1);
        LatLon ll1 = ProjectionRegistry.getProjection().eastNorth2latlon(p1);
        double radiusInMeters = ll1.greatCircleDistance(ll2 = ProjectionRegistry.getProjection().eastNorth2latlon(center));
        int numberOfNodesInCircle = (int)Math.ceil(6.0 * Math.pow(radiusInMeters, 0.5));
        if (numberOfNodesInCircle < 6) {
            numberOfNodesInCircle = 6;
        } else if (numberOfNodesInCircle % 2 != 0) {
            ++numberOfNodesInCircle;
        }
        double maxAngle = 360.0 / (double)numberOfNodesInCircle;
        if (w == null) {
            w = new Way();
            w.setNodes(anchorNodes);
            cmds.add((Command)new AddCommand(ds, (OsmPrimitive)w));
        }
        ArrayList nodes = new ArrayList(w.getNodes());
        if (!selectedWays.isEmpty()) {
            List<Node> consideredNodes = Arrays.asList(n1, n2, n3);
            Collections.sort(consideredNodes, (o1, o2) -> nodes.indexOf(o1) - nodes.indexOf(o2));
            n1 = consideredNodes.get(0);
            n3 = consideredNodes.get(2);
        }
        HashSet<Node> fixNodes = new HashSet<Node>(anchorNodes);
        if (!selectedWays.isEmpty()) {
            nodes.stream().filter(n -> n.getParentWays().size() > 1).forEach(fixNodes::add);
        }
        boolean needsUndo = false;
        if (!cmds.isEmpty()) {
            UndoRedoHandler.getInstance().add((Command)new SequenceCommand("add nodes", cmds));
            needsUndo = true;
        }
        int pos1 = nodes.indexOf(n1);
        int pos3 = nodes.indexOf(n3);
        ArrayList<Node> toModify = new ArrayList<Node>(nodes.subList(pos1, pos3 + 1));
        cmds.addAll(CircleArcMaker.worker(toModify, fixNodes, center, radius, maxAngle));
        if (toModify.size() > pos3 + 1 - pos1) {
            ArrayList changed = new ArrayList();
            changed.addAll(nodes.subList(0, pos1));
            changed.addAll(toModify);
            changed.addAll(nodes.subList(pos3 + 1, nodes.size()));
            Way wNew = new Way(w);
            wNew.setNodes(changed);
            cmds.add((Command)new ChangeCommand((OsmPrimitive)w, (OsmPrimitive)wNew));
        }
        if (needsUndo) {
            UndoRedoHandler.getInstance().undo(1);
        }
        return cmds;
    }

    private static List<Command> worker(List<Node> nodes, Set<Node> fixNodes, EastNorth center, double radius, double maxAngle) {
        int startPosition;
        LinkedList<Command> cmds = new LinkedList<Command>();
        int nodeCount = nodes.size();
        ArrayList<Node> cwTest = new ArrayList<Node>(nodes);
        if (cwTest.get(0) != cwTest.get(cwTest.size() - 1)) {
            cwTest.add((Node)cwTest.get(0));
        }
        boolean clockWise = Geometry.isClockwise(cwTest);
        double maxStep = Math.PI * 2 / (360.0 / maxAngle);
        for (startPosition = 0; startPosition < nodeCount && !fixNodes.contains(nodes.get(startPosition)); ++startPosition) {
        }
        int i = startPosition;
        while (i < nodeCount) {
            int j;
            for (j = i + 1; j < nodeCount && !fixNodes.contains(nodes.get(j)); ++j) {
            }
            Node first = nodes.get(i);
            PolarCoor pcFirst = new PolarCoor(radius, PolarCoor.computeAngle((EastNorth)first.getEastNorth(), (EastNorth)center), center);
            CircleArcMaker.addMoveCommandIfNeeded(first, pcFirst, cmds);
            if (j < nodeCount) {
                PolarCoor p;
                int k;
                PolarCoor pcLast = new PolarCoor(nodes.get(j).getEastNorth(), center);
                double delta = pcLast.angle - pcFirst.angle;
                if (!clockWise && delta < 0.0) {
                    delta += Math.PI * 2;
                } else if (clockWise && delta > 0.0) {
                    delta -= Math.PI * 2;
                }
                int numToAdd = Math.max((int)Math.ceil(Math.abs(delta / maxStep)), j - i) - (j - i);
                double step = delta / (double)(numToAdd + j - i);
                for (k = i + 1; k < j; ++k) {
                    p = new PolarCoor(radius, pcFirst.angle + (double)(k - i) * step, center);
                    CircleArcMaker.addMoveCommandIfNeeded(nodes.get(k), p, cmds);
                }
                for (k = j; k < j + numToAdd; ++k) {
                    p = new PolarCoor(radius, pcFirst.angle + (double)(k - i) * step, center);
                    Node nNew = new Node(p.toEastNorth());
                    nodes.add(k, nNew);
                    cmds.add((Command)new AddCommand(nodes.get(0).getDataSet(), (OsmPrimitive)nNew));
                }
                j += numToAdd;
                nodeCount += numToAdd;
            }
            i = j;
        }
        return cmds;
    }

    private static void addMoveCommandIfNeeded(Node n, PolarCoor coor, Collection<Command> cmds) {
        EastNorth en = coor.toEastNorth();
        double deltaEast = en.east() - n.getEastNorth().east();
        double deltaNorth = en.north() - n.getEastNorth().north();
        if (Math.abs(deltaEast) > 1.0E-7 || Math.abs(deltaNorth) > 1.0E-7) {
            cmds.add((Command)new MoveCommand((OsmPrimitive)n, deltaEast, deltaNorth));
        }
    }
}

