/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.importvec;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.importvec.Settings;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ImportDialog
extends ExtendedDialog {
    private JFormattedTextField tsdiv = new JFormattedTextField(NumberFormat.getInstance());
    private JFormattedTextField tsnum = new JFormattedTextField(NumberFormat.getInstance());
    private JFormattedTextField tsteps = new JFormattedTextField(NumberFormat.getIntegerInstance());

    public ImportDialog() {
        super((Component)MainApplication.getMainFrame(), I18n.tr((String)"Import vector graphics", (Object[])new Object[0]), new String[]{I18n.tr((String)"OK", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])}, true);
        this.contentInsets = new Insets(15, 15, 5, 15);
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(I18n.tr((String)"Scale:", (Object[])new Object[0])), GBC.eol().fill(2));
        JPanel pscale = new JPanel(new GridBagLayout());
        pscale.add((Component)this.tsdiv, GBC.std().fill(2));
        pscale.add((Component)new JLabel(I18n.tr((String)"unit(s) = ", (Object[])new Object[0])), GBC.std().insets(10, 0, 0, 0));
        pscale.add((Component)this.tsnum, GBC.std().fill(2));
        pscale.add((Component)new JLabel(I18n.tr((String)"m", (Object[])new Object[0])), GBC.std().insets(10, 0, 0, 0));
        panel.add((Component)pscale, GBC.eop().fill(2));
        JLabel label = new JLabel("Curve steps:");
        panel.add((Component)label, GBC.std());
        label.setLabelFor(this.tsteps);
        panel.add((Component)this.tsteps, GBC.eol().fill(2));
        this.tsnum.setValue(Settings.getScaleNumerator());
        this.tsdiv.setValue(Settings.getScaleDivisor());
        this.tsteps.setValue(Settings.getCurveSteps());
        this.setContent(panel);
        this.setupDialog();
        this.setVisible(true);
    }

    public double getScaleNumerator() {
        try {
            return NumberFormat.getInstance().parse(this.tsnum.getText()).doubleValue();
        }
        catch (ParseException e) {
            return 1.0;
        }
    }

    public double getScaleDivisor() {
        try {
            double result = NumberFormat.getInstance().parse(this.tsdiv.getText()).doubleValue();
            if (result <= 1.0E-4) {
                return 1.0;
            }
            return result;
        }
        catch (ParseException e) {
            return 1.0;
        }
    }

    public int getCurveSteps() {
        try {
            int result = NumberFormat.getIntegerInstance().parse(this.tsteps.getText()).intValue();
            if (result < 1) {
                return 1;
            }
            return result;
        }
        catch (ParseException e) {
            return 4;
        }
    }

    public void saveSettings() {
        Settings.setScaleNumerator(this.getScaleNumerator());
        Settings.setScaleDivisor(this.getScaleDivisor());
        Settings.setCurveSteps(this.getCurveSteps());
    }
}

