/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses;

import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.fixAddresses.OsmUtils;
import org.openstreetmap.josm.plugins.fixAddresses.StringUtils;
import org.openstreetmap.josm.plugins.fixAddresses.TagConstants;

public final class TagUtils {
    private TagUtils() {
    }

    public static boolean hasTag(OsmPrimitive osm, String tag) {
        return osm != null && !StringUtils.isNullOrEmpty(osm.get(tag));
    }

    public static boolean isAddress(OsmPrimitive osmObject) {
        return TagUtils.hasAddrCityTag(osmObject) || TagUtils.hasAddrCountryTag(osmObject) || TagUtils.hasAddrHousenumberTag(osmObject) || TagUtils.hasAddrPostcodeTag(osmObject) || TagUtils.hasAddrStateTag(osmObject) || TagUtils.hasAddrStreetTag(osmObject);
    }

    public static boolean hasParkingTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("parking") : false;
    }

    public static String getParkingValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("parking") : null;
    }

    public static boolean hasShopTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("shop") : false;
    }

    public static String getShopValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("shop") : null;
    }

    public static boolean hasCraftTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("craft") : false;
    }

    public static String getCraftValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("craft") : null;
    }

    public static boolean hasSurfaceTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("surface") : false;
    }

    public static String getSurfaceValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("surface") : null;
    }

    public static boolean hasCuisineTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("cuisine") : false;
    }

    public static String getCuisineValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("cuisine") : null;
    }

    public static boolean hasWoodTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("wood") : false;
    }

    public static String getWoodValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("wood") : null;
    }

    public static boolean hasFootTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("foot") : false;
    }

    public static String getFootValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("foot") : null;
    }

    public static boolean hasNameDeTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("name:de") : false;
    }

    public static String getNameDeValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("name:de") : null;
    }

    public static boolean hasNatRefTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("nat_ref") : false;
    }

    public static String getNatRefValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("nat_ref") : null;
    }

    public static boolean hasNoteDeTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("note:de") : false;
    }

    public static String getNoteDeValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("note:de") : null;
    }

    public static boolean hasAddrStreetTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("addr:street") : false;
    }

    public static String getAddrStreetValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("addr:street") : null;
    }

    public static boolean hasTypeTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("type") : false;
    }

    public static String getTypeValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("type") : null;
    }

    public static boolean hasAddrCityTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("addr:city") : false;
    }

    public static String getAddrCityValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("addr:city") : null;
    }

    public static boolean hasBoundaryTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("boundary") : false;
    }

    public static String getBoundaryValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("boundary") : null;
    }

    public static boolean hasSmoothnessTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("smoothness") : false;
    }

    public static String getSmoothnessValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("smoothness") : null;
    }

    public static boolean hasOpeningHoursTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("opening_hours") : false;
    }

    public static String getOpeningHoursValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("opening_hours") : null;
    }

    public static boolean hasBicycleTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("bicycle") : false;
    }

    public static String getBicycleValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("bicycle") : null;
    }

    public static boolean hasReligionTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("religion") : false;
    }

    public static String getReligionValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("religion") : null;
    }

    public static boolean hasBarrierTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("barrier") : false;
    }

    public static String getBarrierValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("barrier") : null;
    }

    public static boolean hasPowerTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("power") : false;
    }

    public static String getPowerValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("power") : null;
    }

    public static boolean hasLanduseTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("landuse") : false;
    }

    public static String getLanduseValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("landuse") : null;
    }

    public static boolean hasFireplaceTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("fireplace") : false;
    }

    public static String getFireplaceValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("fireplace") : null;
    }

    public static boolean hasIntRefTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("int_ref") : false;
    }

    public static String getIntRefValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("int_ref") : null;
    }

    public static boolean hasWhitewaterSectionGradeTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("whitewater:section_grade") : false;
    }

    public static String getWhitewaterSectionGradeValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("whitewater:section_grade") : null;
    }

    public static boolean hasDenominationTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("denomination") : false;
    }

    public static String getDenominationValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("denomination") : null;
    }

    public static boolean hasAddrPostcodeTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("addr:postcode") : false;
    }

    public static String getAddrPostcodeValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("addr:postcode") : null;
    }

    public static boolean hasWiresTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("wires") : false;
    }

    public static String getWiresValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("wires") : null;
    }

    public static boolean hasLocRefTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("loc_ref") : false;
    }

    public static String getLocRefValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("loc_ref") : null;
    }

    public static boolean hasWidthTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("width") : false;
    }

    public static String getWidthValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("width") : null;
    }

    public static boolean hasTourismTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("tourism") : false;
    }

    public static String getTourismValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("tourism") : null;
    }

    public static boolean hasLeisureTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("leisure") : false;
    }

    public static String getLeisureValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("leisure") : null;
    }

    public static boolean hasElectrifiedTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("electrified") : false;
    }

    public static String getElectrifiedValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("electrified") : null;
    }

    public static boolean hasJunctionTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("junction") : false;
    }

    public static String getJunctionValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("junction") : null;
    }

    public static boolean hasRailwayTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("railway") : false;
    }

    public static String getRailwayValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("railway") : null;
    }

    public static boolean hasVoltageTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("voltage") : false;
    }

    public static String getVoltageValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("voltage") : null;
    }

    public static boolean hasBridgeTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("bridge") : false;
    }

    public static String getBridgeValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("bridge") : null;
    }

    public static boolean hasMotorVehicleTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("motor_vehicle") : false;
    }

    public static String getMotorVehicleValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("motor_vehicle") : null;
    }

    public static boolean hasCommentTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("comment") : false;
    }

    public static String getCommentValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("comment") : null;
    }

    public static boolean hasMaxspeedTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("maxspeed") : false;
    }

    public static String getMaxspeedValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("maxspeed") : null;
    }

    public static boolean hasNaturalTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("natural") : false;
    }

    public static String getNaturalValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("natural") : null;
    }

    public static boolean hasSacScaleTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("sac_scale") : false;
    }

    public static String getSacScaleValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("sac_scale") : null;
    }

    public static boolean hasTunnelTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("tunnel") : false;
    }

    public static String getTunnelValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("tunnel") : null;
    }

    public static boolean hasWaterwayTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("waterway") : false;
    }

    public static String getWaterwayValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("waterway") : null;
    }

    public static boolean hasTrailVisibilityTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("trail_visibility") : false;
    }

    public static String getTrailVisibilityValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("trail_visibility") : null;
    }

    public static boolean hasHighwayTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("highway") : false;
    }

    public static String getHighwayValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("highway") : null;
    }

    public static boolean hasVehicleTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("vehicle") : false;
    }

    public static String getVehicleValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("vehicle") : null;
    }

    public static boolean hasHorseTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("horse") : false;
    }

    public static String getHorseValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("horse") : null;
    }

    public static boolean hasGoodsTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("goods") : false;
    }

    public static String getGoodsValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("goods") : null;
    }

    public static boolean hasFrequencyTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("frequency") : false;
    }

    public static String getFrequencyValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("frequency") : null;
    }

    public static boolean hasManMadeTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("man_made") : false;
    }

    public static String getManMadeValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("man_made") : null;
    }

    public static boolean hasAddrHousenumberTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("addr:housenumber") : false;
    }

    public static String getAddrHousenumberValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("addr:housenumber") : null;
    }

    public static boolean hasAddrHousenameTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("addr:housename") : false;
    }

    public static String getAddrHousenameValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("addr:housename") : null;
    }

    public static boolean hasAreaTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("area") : false;
    }

    public static String getAreaValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("area") : null;
    }

    public static boolean hasBuildingLevelsTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("building:levels") : false;
    }

    public static String getBuildingLevelsValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("building:levels") : null;
    }

    public static boolean hasWheelchairTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("wheelchair") : false;
    }

    public static String getWheelchairValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("wheelchair") : null;
    }

    public static boolean hasNameTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("name") : false;
    }

    public static String getNameValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("name") : null;
    }

    public static boolean hasOnewayTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("oneway") : false;
    }

    public static String getOnewayValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("oneway") : null;
    }

    public static boolean hasFIXMETag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("FIXME") : false;
    }

    public static String getFIXMEValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("FIXME") : null;
    }

    public static boolean hasCapacityTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("capacity") : false;
    }

    public static String getCapacityValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("capacity") : null;
    }

    public static boolean hasMotorcycleTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("motorcycle") : false;
    }

    public static String getMotorcycleValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("motorcycle") : null;
    }

    public static boolean hasHgvTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("hgv") : false;
    }

    public static String getHgvValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("hgv") : null;
    }

    public static boolean hasConstructionTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("construction") : false;
    }

    public static String getConstructionValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("construction") : null;
    }

    public static boolean hasAddrStateTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("addr:state") : false;
    }

    public static String getAddrStateValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("addr:state") : null;
    }

    public static boolean hasLanesTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("lanes") : false;
    }

    public static String getLanesValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("lanes") : null;
    }

    public static boolean hasNoteTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("note") : false;
    }

    public static String getNoteValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("note") : null;
    }

    public static boolean hasLitTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("lit") : false;
    }

    public static String getLitValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("lit") : null;
    }

    public static boolean hasBuildingTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("building") : false;
    }

    public static String getBuildingValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("building") : null;
    }

    public static boolean hasSegregatedTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("segregated") : false;
    }

    public static String getSegregatedValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("segregated") : null;
    }

    public static boolean hasAddrInclusionTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("addr:inclusion") : false;
    }

    public static String getAddrInclusionValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("addr:inclusion") : null;
    }

    public static boolean hasLayerTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("layer") : false;
    }

    public static String getLayerValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("layer") : null;
    }

    public static boolean hasSportTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("sport") : false;
    }

    public static String getSportValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("sport") : null;
    }

    public static boolean hasAddrInterpolationTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("addr:interpolation") : false;
    }

    public static String getAddrInterpolationValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("addr:interpolation") : null;
    }

    public static boolean hasCuttingTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("cutting") : false;
    }

    public static String getCuttingValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("cutting") : null;
    }

    public static boolean hasAmenityTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("amenity") : false;
    }

    public static String getAmenityValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("amenity") : null;
    }

    public static boolean hasAccessTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("access") : false;
    }

    public static String getAccessValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("access") : null;
    }

    public static boolean hasAgriculturalTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("agricultural") : false;
    }

    public static String getAgriculturalValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("agricultural") : null;
    }

    public static boolean hasCapacityDisabledTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("capacity:disabled") : false;
    }

    public static String getCapacityDisabledValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("capacity:disabled") : null;
    }

    public static boolean hasOperatorTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("operator") : false;
    }

    public static String getOperatorValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("operator") : null;
    }

    public static boolean hasRefTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("ref") : false;
    }

    public static String getRefValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("ref") : null;
    }

    public static boolean hasNoexitTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("noexit") : false;
    }

    public static String getNoexitValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("noexit") : null;
    }

    public static boolean hasAdminLevelTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("admin_level") : false;
    }

    public static String getAdminLevelValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("admin_level") : null;
    }

    public static boolean hasSourceTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("source") : false;
    }

    public static String getSourceValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("source") : null;
    }

    public static boolean hasTracktypeTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("tracktype") : false;
    }

    public static String getTracktypeValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("tracktype") : null;
    }

    public static boolean hasAddrCountryTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("addr:country") : false;
    }

    public static String getAddrCountryValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("addr:country") : null;
    }

    public static boolean hasRouteTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("route") : false;
    }

    public static String getRouteValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("route") : null;
    }

    public static boolean hasCablesTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("cables") : false;
    }

    public static String getCablesValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("cables") : null;
    }

    public static boolean hasServiceTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("service") : false;
    }

    public static String getServiceValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("service") : null;
    }

    public static boolean hasMotorcarTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("motorcar") : false;
    }

    public static String getMotorcarValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("motorcar") : null;
    }

    public static boolean hasWhitewaterTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("whitewater") : false;
    }

    public static String getWhitewaterValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("whitewater") : null;
    }

    public static boolean hasEmbankmentTag(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.hasKey("embankment") : false;
    }

    public static String getEmbankmentValue(OsmPrimitive osmPrimitive) {
        return osmPrimitive != null ? osmPrimitive.get("embankment") : null;
    }

    public static boolean isStreetSupportingHousenumbers(Way w) {
        if (w == null) {
            return false;
        }
        return TagUtils.hasHighwayTag((OsmPrimitive)w);
    }

    public static boolean isAssociatedStreetRelation(Relation rel) {
        return rel != null && rel.hasKey("type") && "associatedStreet".equals(rel.get("type"));
    }

    public static boolean isStreetMember(RelationMember relMember) {
        return relMember != null && "street".equals(relMember.getRole());
    }

    public static boolean isHouseMember(RelationMember relMember) {
        return relMember != null && "street".equals(relMember.getRole());
    }

    public static boolean isStateRequired() {
        String loc = OsmUtils.getLocale();
        for (int i = 0; i < TagConstants.COUNTRIES_REQUIRE_STATE.length; ++i) {
            if (!TagConstants.COUNTRIES_REQUIRE_STATE[i].equals(loc)) continue;
            return true;
        }
        return false;
    }
}

