/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.geotools.metadata.i18n.Errors;
import org.opengis.util.Cloneable;

public class CheckedHashMap<K, V>
extends LinkedHashMap<K, V>
implements Cloneable {
    private static final long serialVersionUID = -7777695267921872849L;
    private final Class<K> keyType;
    private final Class<V> valueType;

    public CheckedHashMap(Class<K> keyType, Class<V> valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
        CheckedHashMap.ensureNonNull(keyType, "keyType");
        CheckedHashMap.ensureNonNull(valueType, "valueType");
    }

    private static void ensureNonNull(Class<?> type, String name) {
        if (type == null) {
            throw new NullPointerException(Errors.format(143, name));
        }
    }

    private static <E> void ensureValidType(E element, Class<E> type) throws IllegalArgumentException {
        if (element != null && !type.isInstance(element)) {
            throw new IllegalArgumentException(Errors.format(61, element.getClass(), type));
        }
    }

    protected void checkWritePermission() throws UnsupportedOperationException {
        assert (Thread.holdsLock(this.getLock()));
    }

    protected Object getLock() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.getLock();
        synchronized (object) {
            return super.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return super.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        Object object = this.getLock();
        synchronized (object) {
            return super.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        Object object = this.getLock();
        synchronized (object) {
            return super.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        Object object = this.getLock();
        synchronized (object) {
            return super.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) throws IllegalArgumentException, UnsupportedOperationException {
        CheckedHashMap.ensureValidType(key, this.keyType);
        CheckedHashMap.ensureValidType(value, this.valueType);
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) throws UnsupportedOperationException {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            CheckedHashMap.ensureValidType(entry.getKey(), this.keyType);
            CheckedHashMap.ensureValidType(entry.getValue(), this.valueType);
        }
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            super.putAll(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) throws UnsupportedOperationException {
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            return super.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws UnsupportedOperationException {
        Object object = this.getLock();
        synchronized (object) {
            this.checkWritePermission();
            super.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Object object = this.getLock();
        synchronized (object) {
            return super.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        Object object = this.getLock();
        synchronized (object) {
            return super.equals(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return super.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckedHashMap<K, V> clone() {
        Object object = this.getLock();
        synchronized (object) {
            return (CheckedHashMap)super.clone();
        }
    }
}

