/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.io.Serializable;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.metadata.i18n.Errors;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.util.TableWriter;
import org.geotools.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class MappedPosition
implements Serializable {
    private static final long serialVersionUID = 3262172371858749543L;
    private final DirectPosition source;
    private final DirectPosition target;
    private double accuracy = Double.NaN;
    private String comments;

    public MappedPosition(int dimension) {
        if (dimension == 2) {
            this.source = new DirectPosition2D();
            this.target = new DirectPosition2D();
        } else {
            this.source = new GeneralDirectPosition(dimension);
            this.target = new GeneralDirectPosition(dimension);
        }
    }

    public MappedPosition(DirectPosition source, DirectPosition target) {
        MappedPosition.ensureNonNull("source", source);
        MappedPosition.ensureNonNull("target", target);
        this.source = source;
        this.target = target;
    }

    private static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.format(143, name));
        }
    }

    public DirectPosition getSource() {
        return this.source;
    }

    public void setSource(DirectPosition point) {
        if (this.source instanceof DirectPosition2D) {
            ((DirectPosition2D)this.source).setLocation(point);
        } else {
            ((GeneralDirectPosition)this.source).setLocation(point);
        }
    }

    public DirectPosition getTarget() {
        return this.target;
    }

    public void setTarget(DirectPosition point) {
        if (this.source instanceof DirectPosition2D) {
            ((DirectPosition2D)this.target).setLocation(point);
        } else {
            ((GeneralDirectPosition)this.target).setLocation(point);
        }
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(double accuracy) {
        this.accuracy = accuracy;
    }

    final double getError(MathTransform transform, DirectPosition buffer) throws TransformException {
        return MappedPosition.distance(transform.transform(this.source, buffer), this.target);
    }

    private static double distance(DirectPosition source, DirectPosition target) {
        int dimension;
        int otherDim = source.getDimension();
        if (otherDim != (dimension = target.getDimension())) {
            throw new MismatchedDimensionException(Errors.format(93, otherDim, dimension));
        }
        double sum = 0.0;
        for (int i = 0; i < dimension; ++i) {
            double delta = source.getOrdinate(i) - target.getOrdinate(i);
            sum += delta * delta;
        }
        return Math.sqrt(sum / (double)dimension);
    }

    public int hashCode() {
        return this.source.hashCode() + 37 * this.target.hashCode();
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            MappedPosition that = (MappedPosition)object;
            return Utilities.equals(this.source, that.source) && Utilities.equals(this.target, that.target) && Utilities.equals(this.comments, that.comments) && Utilities.equals(this.accuracy, that.accuracy);
        }
        return false;
    }

    public String toString() {
        int i;
        TableWriter table = new TableWriter(null, " ");
        table.write(Vocabulary.format(201));
        table.write(58);
        int dimension = this.source.getDimension();
        for (i = 0; i < dimension; ++i) {
            table.nextColumn();
            table.write(String.valueOf(this.source.getOrdinate(i)));
        }
        table.nextLine();
        table.write(Vocabulary.format(212));
        table.write(58);
        dimension = this.target.getDimension();
        for (i = 0; i < dimension; ++i) {
            table.nextColumn();
            table.write(String.valueOf(this.target.getOrdinate(i)));
        }
        return table.toString();
    }
}

