/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Objects;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.NativeFilter;

public final class NativeFilterImpl
implements NativeFilter {
    private final String nativeFilter;

    public NativeFilterImpl(String nativeFilter) {
        this.nativeFilter = nativeFilter;
    }

    @Override
    public String getNative() {
        return this.nativeFilter;
    }

    @Override
    public boolean evaluate(Object object) {
        throw new RuntimeException(String.format("Native filter '%s' can be executed in memory.", this.nativeFilter));
    }

    @Override
    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit(this, extraData);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        NativeFilterImpl that = (NativeFilterImpl)other;
        return Objects.equals(this.nativeFilter, that.nativeFilter);
    }

    public int hashCode() {
        return Objects.hash(this.nativeFilter);
    }

    public String toString() {
        return "[ " + this.nativeFilter + " ]";
    }
}

