/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io.footprint;

import java.io.IOException;
import org.geotools.coverage.grid.io.footprint.FootprintGeometryProvider;
import org.geotools.coverage.grid.io.footprint.FootprintInsetPolicy;
import org.geotools.coverage.grid.io.footprint.MultiLevelROI;
import org.geotools.coverage.grid.io.footprint.MultiLevelROIGeometry;
import org.geotools.coverage.grid.io.footprint.MultiLevelROIProvider;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;

public class MultiLevelROIGeometryProvider
implements MultiLevelROIProvider {
    private final FootprintGeometryProvider geometryProvider;
    private final double inset;
    private final FootprintInsetPolicy insetPolicy;
    private final Geometry defaultGranuleBounds;

    public MultiLevelROIGeometryProvider(FootprintGeometryProvider geometryProvider, double inset, FootprintInsetPolicy insetPolicy, Geometry defaultGranuleBounds) {
        this.geometryProvider = geometryProvider;
        this.inset = inset;
        this.insetPolicy = insetPolicy;
        this.defaultGranuleBounds = defaultGranuleBounds;
    }

    public MultiLevelROIGeometryProvider(FootprintGeometryProvider geometryProvider, double inset, FootprintInsetPolicy insetPolicy) {
        this(geometryProvider, inset, insetPolicy, null);
    }

    @Override
    public MultiLevelROI getMultiScaleROI(SimpleFeature sf) throws IOException {
        Geometry footprint = this.geometryProvider.getFootprint(sf);
        if (footprint == null) {
            return null;
        }
        Geometry granuleBounds = this.defaultGranuleBounds != null ? this.defaultGranuleBounds : (Geometry)sf.getDefaultGeometry();
        return new MultiLevelROIGeometry(footprint, granuleBounds, this.inset, this.insetPolicy);
    }

    @Override
    public void dispose() {
        this.geometryProvider.dispose();
    }
}

