/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.io.session;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.io.session.AbstractSessionExporter;
import org.openstreetmap.josm.io.session.SessionWriter;
import org.openstreetmap.josm.plugins.piclayer.layer.PicLayerAbstract;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.Logging;
import org.w3c.dom.Element;

public abstract class PicLayerAbstractSessionExporter<T extends PicLayerAbstract>
extends AbstractSessionExporter<T> {
    public PicLayerAbstractSessionExporter(T layer) {
        super(layer);
    }

    public Component getExportPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        this.export.setSelected(true);
        JLabel lbl = new JLabel(((PicLayerAbstract)this.layer).getName(), ((PicLayerAbstract)this.layer).getIcon(), 2);
        lbl.setToolTipText(((PicLayerAbstract)this.layer).getToolTipText());
        lbl.setLabelFor(this.export);
        p.add((Component)this.export, GBC.std());
        p.add((Component)lbl, GBC.std());
        p.add(GBC.glue((int)1, (int)0), GBC.std().fill(2));
        return p;
    }

    public Element export(SessionWriter.ExportSupport support) throws IOException {
        Element layerElem = support.createElement("layer");
        layerElem.setAttribute("type", "piclayerImage");
        layerElem.setAttribute("version", "0.1");
        for (ImageEntry entry : ((PicLayerAbstract)this.layer).getImages()) {
            Element imgElem = support.createElement("piclayerImage");
            if (entry.getFile() == null) {
                Logging.warn((String)"No file attribute for image - skipping entry");
                break;
            }
            PicLayerAbstractSessionExporter.addAttr("file", entry.getFile().getPath(), imgElem, support);
            PicLayerAbstractSessionExporter.addAttr("thumbnail", Boolean.toString(entry.hasThumbnail()), imgElem, support);
            if (entry.getPos() != null) {
                Element posElem = support.createElement("position");
                posElem.setAttribute("lat", Double.toString(entry.getPos().lat()));
                posElem.setAttribute("lon", Double.toString(entry.getPos().lon()));
                imgElem.appendChild(posElem);
            }
            layerElem.appendChild(imgElem);
        }
        return layerElem;
    }

    protected static void addAttr(String name, String value, Element element, SessionWriter.ExportSupport support) {
        Element attrElem = support.createElement(name);
        attrElem.appendChild(support.createTextNode(value));
        element.appendChild(attrElem);
    }
}

