/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.actions.transform.autocalibrate.helper;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;

public class ObservableArrayList<E>
extends ArrayList<E> {
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public ObservableArrayList() {
    }

    public ObservableArrayList(int cap) {
        super(cap);
    }

    public ObservableArrayList(Collection<? extends E> c) {
        super(c);
    }

    @Override
    public boolean add(E e) {
        int oldSize = super.size();
        if (super.add(e)) {
            this.changes.firePropertyChange("size", oldSize, super.size());
            return true;
        }
        return false;
    }

    @Override
    public void add(int index, E element) {
        int oldSize = super.size();
        super.add(index, element);
        this.changes.firePropertyChange("size", oldSize, super.size());
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        int oldSize = super.size();
        if (super.addAll(c)) {
            this.changes.firePropertyChange("size", oldSize, super.size());
            return true;
        }
        return false;
    }

    @Override
    public E remove(int index) {
        int oldSize = super.size();
        Object removed = super.remove(index);
        this.changes.firePropertyChange("size", oldSize, super.size());
        return removed;
    }

    @Override
    public boolean remove(Object o) {
        int oldSize = super.size();
        if (super.remove(o)) {
            this.changes.firePropertyChange("size", oldSize, super.size());
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        int oldSize = super.size();
        super.clear();
        this.changes.firePropertyChange("size", oldSize, super.size());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public void removeAllListener() {
        PropertyChangeListener[] listener = this.changes.getPropertyChangeListeners();
        int size = listener.length;
        for (int i = 0; i < size; ++i) {
            this.changes.removePropertyChangeListener(listener[i]);
        }
    }
}

