/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.actions.transform.affine;

import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.piclayer.actions.GenericPicTransformAction;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class MovePointAction
extends GenericPicTransformAction {
    public MovePointAction() {
        super(I18n.tr((String)"PicLayer Move point", (Object[])new Object[0]), I18n.tr((String)"Point added/moved", (Object[])new Object[0]), "movepoint", I18n.tr((String)"Drag or create point on the picture", (Object[])new Object[0]), ImageProvider.getCursor((String)"crosshair", null));
    }

    @Override
    protected void doAction(MouseEvent e) {
        try {
            Point2D pressed = this.currentLayer.transformPoint(e.getPoint());
            if (this.selectedPoint != null) {
                this.currentLayer.getTransformer().replaceOriginPoint(this.selectedPoint, pressed);
                this.selectedPoint = pressed;
            }
        }
        catch (NoninvertibleTransformException e1) {
            Logging.error((Throwable)e1);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.currentLayer == null) {
            return;
        }
        try {
            this.setLatLonOriginPoints(e.getPoint());
            Point2D pressed = this.currentLayer.transformPoint(e.getPoint());
            if (this.selectedPoint == null) {
                this.currentLayer.getTransformer().addOriginPoint(pressed);
            }
            this.currentCommand.addIfChanged();
        }
        catch (NoninvertibleTransformException e1) {
            Logging.error((Throwable)e1);
        }
    }

    @Override
    public void enterMode() {
        super.enterMode();
        this.updateDrawPoints(true);
    }

    @Override
    public void exitMode() {
        super.exitMode();
        this.updateDrawPoints(false);
    }

    private void setLatLonOriginPoints(Point2D point) {
        LatLon latLonPoint = MainApplication.getMap().mapView.getLatLon(point.getX(), point.getY());
        double latY = latLonPoint.getY();
        double lonX = latLonPoint.getX();
        this.currentLayer.getTransformer().addLatLonOriginPoint(new Point2D.Double(lonX, latY));
    }
}

