/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter.hasher;

import java.nio.charset.StandardCharsets;
import java.util.Locale;

public interface HashFunctionIdentity {
    public static String asCommonString(HashFunctionIdentity identity) {
        return String.format("%s-%s-%s", new Object[]{identity.getName(), identity.getSignedness(), identity.getProcessType()});
    }

    public static byte[] prepareSignatureBuffer(HashFunctionIdentity identity) {
        return String.format("%s-%s-%s", new Object[]{identity.getName().toUpperCase(Locale.ROOT), identity.getSignedness(), identity.getProcessType()}).getBytes(StandardCharsets.UTF_8);
    }

    public String getName();

    public ProcessType getProcessType();

    public String getProvider();

    public long getSignature();

    public Signedness getSignedness();

    public static enum Signedness {
        SIGNED,
        UNSIGNED;

    }

    public static enum ProcessType {
        CYCLIC,
        ITERATIVE;

    }
}

