/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter.hasher.function;

import java.util.Arrays;
import org.apache.commons.collections4.bloomfilter.hasher.HashFunction;
import org.apache.commons.collections4.bloomfilter.hasher.HashFunctionIdentity;

public final class ObjectsHashIterative
implements HashFunction {
    public static final String NAME = "Objects32";
    private final long signature = this.apply(HashFunctionIdentity.prepareSignatureBuffer(this), 0);
    private long last = 0L;

    @Override
    public long apply(byte[] buffer, int seed) {
        if (seed == 0) {
            this.last = 0L;
        }
        long result = Arrays.deepHashCode(new Object[]{this.last, buffer});
        this.last += result;
        return result;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public HashFunctionIdentity.ProcessType getProcessType() {
        return HashFunctionIdentity.ProcessType.ITERATIVE;
    }

    @Override
    public String getProvider() {
        return "Apache Commons Collections";
    }

    @Override
    public long getSignature() {
        return this.signature;
    }

    @Override
    public HashFunctionIdentity.Signedness getSignedness() {
        return HashFunctionIdentity.Signedness.SIGNED;
    }
}

