/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter.hasher;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import org.apache.commons.collections4.bloomfilter.hasher.HashFunction;
import org.apache.commons.collections4.bloomfilter.hasher.HashFunctionIdentity;
import org.apache.commons.collections4.bloomfilter.hasher.HashFunctionValidator;
import org.apache.commons.collections4.bloomfilter.hasher.Hasher;
import org.apache.commons.collections4.bloomfilter.hasher.Shape;

public class DynamicHasher
implements Hasher {
    private final List<byte[]> buffers;
    private final HashFunction function;

    public DynamicHasher(HashFunction function, List<byte[]> buffers) {
        this.buffers = new ArrayList<byte[]>(buffers);
        this.function = function;
    }

    @Override
    public PrimitiveIterator.OfInt getBits(Shape shape) {
        HashFunctionValidator.checkAreEqual(this.getHashFunctionIdentity(), shape.getHashFunctionIdentity());
        return this.buffers.isEmpty() ? NoValuesIterator.INSTANCE : new Iterator(shape);
    }

    @Override
    public HashFunctionIdentity getHashFunctionIdentity() {
        return this.function;
    }

    @Override
    public boolean isEmpty() {
        return this.buffers.isEmpty();
    }

    private static class NoValuesIterator
    implements PrimitiveIterator.OfInt {
        private static final NoValuesIterator INSTANCE = new NoValuesIterator();

        private NoValuesIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int nextInt() {
            throw new NoSuchElementException();
        }
    }

    private class Iterator
    implements PrimitiveIterator.OfInt {
        private int buffer = 0;
        private int funcCount = 0;
        private final Shape shape;

        private Iterator(Shape shape) {
            this.shape = shape;
        }

        @Override
        public boolean hasNext() {
            return this.buffer < DynamicHasher.this.buffers.size() - 1 || this.funcCount < this.shape.getNumberOfHashFunctions();
        }

        @Override
        public int nextInt() {
            if (this.hasNext()) {
                if (this.funcCount >= this.shape.getNumberOfHashFunctions()) {
                    this.funcCount = 0;
                    ++this.buffer;
                }
                return (int)Math.floorMod(DynamicHasher.this.function.apply((byte[])DynamicHasher.this.buffers.get(this.buffer), this.funcCount++), (long)this.shape.getNumberOfBits());
            }
            throw new NoSuchElementException();
        }
    }

    public static class Builder
    implements Hasher.Builder {
        private final List<byte[]> buffers;
        private final HashFunction function;

        public Builder(HashFunction function) {
            this.function = function;
            this.buffers = new ArrayList<byte[]>();
        }

        @Override
        public DynamicHasher build() throws IllegalArgumentException {
            return new DynamicHasher(this.function, this.buffers);
        }

        @Override
        public final Builder with(byte property) {
            return this.with(new byte[]{property});
        }

        @Override
        public final Builder with(byte[] property) {
            this.buffers.add(property);
            return this;
        }

        @Override
        public final Builder with(String property) {
            return this.with(property.getBytes(StandardCharsets.UTF_8));
        }
    }
}

