/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.hasher.Shape;

public final class SetOperations {
    public static double cosineDistance(BloomFilter first, BloomFilter second) {
        return 1.0 - SetOperations.cosineSimilarity(first, second);
    }

    public static double cosineSimilarity(BloomFilter first, BloomFilter second) {
        SetOperations.verifyShape(first, second);
        int numerator = first.andCardinality(second);
        return numerator == 0 ? 0.0 : (double)numerator / (Math.sqrt(first.cardinality()) * Math.sqrt(second.cardinality()));
    }

    public static long estimateIntersectionSize(BloomFilter first, BloomFilter second) {
        SetOperations.verifyShape(first, second);
        return SetOperations.estimateSize(first) - SetOperations.estimateUnionSize(first, second) + SetOperations.estimateSize(second);
    }

    public static long estimateSize(BloomFilter filter) {
        Shape shape = filter.getShape();
        double estimate = -((double)shape.getNumberOfBits() * Math.log(1.0 - (double)filter.cardinality() * 1.0 / (double)shape.getNumberOfBits())) / (double)shape.getNumberOfHashFunctions();
        return Math.round(estimate);
    }

    public static long estimateUnionSize(BloomFilter first, BloomFilter second) {
        SetOperations.verifyShape(first, second);
        Shape shape = first.getShape();
        double estimate = -((double)shape.getNumberOfBits() * Math.log(1.0 - (double)first.orCardinality(second) * 1.0 / (double)shape.getNumberOfBits())) / (double)shape.getNumberOfHashFunctions();
        return Math.round(estimate);
    }

    public static int hammingDistance(BloomFilter first, BloomFilter second) {
        SetOperations.verifyShape(first, second);
        return first.xorCardinality(second);
    }

    public static double jaccardDistance(BloomFilter first, BloomFilter second) {
        return 1.0 - SetOperations.jaccardSimilarity(first, second);
    }

    public static double jaccardSimilarity(BloomFilter first, BloomFilter second) {
        SetOperations.verifyShape(first, second);
        int orCard = first.orCardinality(second);
        return orCard == 0 ? 0.0 : (double)SetOperations.hammingDistance(first, second) / (double)orCard;
    }

    private static void verifyShape(BloomFilter first, BloomFilter second) {
        if (!first.getShape().equals(second.getShape())) {
            throw new IllegalArgumentException(String.format("Shape %s is not the same as %s", first.getShape(), second.getShape()));
        }
    }

    private SetOperations() {
    }
}

