/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.PrimitiveIterator;
import java.util.function.LongBinaryOperator;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.BloomFilterIndexer;
import org.apache.commons.collections4.bloomfilter.hasher.HashFunctionIdentity;
import org.apache.commons.collections4.bloomfilter.hasher.Hasher;
import org.apache.commons.collections4.bloomfilter.hasher.Shape;
import org.apache.commons.collections4.bloomfilter.hasher.StaticHasher;

public abstract class AbstractBloomFilter
implements BloomFilter {
    private final Shape shape;

    protected AbstractBloomFilter(Shape shape) {
        this.shape = shape;
    }

    @Override
    public int andCardinality(BloomFilter other) {
        this.verifyShape(other);
        long[] mine = this.getBits();
        long[] theirs = other.getBits();
        int limit = Integer.min(mine.length, theirs.length);
        int count = 0;
        for (int i = 0; i < limit; ++i) {
            count += Long.bitCount(mine[i] & theirs[i]);
        }
        return count;
    }

    @Override
    public int cardinality() {
        int count = 0;
        for (long bits : this.getBits()) {
            count += Long.bitCount(bits);
        }
        return count;
    }

    @Override
    public boolean contains(BloomFilter other) {
        this.verifyShape(other);
        return other.cardinality() == this.andCardinality(other);
    }

    @Override
    public boolean contains(Hasher hasher) {
        this.verifyHasher(hasher);
        long[] buff = this.getBits();
        PrimitiveIterator.OfInt iter = hasher.getBits(this.shape);
        while (iter.hasNext()) {
            long buffOffset;
            int idx = iter.nextInt();
            BloomFilterIndexer.checkPositive(idx);
            int buffIdx = BloomFilterIndexer.getLongIndex(idx);
            if ((buff[buffIdx] & (buffOffset = BloomFilterIndexer.getLongBit(idx))) != 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public abstract long[] getBits();

    @Override
    public abstract StaticHasher getHasher();

    @Override
    public final Shape getShape() {
        return this.shape;
    }

    public final boolean isFull() {
        return this.cardinality() == this.getShape().getNumberOfBits();
    }

    @Override
    public abstract void merge(BloomFilter var1);

    @Override
    public abstract void merge(Hasher var1);

    @Override
    public int orCardinality(BloomFilter other) {
        return this.opCardinality(other, (a, b) -> a | b);
    }

    protected void verifyHasher(Hasher hasher) {
        if (this.shape.getHashFunctionIdentity().getSignature() != hasher.getHashFunctionIdentity().getSignature()) {
            throw new IllegalArgumentException(String.format("Hasher (%s) is not the hasher for shape (%s)", HashFunctionIdentity.asCommonString(hasher.getHashFunctionIdentity()), this.shape.toString()));
        }
    }

    protected void verifyShape(BloomFilter other) {
        this.verifyShape(other.getShape());
    }

    protected void verifyShape(Shape shape) {
        if (!this.shape.equals(shape)) {
            throw new IllegalArgumentException(String.format("Shape %s is not the same as %s", shape, this.shape));
        }
    }

    @Override
    public int xorCardinality(BloomFilter other) {
        return this.opCardinality(other, (a, b) -> a ^ b);
    }

    private int opCardinality(BloomFilter other, LongBinaryOperator operation) {
        int i;
        long[] small;
        long[] big;
        this.verifyShape(other);
        long[] mine = this.getBits();
        long[] theirs = other.getBits();
        if (mine.length > theirs.length) {
            big = mine;
            small = theirs;
        } else {
            small = mine;
            big = theirs;
        }
        int count = 0;
        for (i = 0; i < small.length; ++i) {
            count += Long.bitCount(operation.applyAsLong(small[i], big[i]));
        }
        for (i = small.length; i < big.length; ++i) {
            count += Long.bitCount(big[i]);
        }
        return count;
    }
}

