/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.compare;

import java.util.function.Predicate;

public class ComparableUtils {
    public static <A extends Comparable<A>> Predicate<A> between(A a, A a2) {
        return comparable3 -> ComparableUtils.is(comparable3).between(a, a2);
    }

    public static <A extends Comparable<A>> Predicate<A> betweenExclusive(A a, A a2) {
        return comparable3 -> ComparableUtils.is(comparable3).betweenExclusive(a, a2);
    }

    public static <A extends Comparable<A>> Predicate<A> ge(A a) {
        return comparable2 -> ComparableUtils.is(comparable2).greaterThanOrEqualTo(a);
    }

    public static <A extends Comparable<A>> Predicate<A> gt(A a) {
        return comparable2 -> ComparableUtils.is(comparable2).greaterThan(a);
    }

    public static <A extends Comparable<A>> ComparableCheckBuilder<A> is(A a) {
        return new ComparableCheckBuilder(a, null);
    }

    public static <A extends Comparable<A>> Predicate<A> le(A a) {
        return comparable2 -> ComparableUtils.is(comparable2).lessThanOrEqualTo(a);
    }

    public static <A extends Comparable<A>> Predicate<A> lt(A a) {
        return comparable2 -> ComparableUtils.is(comparable2).lessThan(a);
    }

    private ComparableUtils() {
    }

    public static class ComparableCheckBuilder<A extends Comparable<A>> {
        private final A a;

        private ComparableCheckBuilder(A a) {
            this.a = a;
        }

        public boolean between(A a, A a2) {
            return this.betweenOrdered(a, a2) || this.betweenOrdered(a2, a);
        }

        public boolean betweenExclusive(A a, A a2) {
            return this.betweenOrderedExclusive(a, a2) || this.betweenOrderedExclusive(a2, a);
        }

        private boolean betweenOrdered(A a, A a2) {
            return this.greaterThanOrEqualTo(a) && this.lessThanOrEqualTo(a2);
        }

        private boolean betweenOrderedExclusive(A a, A a2) {
            return this.greaterThan(a) && this.lessThan(a2);
        }

        public boolean equalTo(A a) {
            return this.a.compareTo(a) == 0;
        }

        public boolean greaterThan(A a) {
            return this.a.compareTo(a) > 0;
        }

        public boolean greaterThanOrEqualTo(A a) {
            return this.a.compareTo(a) >= 0;
        }

        public boolean lessThan(A a) {
            return this.a.compareTo(a) < 0;
        }

        public boolean lessThanOrEqualTo(A a) {
            return this.a.compareTo(a) <= 0;
        }

        /* synthetic */ ComparableCheckBuilder(Comparable comparable, 1 var2_2) {
            this(comparable);
        }
    }
}

