/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter.hasher;

import java.util.Objects;
import org.apache.commons.collections4.bloomfilter.hasher.HashFunctionIdentity;
import org.apache.commons.collections4.bloomfilter.hasher.HashFunctionValidator;

public class Shape {
    private static final double LOG_OF_2 = Math.log(2.0);
    private static final double DENOMINATOR = Math.log(1.0 / Math.pow(2.0, LOG_OF_2));
    private final int numberOfItems;
    private final int numberOfBits;
    private final int numberOfHashFunctions;
    private final int hashCode;
    private final HashFunctionIdentity hashFunctionIdentity;

    public Shape(HashFunctionIdentity hashFunctionIdentity, double probability, int numberOfBits, int numberOfHashFunctions) {
        Objects.requireNonNull(hashFunctionIdentity, "hashFunctionIdentity");
        if (probability <= 0.0) {
            throw new IllegalArgumentException("Probability must be greater than 0.0");
        }
        if (probability >= 1.0) {
            throw new IllegalArgumentException("Probability must be less than 1.0");
        }
        if (numberOfBits < 8) {
            throw new IllegalArgumentException("Number of bits must be greater than or equal to 8");
        }
        if (numberOfHashFunctions < 1) {
            throw new IllegalArgumentException("Number of hash functions must be greater than or equal to 8");
        }
        this.hashFunctionIdentity = hashFunctionIdentity;
        this.numberOfBits = numberOfBits;
        this.numberOfHashFunctions = numberOfHashFunctions;
        double n = Math.ceil((double)numberOfBits / ((double)(-numberOfHashFunctions) / Math.log(1.0 - Math.exp(Math.log(probability) / (double)numberOfHashFunctions))));
        this.numberOfItems = (int)n;
        this.hashCode = this.generateHashCode();
        this.getProbability();
    }

    public Shape(HashFunctionIdentity hashFunctionIdentity, int numberOfItems, double probability) {
        Objects.requireNonNull(hashFunctionIdentity, "hashFunctionIdentity");
        if (numberOfItems < 1) {
            throw new IllegalArgumentException("Number of Items must be greater than 0");
        }
        if (probability <= 0.0) {
            throw new IllegalArgumentException("Probability must be greater than 0.0");
        }
        if (probability >= 1.0) {
            throw new IllegalArgumentException("Probability must be less than 1.0");
        }
        this.hashFunctionIdentity = hashFunctionIdentity;
        this.numberOfItems = numberOfItems;
        double m = Math.ceil((double)numberOfItems * Math.log(probability) / DENOMINATOR);
        if (m > 2.147483647E9) {
            throw new IllegalArgumentException("Resulting filter has more than 2147483647 bits");
        }
        this.numberOfBits = (int)m;
        this.numberOfHashFunctions = Shape.calculateNumberOfHashFunctions(numberOfItems, this.numberOfBits);
        this.hashCode = this.generateHashCode();
        this.getProbability();
    }

    public Shape(HashFunctionIdentity hashFunctionIdentity, int numberOfItems, int numberOfBits) {
        Objects.requireNonNull(hashFunctionIdentity, "hashFunctionIdentity");
        if (numberOfItems < 1) {
            throw new IllegalArgumentException("Number of Items must be greater than 0");
        }
        if (numberOfBits < 8) {
            throw new IllegalArgumentException("Number of Bits must be greater than or equal to 8");
        }
        this.hashFunctionIdentity = hashFunctionIdentity;
        this.numberOfItems = numberOfItems;
        this.numberOfBits = numberOfBits;
        this.numberOfHashFunctions = Shape.calculateNumberOfHashFunctions(numberOfItems, numberOfBits);
        this.hashCode = this.generateHashCode();
        this.getProbability();
    }

    public Shape(HashFunctionIdentity hashFunctionIdentity, int numberOfItems, int numberOfBits, int numberOfHashFunctions) {
        Objects.requireNonNull(hashFunctionIdentity, "hashFunctionIdentity");
        if (numberOfItems < 1) {
            throw new IllegalArgumentException("Number of Items must be greater than 0");
        }
        if (numberOfBits < 8) {
            throw new IllegalArgumentException("Number of Bits must be greater than or equal to 8");
        }
        if (numberOfHashFunctions < 1) {
            throw new IllegalArgumentException("Number of Hash Functions must be greater than or equal to 8");
        }
        this.hashFunctionIdentity = hashFunctionIdentity;
        this.numberOfItems = numberOfItems;
        this.numberOfBits = numberOfBits;
        this.numberOfHashFunctions = numberOfHashFunctions;
        this.hashCode = this.generateHashCode();
        this.getProbability();
    }

    private static int calculateNumberOfHashFunctions(int numberOfItems, int numberOfBits) {
        long k = Math.round(LOG_OF_2 * (double)numberOfBits / (double)numberOfItems);
        if (k < 1L) {
            throw new IllegalArgumentException(String.format("Filter to small: Calculated number of hash functions (%s) was less than 1", k));
        }
        return (int)k;
    }

    public boolean equals(Object o) {
        if (o instanceof Shape) {
            Shape other = (Shape)o;
            return other.getNumberOfBits() == this.getNumberOfBits() && other.getNumberOfHashFunctions() == this.getNumberOfHashFunctions() && HashFunctionValidator.areEqual(this.getHashFunctionIdentity(), other.getHashFunctionIdentity());
        }
        return false;
    }

    private int generateHashCode() {
        return Objects.hash(this.hashFunctionIdentity, this.numberOfBits, this.numberOfHashFunctions);
    }

    public HashFunctionIdentity getHashFunctionIdentity() {
        return this.hashFunctionIdentity;
    }

    public int getNumberOfBits() {
        return this.numberOfBits;
    }

    public int getNumberOfBytes() {
        return Double.valueOf(Math.ceil((double)this.numberOfBits / 8.0)).intValue();
    }

    public int getNumberOfHashFunctions() {
        return this.numberOfHashFunctions;
    }

    public int getNumberOfItems() {
        return this.numberOfItems;
    }

    public final double getProbability() {
        double p = Math.pow(1.0 - Math.exp(-1.0 * (double)this.numberOfHashFunctions * (double)this.numberOfItems / (double)this.numberOfBits), this.numberOfHashFunctions);
        if (p >= 1.0) {
            throw new IllegalArgumentException(String.format("Calculated probability (%s) is greater than or equal to 1.0", p));
        }
        return p;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return String.format("Shape[ %s n=%s m=%s k=%s ]", HashFunctionIdentity.asCommonString(this.hashFunctionIdentity), this.numberOfItems, this.numberOfBits, this.numberOfHashFunctions);
    }
}

