/*
 * Decompiled with CFR 0.152.
 */
package controller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import model.IndoorHelperModel;
import model.IndoorLevel;
import model.TagCatalog;
import org.openstreetmap.josm.actions.ValidateAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmDataManager;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.help.HelpBrowser;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.MapListSetting;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import views.LevelSelectorView;
import views.ToolBoxView;

public class IndoorHelperController {
    private final IndoorHelperModel model = new IndoorHelperModel();
    private ToolBoxView toolboxView;
    private String levelValue;
    private String levelNum;
    private final SpaceAction spaceAction = new SpaceAction();
    private Shortcut spaceShortcut;
    private final EnterAction enterAction = new EnterAction();
    private Shortcut enterShortcut;
    private boolean outerHelp;
    private boolean innerHelp;
    private boolean levelHelp;
    private Collection<OsmPrimitive> innerRelation;
    private LevelSelectorView selectorView;
    private final ActionListener toolApplyButtonListener = e -> {
        TagCatalog.IndoorObject indoorObject = this.toolboxView.getSelectedObject();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (!this.toolboxView.getLevelCheckBoxStatus() && !this.levelValue.equals("")) {
            tags.add(new Tag("level", this.levelValue));
        }
        if (!this.toolboxView.getLevelNameText().isEmpty() && !this.toolboxView.getLevelCheckBoxStatus()) {
            tags.add(new Tag("level_name", this.toolboxView.getLevelNameText()));
        }
        if (!this.toolboxView.getNameText().isEmpty()) {
            tags.add(new Tag("name", this.toolboxView.getNameText()));
        }
        if (!this.toolboxView.getRefText().isEmpty()) {
            tags.add(new Tag("ref", this.toolboxView.getRefText()));
        }
        if (!this.toolboxView.getRepeatOnText().isEmpty()) {
            tags.add(new Tag("repeat_on", this.toolboxView.getRepeatOnText()));
        }
        if (!this.toolboxView.getLevelNameText().isEmpty() && !this.toolboxView.getLevelCheckBoxStatus()) {
            tags.add(new Tag("level_name", this.toolboxView.getLevelNameText()));
        }
        this.model.addTagsToOSM(indoorObject, tags);
        this.toolboxView.resetUiElements();
        new ValidateAction().doValidate(true);
        this.refreshPresets();
    };
    private final ItemListener toolObjectItemListener = e -> {
        if (this.toolboxView.getSelectedObject().equals((Object)TagCatalog.IndoorObject.ROOM)) {
            this.toolboxView.setNRUiElementsEnabled(true);
            this.toolboxView.setROUiElementsEnabled(false);
        } else if (this.toolboxView.getSelectedObject().equals((Object)TagCatalog.IndoorObject.STEPS) || this.toolboxView.getSelectedObject().equals((Object)TagCatalog.IndoorObject.ELEVATOR)) {
            this.toolboxView.setROUiElementsEnabled(true);
            this.toolboxView.setNRUiElementsEnabled(true);
        } else {
            this.toolboxView.setROUiElementsEnabled(false);
        }
    };
    private final ItemListener toolLevelCheckBoxListener = e -> this.toolboxView.setLVLUiElementsEnabled(e.getStateChange() != 1);
    private final ActionListener toolHelpButtonListener = e -> HelpBrowser.setUrlForHelpTopic((String)"Plugin/IndoorHelper");
    private final ActionListener toolAddLevelButtonListener = e -> {
        if (this.selectorView == null) {
            this.selectorView = new LevelSelectorView();
            this.addLevelSelectorListeners();
            this.selectorView.setVisible(true);
        } else {
            this.selectorView.toFront();
        }
    };
    private final ItemListener toolMultiCheckBoxListener = e -> this.toolboxView.setMultiUiElementsEnabled(e.getStateChange() != 1);
    private final ActionListener toolOuterButtonListener = e -> {
        MainApplication.getMap().selectDrawTool(false);
        this.outerHelp = true;
        this.innerHelp = false;
    };
    private final ActionListener toolInnerButtonListener = e -> {
        MainApplication.getMap().selectDrawTool(false);
        this.innerHelp = true;
        this.outerHelp = false;
    };
    private final ActionListener preset1Listener = e -> this.model.addTagsToOSM(this.toolboxView.getPreset1());
    private final ActionListener preset2Listener = e -> this.model.addTagsToOSM(this.toolboxView.getPreset2());
    private final ActionListener preset3Listener = e -> this.model.addTagsToOSM(this.toolboxView.getPreset3());
    private final ActionListener preset4Listener = e -> this.model.addTagsToOSM(this.toolboxView.getPreset4());
    private final ActionListener toolLevelOkButtonListener = e -> {
        this.levelHelp = true;
        if (!this.selectorView.getLevelNumber().equals("")) {
            this.levelNum = this.selectorView.getLevelNumber();
            this.selectorView.dispose();
            MainApplication.getMap().selectDrawTool(false);
        } else {
            JOptionPane.showMessageDialog(null, I18n.tr((String)"Please insert a value.", (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
        }
        this.selectorView = null;
    };
    private final ActionListener toolLevelCancelButtonListener = e -> {
        this.selectorView.dispose();
        this.selectorView = null;
    };

    private void refreshPresets() {
        this.toolboxView.setPresetButtons(this.model.getPresetRanking());
    }

    public IndoorHelperController() {
        this.toolboxView = new ToolBoxView();
        IndoorHelperController.setPluginPreferences(true);
        this.toolboxView.setAllUiElementsEnabled(true);
        this.toolboxView.setROUiElementsEnabled(false);
        this.addToolboxListeners();
        MainApplication.getMap().addToggleDialog((ToggleDialog)this.toolboxView);
        this.spaceShortcut = Shortcut.registerShortcut((String)"mapmode:space", (String)"ConfirmObjectDrawing", (int)32, (int)5003);
        MainApplication.registerActionShortcut((Action)this.spaceAction, (Shortcut)this.spaceShortcut);
        this.enterShortcut = Shortcut.registerShortcut((String)"mapmode:enter", (String)"ConfirmMultipolygonSelection", (int)10, (int)5003);
        MainApplication.registerActionShortcut((Action)this.enterAction, (Shortcut)this.enterShortcut);
        this.outerHelp = false;
        this.innerHelp = false;
        this.levelHelp = false;
        this.innerRelation = null;
        this.levelValue = "";
        this.levelNum = "";
    }

    private void addToolboxListeners() {
        if (this.toolboxView != null) {
            this.toolboxView.setApplyButtonListener(this.toolApplyButtonListener);
            this.toolboxView.setLevelCheckBoxListener(this.toolLevelCheckBoxListener);
            this.toolboxView.setHelpButtonListener(this.toolHelpButtonListener);
            this.toolboxView.setAddLevelButtonListener(this.toolAddLevelButtonListener);
            this.toolboxView.setObjectItemListener(this.toolObjectItemListener);
            this.toolboxView.setOuterButtonListener(this.toolOuterButtonListener);
            this.toolboxView.setInnerButtonListener(this.toolInnerButtonListener);
            this.toolboxView.setMultiCheckBoxListener(this.toolMultiCheckBoxListener);
            this.toolboxView.setPreset1Listener(this.preset1Listener);
            this.toolboxView.setPreset2Listener(this.preset2Listener);
            this.toolboxView.setPreset3Listener(this.preset3Listener);
            this.toolboxView.setPreset4Listener(this.preset4Listener);
        }
    }

    private void addLevelSelectorListeners() {
        if (this.selectorView != null) {
            this.selectorView.setOkButtonListener(this.toolLevelOkButtonListener);
            this.selectorView.setCancelButtonListener(this.toolLevelCancelButtonListener);
            this.selectorView.setSelectorWindowListener(new ToolSelectorWindowSListener());
        }
    }

    public void unsetSpecificKeyFilter(String key) {
        DataSet editDataSet = OsmDataManager.getInstance().getEditDataSet();
        if (editDataSet != null) {
            Collection p = editDataSet.allPrimitives();
            int level = Integer.parseInt(this.levelValue);
            for (OsmPrimitive osm : p) {
                if (!osm.isDisabledAndHidden() && !osm.isDisabled() || !osm.hasKey(key)) continue;
                for (Map.Entry e : osm.getInterestingTags().entrySet()) {
                    if (!((String)e.getKey()).equals(key)) continue;
                    if (IndoorLevel.isPartOfWorkingLevel((String)e.getValue(), level)) {
                        osm.unsetDisabledState();
                        continue;
                    }
                    osm.setDisabledState(true);
                }
            }
        }
    }

    public void setIndoorLevel(String indoorLevel) {
        this.toolboxView.setLevelLabel(indoorLevel);
    }

    public void getIndoorLevel(String indoorLevel) {
        this.levelValue = indoorLevel;
    }

    private static void updateSettings() {
        Preferences.main().init(false);
        MapPaintStyles.readFromPreferences();
    }

    private static void setPluginPreferences(boolean enabled) {
        Map settings = Preferences.main().getAllSettings();
        String sep = System.getProperty("file.separator");
        MapListSetting styleMapListSetting = (MapListSetting)settings.get("mappaint.style.entries");
        List styleMaps = new ArrayList();
        if (styleMapListSetting != null) {
            styleMaps = (List)styleMapListSetting.getValue();
        }
        ArrayList styleMapsNew = new ArrayList();
        if (!styleMaps.isEmpty()) {
            styleMapsNew.addAll(styleMaps);
        }
        for (Map map : styleMapsNew) {
            if (!map.containsValue(I18n.tr((String)"Indoor", (Object[])new Object[0]))) continue;
            enabled = map.containsValue(I18n.tr((String)"true", (Object[])new Object[0]));
            styleMapsNew.remove(map);
            break;
        }
        HashMap<String, String> indoorMapPaint = new HashMap<String, String>();
        indoorMapPaint.put("title", I18n.tr((String)"Indoor", (Object[])new Object[0]));
        indoorMapPaint.put("active", Boolean.toString(enabled));
        indoorMapPaint.put("url", Config.getDirs().getUserDataDirectory(true) + sep + "styles" + sep + "sit.mapcss");
        styleMapsNew.add(indoorMapPaint);
        Config.getPref().putListOfMaps("mappaint.style.entries", styleMapsNew);
        IndoorHelperController.updateSettings();
    }

    private class EnterAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private EnterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (IndoorHelperController.this.innerHelp && !IndoorHelperController.this.outerHelp) {
                IndoorHelperController.this.model.editRelation("inner", IndoorHelperController.this.innerRelation);
                IndoorHelperController.this.innerHelp = false;
            } else if (IndoorHelperController.this.innerHelp && IndoorHelperController.this.outerHelp || IndoorHelperController.this.outerHelp && !IndoorHelperController.this.innerHelp) {
                JOptionPane.showMessageDialog(null, I18n.tr((String)"Please press spacebar first to add \"outer\" object to relation.", (Object[])new Object[0]), I18n.tr((String)"Relation-Error", (Object[])new Object[0]), 0);
                IndoorHelperController.this.innerHelp = false;
                IndoorHelperController.this.outerHelp = false;
            }
        }
    }

    private class SpaceAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private SpaceAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (IndoorHelperController.this.outerHelp) {
                IndoorHelperController.this.model.addRelation("outer");
                MainApplication.getMap().selectSelectTool(false);
                IndoorHelperController.this.outerHelp = false;
                MainApplication.getLayerManager().getEditDataSet().clearSelection();
            } else if (IndoorHelperController.this.innerHelp) {
                IndoorHelperController.this.innerRelation = MainApplication.getLayerManager().getEditDataSet().getAllSelected();
                MainApplication.getMap().selectSelectTool(false);
                MainApplication.getLayerManager().getEditDataSet().clearSelection();
            } else if (IndoorHelperController.this.levelHelp) {
                ArrayList<Tag> tags = new ArrayList<Tag>();
                tags.add(new Tag("level", IndoorHelperController.this.levelNum));
                IndoorHelperController.this.model.addTagsToOSM(tags);
                MainApplication.getMap().selectSelectTool(false);
                IndoorHelperController.this.levelHelp = false;
            }
        }
    }

    class ToolSelectorWindowSListener
    extends WindowAdapter {
        ToolSelectorWindowSListener() {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            IndoorHelperController.this.selectorView = null;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            IndoorHelperController.this.selectorView = null;
        }
    }
}

