/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.wms;

import java.io.Serializable;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;

public class EastNorthBound
implements Serializable {
    private static final long serialVersionUID = 8451650309216472069L;
    public EastNorth min;
    public EastNorth max;

    public EastNorthBound(EastNorth min, EastNorth max) {
        this.min = min;
        this.max = max;
    }

    public boolean contains(EastNorth eastNorth) {
        if (eastNorth.east() < this.min.east() || eastNorth.north() < this.min.north()) {
            return false;
        }
        return !(eastNorth.east() > this.max.east()) && !(eastNorth.north() > this.max.north());
    }

    public EastNorthBound interpolate(EastNorthBound en2, double proportion) {
        EastNorthBound enb = new EastNorthBound(this.min.interpolate(en2.min, proportion), this.max.interpolate(en2.max, proportion));
        return enb;
    }

    public Bounds toBounds() {
        return new Bounds(ProjectionRegistry.getProjection().eastNorth2latlon(this.min), ProjectionRegistry.getProjection().eastNorth2latlon(this.max));
    }

    public String toString() {
        return "EastNorthBound[" + this.min.east() + "," + this.min.north() + "," + this.max.east() + "," + this.max.north() + "]";
    }
}

